#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

"""
@time: 2020/06/08
@file: bmc_ip_config.py
@function:
"""

from Common.base import entity
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.service.acpi_spcr_service import AcpiSpcrService

PY_JAVA_ENV = py_java_env


def execute(task):
    logger = entity.create_logger(__file__)
    err_msgs = []
    try:
        AcpiSpcrService(PY_JAVA_ENV).open_spcr()
        return ResultFactory.create_pass("", err_msgs)
    except DeployException as e:
        logger.error(e.message)
        err_msgs.append(e.err_msg)
        if e.may_info_miss():
            task.openAutoRetry()
        return ResultFactory.create_not_pass(e.origin_info, err_msgs)
