#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
@time: 2021/03/12
@file: config_vdm_config_enable_strategy.py
@function:
"""

import traceback
from Common.base import context_util
from Common.base import entity
from Common.base.constant import MsgKey
from Common.base.entity import ResultFactory
from Common.base.entity import DeployException
from Common.protocol.redfish.redfish_util import get_all_bios_info, \
    set_one_bios_info

PY_JAVA_ENV = py_java_env
BIOS_KEY = "VMDConfigEnable"
BIOS_SHOULD_VALUE = "Disabled"


def execute(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)

    # BIOS设置
    try:
        bios_info, resource = get_all_bios_info(login_info, logger)
        value = bios_info.get(BIOS_KEY)
        logger.info("The dev VMDConfigEnable value: {}".format(value))
        if not value:
            return ResultFactory.create_not_pass(
                resource, entity.create_msg(MsgKey.OBTAIN_INFO_FAILED))
        if value != BIOS_SHOULD_VALUE:
            set_one_bios_info(login_info, BIOS_KEY, BIOS_SHOULD_VALUE, logger)
        return ResultFactory.create_pass(resource)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
