#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.

"""
@time: 2022/06/14
@file: lit_indicator.py
@function: 开灯
"""
import traceback

from Common.base import context_util
from Common.base import entity
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.protocol.redfish import redfish_util

PY_JAVA_ENV = py_java_env


def execute(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    login_info.ip = task.getNowIp()
    try:
        blade_id = redfish_util.get_blade_id(login_info, logger)
        indicator_led_state = redfish_util.get_indicator_LED_state(
            login_info, blade_id, logger)
        if "Off" != indicator_led_state:
            logger.info("indicator LED not Off.")
            redfish_util.modify_indicator_LED_state(login_info,
                                                    blade_id, "Off",
                                                    logger)
        origin_info = redfish_util.modify_indicator_LED_state(
            login_info, blade_id, "Lit", logger)
    except DeployException as de:
        logger.error("lit the indicator fail, {}".format(de.message))
        logger.error("lit the indicator fail, {}".format(str(traceback.format_exc())))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
    return ResultFactory.create_pass(origin_info, entity.create_msg(
        "progress.finish"))
