#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2024. All rights reserved.

"""
@time: 2020/06/08
@file: bmc_ip_config.py
@function:
"""
import traceback

from Common.base import context_util
from Common.base import entity
from Common.base.entity import DeployException
from Common.base.entity import ResultFactory
from Common.protocol.redfish import redfish_util
from com.huawei.ism.tool.distributeddeploy.logic.config import ProductStrategy

PY_JAVA_ENV = py_java_env


def lit_indicator_LED(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    login_info.ip = task.getNowIp()
    try:
        blade_id = redfish_util.get_blade_id(login_info, logger)
        indicator_LED_state = redfish_util.get_indicator_LED_state(
            login_info, blade_id, logger)
        if "Off" != indicator_LED_state:
            logger.info("indicator LED not Off.")
            redfish_util.modify_indicator_LED_state(login_info,
                                                    blade_id, "Off",
                                                    logger)
        origin_info = redfish_util.modify_indicator_LED_state(
            login_info, blade_id, "Lit", logger)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
    return ResultFactory.create_pass(origin_info, entity.create_msg(
        "progress.finish"))


def off_indicator_LED(task):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    login_info.ip = task.getNowIp()
    try:
        if not is_support(login_info, logger):
            return ResultFactory.create_not_pass("", entity.create_msg(
                "server.version.not.support"))
        blade_id = redfish_util.get_blade_id(login_info, logger)
        origin_info = redfish_util.modify_indicator_LED_state(
            login_info, blade_id, "Off", logger)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
    return ResultFactory.create_pass(origin_info, entity.create_msg(
        "progress.finish"))


def is_support(login_info, logger):
    product_unique_id, _ = redfish_util.get_product_unique_id(login_info,
                                                              logger)
    return ProductStrategy.INS.isSupport(product_unique_id)
