#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
"""
@time: 2023/5/26
@file: mount_iso_image.py
@function:
"""
import time

from Business.adaptor.java_adaptor import get_bmc_mount_task
from Common.base import context_util, entity
from Common.base.entity import DeployException, ResultFactory
from Common.protocol.redfish import redfish_util

PY_JAVA_ENV = py_java_env
UMOUNT_MEDIA = {"VmmControlType": "Disconnect"}


def execute(task):
    login_info = context_util.get_login_info(PY_JAVA_ENV)
    logger = entity.create_logger(__file__)

    try:
        entity.AutoBrushProgressTask(task, 60).start()
        # 检查是否已连接镜像，如果有，卸载当前镜像
        virtual_media = redfish_util.current_virtual_media(login_info, logger)
        if virtual_media.get("Inserted"):
            redfish_util.umount_current_virtual_media(login_info, UMOUNT_MEDIA, logger)
            time.sleep(10)
        # 挂载指定镜像
        local_iso_path = context_util.get_iso_image_path(PY_JAVA_ENV)
        deploy_node = context_util.get_deploy_node(PY_JAVA_ENV)
        if not get_bmc_mount_task().mountIsoImage(deploy_node.getIpAddress().getIp(), login_info.username,
                                                  login_info.password, local_iso_path):
            return ResultFactory.create_not_pass("", entity.create_msg("mount.iso.image.error"))
        return ResultFactory.create_pass()
    except DeployException as de:
        logger.error(de.message)
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
