#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/06/20
@file: reboot_server.py
@function:
"""
from Common.base.entity import ResultFactory
from Common.base import entity, context_util
from Common.base.entity import DeployException
from Common.protocol.redfish import redfish_util

LOGGER = entity.create_logger(__file__)


def execute(task):
    try:
        context = task.getJythonContext()
        if task.getParam() and hasattr(task.getParam(), "getIsReboot") and not task.getParam().getIsReboot():
            return ResultFactory.create_pass(err_msg=entity.create_msg("user.select.not.reboot"))
        entity.AutoBrushProgressTask(task, 360).start()
        redfish_util.reboot(True, context, context_util.get_login_info(context), LOGGER)
        return ResultFactory.create_pass()
    except DeployException as exception:
        return ResultFactory.create_not_pass(origin_info=exception.origin_info)
