# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.

from Common.base import context_util, entity
from Common.base.entity import DeployException
from Common.protocol.redfish.entity.http import HttpClient

LOGGER = entity.create_logger(__file__)


def execute(deploy_task):
    LOGGER.info("start release node")
    context = deploy_task.getJythonContext()
    login_info = context_util.get_login_info(context)
    try:
        HttpClient.release_session(login_info, LOGGER)
    except DeployException as exception:
        LOGGER.error("release filed", exception)
