#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2024. All rights reserved.

"""
@time: 2020/06/06
@file: constant.py
@function:
"""
from Business.adaptor import java_adaptor


class ItemStatus(object):
    PASS = "PASS"
    NOT_PASS = "NOT_PASS"


class SingleItemStatus(object):
    ITEM_PASS = "pass"
    ITEM_NOT_PASS = "not_pass"


class MsgKey(object):
    OBTAIN_INFO_FAILED = "obtain.information.failed"
    NOT_INVOLVE = "not.support"
    HTTP_ERROR = "http.error.common"


class Platform(object):
    TAI_SHAN_V1 = java_adaptor.get_platform().TAISHAN_V1.getId()
    TAI_SHAN_V2 = java_adaptor.get_platform().TAISHAN_V2.getId()
    X86_64 = java_adaptor.get_platform().X86_64.getId()
    ATLANTIC = java_adaptor.get_platform().ATLANTIC.getId()
    NEW_ATLANTIC = java_adaptor.get_platform().NEW_ATLANTIC.getId()
    SSM_ATLANTIC = java_adaptor.get_platform().SSM_ATLANTIC.getId()
    PACIFIC = java_adaptor.get_platform().PACIFIC.getId()
    X86_V6 = java_adaptor.get_platform().X86_V6.getId()
    EAST_SEA = java_adaptor.get_platform().EAST_SEA.getId()
    SI_NAN = java_adaptor.get_platform().SI_NAN.getId()
    NEW_SI_NAN = java_adaptor.get_platform().NEW_SI_NAN.getId()

    @staticmethod
    def is_proprietary_hardware_dev(platform_id):
        """
        是否是专有硬件设备
        :return: True/False
        """
        return platform_id in [Platform.PACIFIC, Platform.ATLANTIC, Platform.NEW_ATLANTIC, Platform.EAST_SEA,
                               Platform.SI_NAN, Platform.SSM_ATLANTIC, Platform.NEW_SI_NAN]

    @staticmethod
    def get_nic_pdf_key(platform_id):
        return platform_id + ".nic.bdf"

    @staticmethod
    def get_slot_pdf_key(platform_id, config_key):
        return platform_id + ".slot.bdf" + config_key


LANG = java_adaptor.get_application_context().getInstance().getCurrentLanguage().getLanguage()
LOGGER = java_adaptor.get_deploy_task().LOGGER

HAI_YAN_DEV_TYPES = ("2288X V5", "5288X V5")

# VE机型的主板类型的key后缀
VE_SUPPORTED_NUM = "_2.0"

HG_BOARD_TYPE = 'H01_HG_2P'

# V6机型的key后缀
V6_SUPPORTED_NUM = "_V6"
