#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2024. All rights reserved.

"""
@time: 2020/06/06
@file: resource.py
@function:
"""

MESSAGES_DICT = {
    "http.error.common": {
        "zh": u"执行命令异常，请结合原始信息确认异常原因，确认BMC 用户名或密码"
              u"是否正确、账号是否被锁定后重试，若重试不通过，请联系技术支持工程师",
        "en": "Command execution error. Determine the cause of the exception "
              "based on the original information, Checking whether the BMC "
              "user name or password is correct and and try again. If the "
              "retry fails, contact technical support engineers"
    },
    "os.version.not.support": {
        "zh": u"当前操作系统不支持。",
        "en": "The current OS is not supported."
    },
    "server.version.not.support": {
        "zh": u"当前服务器型号不支持",
        "en": "The current server model is not supported"
    },
    "obtain.information.failed": {
        "zh": u"查询信息异常，请结合原始信息确认异常原因，请确认\n 1.网络和设备是否正常\n"
              u" 2.用户名和密码是否正确\n 3.安全沙箱是否已关闭\n 确认后重试，若重试不通过，请联系技术支持工程师",
        "en": "Failed to query the information. Determine the cause of the "
              "exception based on the original information.\n 1.Check whether "
              "the network or device is normal.\n 2.Check user name or password "
              "is correct.\n 3.Check whether the security sandbox is disabled.\n Confirm and try again."
              "If the retry fails, contact technical support engineers."
    },
    "bbu.backup.for.cpu.off.no.value": {
        "zh": u"没有查询到服务器的BIOS配置中Back Up For Cpu Off选项的状态值，请根据产品文档中《设置BIOS》章节的指导排查解决。",
        "en": "If the value of Back Up For Cpu Off in the BIOS configuration of the server cannot be queried, "
              "rectify the fault by following the instructions provided in section \"Configuring the BIOS\" in "
              "the product documentation."
    },
    "bbu.backup.for.cpu.off.not.requirements": {
        "zh": u"当前服务器的BIOS配置中Back Up For Cpu Off选项状态不满足要求，请根据产品文档中《设置BIOS》章节的指导排查解决。",
        "en": "The status of Back Up For Cpu Off in the BIOS configuration of the current server does not meet "
              "requirements. rectify the fault by following the instructions provided in "
              "section \"Configuring the BIOS\" in the product documentation."
    },
    "sol.private.mode": {
        "zh": u"SOL连接被占用，建连接失败，请确认设备是否正使用在其他地方。",
        "en": "Failed to set up the SOL connection because the SOL connection "
              "is occupied. Check whether the device is being used elsewhere."
    },
    "image.is.not.connected": {
        "zh": u"镜像连接已断开，请检查网络连接后重试操作系统安装任务",
        "en": "The image connection is disconnected. Check the network connection "
              "and try the OS installation task again."
    },
    "finding.local.link.ip": {
        "zh": u"正在根据SN发现本地链路地址",
        "en": "The local link address is being discovered based on the SN"
    },
    "finding.local.link.ip.failed": {
        "zh": u"发现本地链路地址失败，请参考帮助文档",
        "en": "Failed to discover the local link address. Please refer to the "
              "help documentation"
    },
    "being.config.bmc.ip": {
        "zh": u"正在配置BMC IP",
        "en": "The BMC IP address is being configured"
    },
    "restart.network.service.failed": {
        "zh": u"重启网络服务失败",
        "en": "Failed to restart the network service"
    },
    "port.not.link.up": {
        "zh": u"物理端口{}不在连通状态：\n"
              u"方法1：请检查端口是否插有网线后重试；\n"
              u"方法2：忽略该检查项，部署完成后通过其他方式拉起端口；",
        "en": "Physical port {} is not connected: \n"
              "Method 1: Check whether a network cable is connected to the "
              "port and try again.\n"
              "Method 2: Ignore this check item and use other methods to start"
              " the port after the deployment is complete."
    },
    "check.port.link.pass": {
        "zh": u"物理端口连通状态检查通过。",
        "en": "The physical port connection status passes the check."
    },
    "check.port.link.empty": {
        "zh": u"物理端口列表为空，不涉及。",
        "en": "The physical port list is empty. This check item is not involved."
    },
    "port.not.bond.up": {
        "zh": u"绑定端口{}不在连通状态：\n"
              u"方法1：请检查端口规划及交换机配置后重试；\n"
              u"方法2：忽略该检查项，部署完成后通过其他方式拉起端口；",
        "en": "Port {} is not connected: \n"
              "Method 1: Check the port plan and switch configuration and try again.\n"
              "Method 2: Ignore this check item and use other methods to start"
              " the port after the deployment is complete."
    },
    "check.port.bond.pass": {
        "zh": u"绑定端口连通状态检查通过。",
        "en": "The connection status of the bound port passes the check."
    },
    "check.port.bond.empty": {
        "zh": u"绑定端口列表为空，不涉及。",
        "en": "The bound port list is empty. This check item is not involved."
    },
    "check.port.no.port.name.fail": {
        "zh": u"网络配置步骤已跳过，无法检查当前端口配置状态是否正常，请手动登录OS检查物理端口和绑定端口运行状态。",
        "en": "The network configuration step has been skipped. This tool cannot check whether the current port "
              "configuration status is normal. Manually log in to the OS to check the running "
              "status of physical ports and bound ports."
    },
    "not.exist.slot": {
        "zh": u"无效的槽位号{}，请按如下思路排查：\n1.请确认填写正确性以及该槽位是否插有网卡\n2.请确认已安装网卡对应的配套系统驱动，"
              u"若未安装，参考产品文档\"安装>软件安装>附录>配置临时管理IP\"章节配置临时管理IP，先参考固件安装升级指导书安装对应驱动后，再重新执行网络初始化",
        "en": "Slot {} does not have port {}.Check as follows:\n"
              "1. Check whether the entered value is correct and whether a network adapter is inserted in the slot.\n"
              "2. Ensure that the system driver corresponding to the NIC has been installed.If it is not installed, "
              "configure a temporary management IP address by referring to \"Installation\" >"
              " \"Software Installation Guide\" > \"Appendix\" > \"Configuring a Temporary IP Address\""
              "specific to your product documentation.Install the driver by referring to "
              "the firmware installation and upgrade guide,and initialize the network again."
    },
    "not.exist.port": {
        "zh": u"{}槽位不存在端口号{}，请按如下思路排查：\n1.请确认填写正确性以及该槽位是否插有网卡\n2.请确认已安装网卡对应的配套系统驱动，"
              u"若未安装，参考产品文档\"安装>软件安装>附录>配置临时管理IP\"章节配置临时管理IP，先参考固件安装升级指导书安装对应驱动后，再重新执行网络初始化",
        "en": "Slot {} does not have port {}.Check as follows:\n"
              "1. Check whether the entered value is correct and whether a network adapter is inserted in the slot.\n"
              "2. Ensure that the system driver corresponding to the NIC has been installed.If it is not installed, "
              "configure a temporary management IP address by referring to \"Installation\" >"
              " \"Software Installation Guide\" > \"Appendix\" > \"Configuring a Temporary IP Address\""
              "specific to your product documentation.Install the driver by referring to "
              "the firmware installation and upgrade guide,and initialize the network again."
    },
    "progress.finish": {
        "zh": u"完成",
        "en": "Completed"
    },
    "not.support": {
        "zh": u"不涉及",
        "en": "Not involved"
    },
    "modify.os.password.failed": {
        "zh": u"修改OS用户{}密码失败，请参考原始信息",
        "en": "Failed to change the password of OS user {}, Please refer to "
              "the original information"
    },
    "modify.bmc.password.failed": {
        "zh": u"修改BMC用户{}密码失败，请参考原始信息",
        "en": "Failed to change the password of BMC user {}, Please refer to "
              "the original information"
    },
    "reboot.server.failed": {
        "zh": u"重启服务器失败，请人工确认是否重启成功",
        "en": "Failed to restart the server, Please manually check whether the"
              " restart is successful"
    },
    "os.match.version": {
        "zh": u"配套操作系统版本：{}",
        "en": "The matching OS version: {}"
    },
    "raid.card.match.version": {
        "zh": u"配套{} RAID卡驱动版本：{}、固件版本：{}",
        "en": "The matching RAID controller card {} driver version: {}; "
              "firmware version: {}"
    },
    "es3000.match.version": {
        "zh": u"配套ES3000驱动版本：{}\n配套工具版本：{}\n配套固件版本：{}",
        "en": "The matching ES3000 driver version: {}\nThe matching tool version: {}\n "
              "The matching firmware version: {}"
    },
    "1822netCard.match.version": {
        "zh": u"1822网卡配套驱动版本：{}、工具版本：{}、固件版本：{}",
        "en": "The matching 1822 NIC driver version: {}; tool version: {}; "
              "firmware version: {}"
    },
    "1822.v120.nic.match.version": {
        "zh": u"配套1822V120网卡版本：{}",
        "en": "The matching version of the 1822V120 NIC is : {}"
    },
    "1822.v120.nic.current.version": {
        "zh": u"当前1822V120网卡版本为：{}",
        "en": "The current version of the 1822V120 NIC is : {}"
    },

    "ES_3000_Driver_Ver": {
        "zh": u"当前ES3000 驱动版本为：{}",
        "en": "The driver version of ES3000 is : {}"
    },
    "ES_3000_Tool_Ver": {
        "zh": u"当前ES3000 工具版本为：{}",
        "en": "The tool version of ES3000 is : {}"
    },
    "es3000.fw.ver.not.match": {
        "zh": u"盘符为{}的固件为：ES3000 V{}；当前版本为：{}",
        "en": "The firmware with disk {} is ES3000 V{}. Current version: {}"
    },
    "1822_NIC_Driver_ver": {
        "zh": u"当前1822网卡{}驱动{}版本为：{}",
        "en": "The current {} driver version of {} 1822 NIC is : {}"
    },
    "1822_NIC_Tool_ver": {
        "zh": u"当前1822网卡{}管理工具{}版本为：{}",
        "en": "The current {} management tool version of {} 1822 NIC is : {}"
    },
    "1822_NIC_FW_Ver": {
        "zh": u"当前1822网卡{}固件{}版本为：{}",
        "en": "The current {} firmware version of {} 1822 NIC is : {}"
    },
    "OS_Image_Ver": {
        "zh": u"当前操作系统版本为：{}",
        "en": "The OS version is {}"
    },
    "raid.card.fw.current.version": {
        "zh": u"当前{}RAID卡固件版本为：{}",
        "en": "The current firmware version of the RAID controller card {} is : {}"
    },
    "raid.card.driver.current.version": {
        "zh": u"当前{}RAID卡驱动版本为：{}",
        "en": "The current driver version of the RAID controller card {} is : {}"
    },
    "raid.card.type.not.support": {
        "zh": u"RAID型号不支持",
        "en": "RAID model is not supported"
    },
    "cmd.not.invalid": {
        "zh": u"命令不支持，请确认是否安装有所需查询工具，若未安装，请安装后重试",
        "en": "The command is not supported. Check whether the required query "
              "tool is installed. If not, install it and try again"
    },
    "cmd.not.invalid.storcli": {
        "zh": u"命令不支持,请按照如下场景做对应处理:\n"
              u"1.若执行过操作系统安装,且已执行完RAID卡驱动固件升级,请直接执行网络初始化,并安装存储软件后,使用工具开局质检功能确认"
              u"RAID版本是否正确\n"
              u"2.若未执行过操作系统安装,请参考固件升级指导书《安装/升级RAID卡固件及驱动》章节手动安装RAID卡管理工具到/opt/xxx路径,"
              u"并且如果是arm硬件,请将工具重命名为storcli64_arm后重试",
        "en": "The command is not supported. Perform the following operations:\n"
              "1. If the operating system has been installed and the RAID controller card driver firmware has been "
              "upgraded, perform network initialization, install storage software, and use the deployment quality "
              "check function of the tool to check whether the RAID version is correct.\n"
              "2. If the operating system has not been installed, manually install the RAID controller card management "
              "tool to the /opt/xxx directory by referring to section 'Installing and Upgrading the RAID Controller "
              "Card Firmware and Driver' in the firmware upgrade guide. If the ARM hardware is used, rename the tool "
              "storcli64_arm and try again."
    },
    "cx.nic.fw.current.version": {
        "zh": u"当前设备路径为{}的CX{}网卡固件版本为：{}",
        "en": "The current firmware version of the CX{} NIC in the device path {} is : {}"
    },
    "cx.nic.driver.current.version": {
        "zh": u"当前CX网卡驱动版本为：{}",
        "en": "The current driver version of the CX NIC is : {}"
    },
    "nic.driver.current.version": {
        "zh": u"当前网卡驱动版本为：{}",
        "en": "The current driver version of the NIC is : {}"
    },
    "match.cx.nic.driver.version.failed": {
        "zh": u"解析网卡驱动版本异常，请人工确认是否配套",
        "en": "Failed to parse the NIC driver version, please confirm manually"
              " whether version is matching"
    },
    "nic.match.version": {
        "zh": u"配套网卡驱动版本：{}",
        "en": "The matching driver version of the NIC is: {}"
    },
    "cx.nic.not.found": {
        "zh": u"当前节点未查询到CX网卡信息。",
        "en": "No CX NIC information is found on the current node."
    },
    "cx.nic.match.version": {
        "zh": u"配套CX系列网卡驱动版本：{}",
        "en": "The matching driver version of the CX series NIC is: {}"
    },
    "cx.nic.match.fw.version": {
        "zh": u"配套CX{}网卡固件版本：{}",
        "en": "The matching firmware version of the CX{} NIC is: {}"
    },
    "modify.password.failed": {
        "zh": u"OS用户{}登录需要修改密码，但密码修改失败，请确认新密码是否填写、"
              u"填写的新密码是否被使用过、密码复杂度是否过低",
        "en": "OS user {} needs to change password to log in, "
              "but failed to change the password, please check whether the new "
              "password is entered, whether the new password has been used, "
              "and whether the password complexity is too low."
    },
    "need.modify.password.and.new.password.is.none": {
        "zh": u"当前OS用户{}登录需要修改密码，请确认新密码是否填写。",
        "en": "OS user {} needs to change password to log in, "
              "please check whether the new password is entered."
    },
    "need.install.3008.driver.tool": {
        "zh": u"未找到3008 RAID卡固件版本查询工具：\n"
              u"方法1：如未安装相应工具，请参考产品文档将相应工具安装到OS系统root目录下后重试。\n"
              u"方法2：如已安装工具，可忽略该检查项，部署完成后人工进行检查。",
        "en": "The LSI SAS3008 firmware version query tool is not found:\n"
              "Method 1: If the tool is not installed, install the tool in the root directory of"
              " the OS by referring to the product documentation and try again."
              "Method 2: If the tool has been installed, skip this check item and manually check the"
              " tool after the deployment is complete."
    },
    "ibmc.match.fw.version": {
        "zh": u"配套iBMC固件版本：{}",
        "en": "The matching firmware version of the iBMC is: {}"
    },
    "ibmc.fw.current.version": {
        "zh": u"当前iBMC固件版本为：{}",
        "en": "The current firmware version of the iBMC is : {}"
    },
    "main.board.bios.match.fw.version": {
        "zh": u"配套主板BIOS固件版本：{}",
        "en": "The matching firmware version of the main board is : {}"
    },
    "iob.card.bios.fw.current.version": {
        "zh": u"配套IOB卡BIOS固件版本：{}",
        "en": "The matching firmware version of the IOB card is : {}"
    },
    "main.bord.bios.fw.current.version": {
        "zh": u"当前主板BIOS固件版本为：{}",
        "en": "The current version of BIOS of the main board is : {}"
    },
    "iob.card.bios.fw.version.notpass": {
        "zh": u"当前IOB卡BIOS配套固件版本为：{}",
        "en": "The BIOS current version of the IOB card is : {}"
    },
    "Main.Bord.CPLD.notpass": {
        "zh": u"当前主板CPLD版本为：{}",
        "en": "The current version of CPLD of the main board is : {}"
    },
    "Main.Bord.CPLD.match": {
        "zh": u"配套主板CPLD版本为：{}",
        "en": "The matching CPLD version of the main board is: {}"
    },
    "12*3.5.Back.Bord.CPLD.notpass": {
        "zh": u"12盘位3.5背板CPLD当前版本为：{}",
        "en": "The current version of the CPLD of the 12 disk position and 3.5 back plane is : {}"
    },
    "12*3.5.Back.Bord.CPLD.match": {
        "zh": u"配套12盘位3.5背板CPLD版本为：{}",
        "en": "The matching CPLD version of the 12 disk position and 3.5 back "
              "plane is: {}"
    },
    "4*2.5.NVME.Back.Bord.CPLD.notpass": {
        "zh": u"当前4*2.5 NVME背板CPLD版本为：{}",
        "en": "The current version of the CPLD of the 4*2.5 NVME back plane is : {}"
    },
    "4*2.5.NVME.Back.Bord.CPLD.match": {
        "zh": u"配套4*2.5 NVME背板CPLD版本为：{}",
        "en": "The matching CPLD version of the 4*2.5 NVME back plane is: {}"
    },
    "24*3.5.Back.Bord.CPLD.notpass": {
        "zh": u"当前24盘位3.5寸背板CPLD版本为：{}",
        "en": "The current version of the CPLD of the 24 disk position and 3.5 back plane is {}"
    },
    "24*3.5.Back.Bord.CPLD.match": {
        "zh": u"配套24盘位3.5寸背板CPLD版本为：{}",
        "en": "The matching CPLD version of the 24 disk position and 3.5 back "
              "plane is: {}"
    },
    "IOB.Card.CPLD.notpass": {
        "zh": u"当前IOB卡CPLD版本为：{}",
        "en": "The current version of the CPLD of the IOB card is {}"
    },
    "IOB.Card.CPLD.match": {
        "zh": u"配套IOB卡CPLD版本为：{}",
        "en": "The matching CPLD version of the IOB card is: {}"
    },
    "RAID.Card.CPLD.notpass": {
        "zh": u"当前RAID卡{}的CPLD版本为{}",
        "en": "The current version of the CPLD of the RAID card {} is {} "
    },
    "RAID.Card.CPLD.notInvolve": {
        "zh": u"RAID卡{}的CPLD不涉及",
        "en": "The CPLD of the RAID controller card {} is not involved."
    },
    "RAID.Card.CPLD.match": {
        "zh": u"配套RAID卡CPLD版本为：{}",
        "en": "The matching CPLD version of the RAID card is: {}"
    },
    "bmc.hostname.config.success": {
        "zh": u"BMC 主机名配置成功。",
        "en": "The BMC hostname was successfully configured."
    },
    "bmc.hostname.config.failed": {
        "zh": u"BMC 主机名配置失败。",
        "en": "Failed to configure the BMC host name."
    },
    "bmc.ip.config.success": {
        "zh": u"BMC IP配置成功。",
        "en": "The BMC IP address was successfully configured."
    },
    "bmc.ip.config.failed": {
        "zh": u"BMC IP配置失败，请确认网络以及设备信息是否正常。",
        "en": "Failed to configure the BMC IP address. Check whether the "
              "network and device information are normal."
    },
    "bmc.source.ip.not.reached": {
        "zh": u"当前BMC IP地址：{}不可达，请按照如下思路排查："
              u"\n1.请根据参数配置页面的“用法说明”引导，完成安装PC的网络相关配置。"
              u"\n2.请检查安装PC与服务器之间的网络连通性，尝试在安装PC上使用命令提示符执行“ping 服务器当前BMC IP地址”，查看网络连通性。"
              u"\n3.如当前配置使用IPv6，请检查安装PC上除正在使用的物理网卡之外，其他网卡是否启用Pv6。要求安装PC上仅当前使用的物理网卡启动IPv6。",
        "en": "The current BMC IP address {} is unreachable. Perform the following operations:"
              "\n1. Configure the network for the installation PC by following instructions on parameter setting page."
              "\n2. Check the network connectivity between the installation PC and the server. "
              "Run the \"ping Current BMC IP address of the server\" command on the installation PC "
              "to check the network connectivity."
              "\n3. If IPv6 is used, check whether IPv6 is enabled for all network adapters except "
              "the physical network adapters in use on the installation PC. "
              "On the installation PC, enable IPv6 only for the physical network adapter in use."
    },
    "sp.mapping.version": {
        "zh": u"SP配套版本为：{}\n",
        "en": "The matching SP version is {}\n"
    },
    "get.sp.version.failed": {
        "zh": u"获取SP版本失败",
        "en": "Failed to obtain the SP version."
    },
    "sp.current.version": {
        "zh": u"当前设备SP版本为：{}",
        "en": "The current SP version of the device is : {}"
    },
    "bios.config.not.found": {
        "zh": u"配置{}异常，请结合原始信息排查异常原因",
        "en": "Configuration {} is abnormal. Locate the fault based on the original information."
    },
    "os.net.config.error": {
        "zh": u"系统网卡配置查询异常，请结合原始信息排查原因",
        "en": "Failed to query the system network adapter configuration. Locate the cause based "
              "on the original information."
    },
    "network.file.write.error": {
        "zh": u"网络配置文件：{}写入异常，请手动写入以下信息：{}。",
        "en": "Failed to write network configuration file: {}. Please manually write the following information: {}."
    },
    "ip.conflict.exist": {
        "zh": u"Ip {} 已被 {} 使用，请重新配置。",
        "en": "Ip {} has been used by {} , please change the configuration and retry."
    },
    "config.bmc.failed": {
        "zh": u"修改{}配置失败，请参考原始信息",
        "en": "Failed to modify the {} configuration. Please refer to the original information."
    },
    "model.not.support": {
        "zh": u"当前结束符：{} 为非标准符号，确认环境为标准环境或联系技术工程师",
        "en": "The current end symbol {} is a non-standard symbol. Confirm that the environment is a "
              "standard environment or contact technical support."
    },
    "match.download.url": {
        "zh": u"升级包获取途径：{}",
        "en": "Matching URL:{}"
    },
    "current.mapping.file": {
        "zh": u"当前配套表为：{}，如果现网使用的版本更新，配套版本和下载链接请以实际的版本配套表为准。",
        "en": "Current version mapping: {}. If the version used on the live network is updated, "
              "refer to the actual version mapping and download link."
    },
    "asset.tag.result": {
        "zh": u"资产标签：{}",
        "en": "Asset Tag:{}"
    },
    "location.result": {
        "zh": u"位置信息：{}",
        "en": "Location:{}"
    },
    "config.pass": {
        "zh": u"通过",
        "en": "Passed"
    },
    "no.param.lldp": {
        "zh": u"未查询到LLDP服务信息，可能是iBMC版本过低。",
        "en": "The parameters of lldp service are not found. "
              "Maybe the version of iBMC is too low."
    },
    "modify.lldp.param.fail": {
        "zh": u"打开LLDP服务器失败，可能是网卡固件版本过低或网络异常。",
        "en": "Open lldp service fails. "
              "Maybe the firmware version of Network adapter is too low or the network is abnormal."
    },
    "controller.id.query.error": {
        "zh": u"控制器id查询失败",
        "en": "Controller Id not found."
    },
    "vdid.not.found": {
        "zh": u"vdid查询失败",
        "en": "vdid not found"
    },
    "disk.usage.not.enough": {
        "zh": u"磁盘空间不足",
        "en": "Insufficient disk space"
    },
    "secure.boot.enabled": {
        "zh": u"安全启动设置开启，需要手动关闭。请进入bios配置界面“Security”页签，选择“SecureBoot”选项，并设置成“Disabled”，按“F10”保存重启。",
        "en": "The secure boot setting is enabled and needs to be manually disabled. Go to the BIOS configuration page"
              ", click the Security tab, select SecureBoot, set SecureBoot to Disabled"
              ", and press F10 to save the settings and restart the system."
    },
    "secure.boot.enabled.proprietary.hardware": {
        "zh": u"专有硬件不涉及，默认通过。",
        "en": "Dedicated hardware is not involved. This item passes the check by default."
    },
    "secure.boot.1880.raid.ignore": {
        "zh": u"使用SP686C/SP186的RAID卡通用硬件不涉及，默认通过。",
        "en": "RAID cards that use SP686C/SP186 are not involved. This item passes the check by default."
    },
    "config.bmc.boot.sequence.failed": {
        "zh": u"设置bios启动项失败，请重试，如果重试失败请参照对应版本的产品文档“安装存储节点操作系统”章节手动设置。",
        "en": "Failed to set the BIOS boot option. Please try again. If the retry fails, manually set the BIOS boot "
              "option by referring to section 'Installing the OS on the Storage Node' in the product documentation "
              "of the corresponding version."
    },
    "config.bmc.password.success": {
        "zh": u"新密码已下发成功，待服务器重启后生效。",
        "en": "The new password has been delivered successfully and will take effect after the server is restarted."
    },
    "mount.iso.image.error": {
        "zh": u"挂载镜像失败，请到ibmc端口服务界面检查IPMI端口是否开启，若没有开启，请开启IPMI端口后点击重试，若已开启请联系技术工程师处理。",
        "en": "Failed to mount the image. Check whether the IPMI port is enabled on the ibmc port service page. "
              "If the IPMI port is not enabled, enable it and click Retry. "
              "If the IPMI port is enabled, contact technical support."
    },
    "server.power.on.state.error": {
        "zh": u"当前服务器已上电，操作系统安装过程中请勿人为操作服务器，请重试该节点安装操作系统任务。",
        "en": "The server has been powered on. Do not operate the server during the OS installation."
              " Try to install the OS on the node again."
    },
    "server.power.on.error": {
        "zh": u"当前服务器上电失败，请检查服务器运行状态。",
        "en": "Failed to power on the server. Check the server running status."
    },
    "server.power.off.error": {
        "zh": u"当前服务器强制下电失败，请检查服务器运行状态。",
        "en": "Failed to forcibly power off the server. Check the server running status."
    },
    "post.clean.error": {
        "zh": u"清理环境失败",
        "en": "Failed to clear the environment."
    },
    "product.not.support": {
        "zh": u"暂不支持为{}安装OS，请联系技术支持工程师确认是否可以为该型号设备安装OS，如可以，请跳过该步骤。",
        "en": "The OS cannot be installed for {}. Contact technical support engineers to "
              "check whether the OS can be installed for {}. If the OS can be installed, skip this step."
    },
    "query.product.model.failed": {
        "zh": u"未查询到产品型号，请结合原始信息排查异常原因。",
        "en": "No product model is found. Locate the fault based on the original information."
    },
    "login.os.failed": {
        "zh": u"当前OS用户{}登录失败，请排查：\n"
              u"1、默认密码填写是否正确；\n"
              u"2、由于ibmc和bios版本过低，导致设置光驱启动没有生效，请检查节点ibmc和bios是否为推荐配套版本。\n"
              u"3、请通过虚拟控制台登陆OS查看操作系统是否安装成功并检查系统内核版本是否符合预期。",
        "en": "Failed to log in to the current OS user {}. Please check:\n"
              "1. Check whether the default password is correct.\n"
              "2. The version of the ibmc and BIOS is too early. As a result, the setting of the CD-ROM drive does not"
              " take effect. Check whether the ibmc and BIOS versions on the node are the recommended versions.\n"
              "3.Log in to the OS through the virtual console to check whether the OS is successfully installed and "
              "whether the system kernel version meets the expectation."
    },
    "switch.os.failed": {
        "zh": u"通过SOL连接跳转OS失败，请结合原始信息排除异常原因后重试该步骤或联系技术支持工程师。",
        "en": "Failed to switch to the OS through the SOL connection. Rectify the fault based on "
              "the original information and try again, or contact technical support engineer."
    },
    "modify.os.timezone.failed": {
        "zh": u"修改OS时区失败，请结合原始信息排查异常原因或登录OS执行tzselect手动配置时区以及修改SSH用户的登录密码并跳过该步骤。",
        "en": "Failed to change the OS time zone. Locate the fault based on the original information, "
              "or Log in to the operating system, run the tzselect command to manually configure the time zone and "
              "change the SSH user login password, and skip this step."
    },
    "modify.ssh.user.password.failed": {
        "zh": u"修改用户密码失败，请结合原始信息排查：\n"
              u"1、密码强度是否较弱，是否为弱密码。\n"
              u"2、密码内容是否满足系统密码规则。\n"
              u"3、若提示密码不满足规则或该密码为弱密码，请登录OS手动修改密码后跳过该步骤。",
        "en": "Failed to change the user password. Check the following items based on the original information:\n"
              "1. Check whether the password strength is weak and whether the password is weak.\n"
              "2. Check Whether the password meets the system password rules.\n"
              "3. If the system displays a message indicating that the password does not meet the requirements or "
              "the password is weak, log in to the OS, change the password, and skip this step."
    },
    "check.os.username.not.exist": {
        "zh": u"当前OS用户{}不存在，请结合原始信息排查：\n"
              u"1、该用户名称是否正确，是否属于操作系统内置OS用户；\n"
              u"2、请通过虚拟控制台登陆OS查看操作系统是否安装并初始化完成，检查该用户是否已创建成功。如用户已存在，则手动修改密码后跳过该步骤。",
        "en": "The current OS user {} does not exist. Check the following items based on the original information:\n"
              "1. Check whether the user name is correct and whether the user is a built-in OS user.\n"
              "2. Log in to the OS through the virtual console to check whether the OS is installed and initialized "
              "and whether the user is created successfully. If the user already exists, skip this step after manually "
              "changing the password."
    },
    "check.os.installation.status.timeout": {
        "zh": u"检查OS安装状态超时，请通过网页登录iBMC，启动虚拟控制台，确认OS安装进程，如果在正常安装，请点击重试，"
              u"其他情况请联系技术支持工程师。",
        "en": "Checking the OS installation status times out. Log in to the iBMC WebUI, start the virtual console, "
              "and check whether the OS installation is complete. If the installation is carried out normally, "
              "click Retry. For other cases, contact technical support engineers."
    },
    "nonstandard.ibmc.environment": {
        "zh": u"通过ssh连接登录iBMC时，检测到iBMC为非标准环境，请联系技术支持工程师更换升级iBMC。",
        "en": "When you log in to the iBMC over SSH, the iBMC is detected to be a non-standard environment. "
              "Contact technical support engineers to replace and upgrade the iBMC."
    },
    "user.select.not.reboot": {
        "zh": u"用户选择不进行重启",
        "en": "User chooses not to restart."
    },
    "nvme.driver.current.version": {
        "zh": u"当前NVMe驱动版本为：{}",
        "en": "Current NVMe driver version: {}"
    },
    "nvme.driver.version.mapping.match": {
        "zh": u"配套NVMe驱动版本为：{}",
        "en": "Matching NVMe driver version: {}"
    },
    "disk.driver.version.mapping.match": {
        "zh": u"配套SATA系统盘驱动版本为：{}\n配套SAS数据盘驱动版本为：{}",
        "en": "The matching driver version of the SATA system disk is : {}\n the matching driver version of the SAS"
              " data disk is : {}"
    },
    "disk.driver.version.mapping.match.sata": {
        "zh": u"配套SATA系统盘驱动版本为：{}",
        "en": "The matching driver version of the SATA system disk is : {}"
    },
    "SATA.disk.driver.current.version": {
        "zh": u"当前SATA系统盘驱动版本为：{}",
        "en": "The current driver version of SATA system disk is : {}"
    },
    "SAS.disk.driver.current.version": {
        "zh": u"当前SAS数据盘驱动版本为：{}",
        "en": "The current driver version of SAS disk is : {}"
    },
    "pcieinf.base.driver.current.version": {
        "zh": u"当前基础驱动pcieinf版本为：{}",
        "en": "The current driver version of the pcieinf base is : {}"
    },
    "bsp.base.driver.current.version": {
        "zh": u"当前基础驱动bsp版本为：{}",
        "en": "The current driver version of the bsp base is : {}"
    },
    "cma.base.driver.current.version": {
        "zh": u"当前基础驱动cma版本为：{}",
        "en": "The current driver version of the cmd base is : {}"
    },
    "memf.base.driver.current.version": {
        "zh": u"当前基础驱动memf版本为：{}",
        "en": "The current driver version of the memf base is : {}"
    },
    "base.driver.version.mapping.match": {
        "zh": u"配套基础驱动pcieinf版本为：{}\n配套基础驱动bsp版本为：{}\n配套基础驱动cma版本为：{}\n配套基础驱动memf版本为：{}",
        "en": "The matching versions of basic drivers are as follows:\nPCIe INF: {}\nBSP: {}\nCMA: {}\nmemf: {}"
    },
    "no.associated.base.driver.exist": {
        "zh": u"无{}基础驱动",
        "en": "No {} base driver"
    },
    "no.associated.disk.driver.exist": {
        "zh": u"无{}硬盘驱动",
        "en": "No {} disk driver"
    },
    "no.associated.driver.exist": {
        "zh": u"无{}驱动",
        "en": "No {} driver"
    },
    "no.associated.driver.exist.no.check": {
        "zh": u"无驱动，无法检查，请安装驱动后重试",
        "en": "No driver. Unable to check. Please install the driver and try again.,"
    },
    "idm.driver.current.version": {
        "zh": u"IDM驱动当前版本为：{}",
        "en": "The matching driver version of the IDM  is : {}"
    },
    "idm.driver.version.mapping.match": {
        "zh": u"IDM驱动配套版本为：{}",
        "en": "The matching driver version of the IDM  is : {}"
    },
    "use.fw.tool.to.upgrade": {
        "zh": u"请使用工具的“固件升级”功能完成升级。",
        "en": "Use Firmware Upgrade to complete the upgrade."
    },
    "use.driver.tool.to.upgrade": {
        "zh": u"请先使用工具的“网络初始化”功能完成初始化，再使用工具的“驱动升级”功能完成升级。",
        "en": "Use Network Initialization to complete initialization and then use Driver Upgrade to complete the "
              "upgrade."
    },
    "use.os.tool.to.install": {
        "zh": u"请使用工具的“操作系统安装”功能完成安装。",
        "en": "Use Operating System Installation to complete the installation."
    },
    "node.uid": {
        "zh": u"当前节点ProductUniqueID是：{}",
        "en": "The ProductUniqueID of current node is :{}"
    },
    "node.sn.not.same": {
        "zh": u"当前节点SN信息不一致，实际SN为：{}，表格填写SN为：{}",
        "en": "The SN information of the current node is inconsistent. The actual SN is {}. The SN entered in the lld "
              "is {}."
    },
    "1822.nic.not.found": {
        "zh": u"当前节点未查询到1822网卡信息。",
        "en": "No 1822 NIC information is found on the current node."
    },
    "1822.v120.nic.not.found": {
        "zh": u"当前节点未查询到1822V120网卡信息。",
        "en": "No 1822V120 NIC information is found on the current node."
    },
    "current.mapping.ver": {
        "zh": u"当前选择存储版本为：{}",
        "en": "The currently selected storage version is: {}"
    },
    "can.not.find.net.info": {
        "zh": u"无法获取到网卡槽位信息，请先安装基础驱动后重试",
        "en": "Failed to obtain the slot information. Install the basic driver and try again."
    },
    "config.ibmc.timezone.fail": {
        "zh": u"时区配置失败，请参考原始信息排查失败原因",
        "en": "Failed to configure the time zone. Check the failure cause by referring to the original information."
    },
    "ip.config.pass.not.reachable": {
        "zh": u"当前设备BMC IP [{}] 配置完成，但是连通性校验失败，请检查本机IP是否与BMC 网络是否在一个网段内",
        "en": "The BMC IP address [{}] of the current device has been configured, but the connectivity check failed. "
              "Check whether the local IP address and the BMC network are in the same network segment."
    },
    "ip.connect.check.pass": {
        "zh": u"BMC IP连通性校验通过",
        "en": "The BMC IP address connectivity check is successful."
    },
    "delete.user.failed": {
        "zh": u"删除用户{}失败",
        "en": "Failed to delete user {}."
    },
    "cur.login.user.can.not.delete": {
        "zh": u"当前登录用户{}不可执行删除",
        "en": "The current login user {} cannot be deleted."
    },
    "post.user.failed": {
        "zh": u"创建用户{}失败",
        "en": "Failed to create user {}."
    },
    "patch.user.failed": {
        "zh": u"修改用户{}失败",
        "en": "Failed to modify user {}."
    },
    "patch.user.first.login.policy.failed": {
        "zh": u"修改用户{}首次登录策略失败",
        "en": "Failed to modify the first login policy of user {}."
    },
    "current.user.password.changed": {
        "zh": u"检测到当前登录用户信息已被修改，请在后续新建其他任务前，确认表格用户信息已更新",
        "en": "The information about the current login user has been modified. Ensure that the user information "
              "in the LLD has been updated before creating other tasks."
    },
    "no.need.check.nic.card": {
        "zh": u"当前设备未查询到网卡硬件\n",
        "en": "No NIC hardware is found on the current device.\n"
    },
    "sol.need.manu.confirm.reboot": {
        "zh": u"当前设备需开启BMC与OS的通信串口，串口开启需要重启，需要人工确认当前设备可执行重启操作，请联系技术工程师协助操作\n",
        "en": "The sol for communication between the BMC and OS needs to be enabled on the current device. "
              "After the sol is enabled, the device needs to be restarted. "
              "You need to manually confirm that the current device can be restarted."
              " Contact technical support engineers for assistance.\n"
    },
    "check.raid.config.query.fail": {
        "zh": u"查询失败",
        "en": "Query failed."
    },
    "check.raid.config.not.support": {
        "zh": u"不涉及",
        "en": "Not involved."
    },
    "check.raid.config.table.raid.config.version": {
        "zh": u"配套RAID CONFIG版本为：{}",
        "en": "The matching RAID CONFIG version is:{}."
    },
    "check.raid.config.current.raid.config.version": {
        "zh": u"当前RAID CONFIG版本为：{}",
        "en": "Current RAID CONFIG version:{}."
    },
    "check.raid.config.get.current.raid.config.version.fail": {
        "zh": u"查询设备RAID CONFIG版本失败",
        "en": "Failed to query the version of the RAID CONFIG."
    },
    "check.raid.config.not.match": {
        "zh": u"当前RAID CONFIG版本与版本配套表中版本不匹配",
        "en": "The current RAID CONFIG version does not match that in the version mapping table."
    },
    "check.raid.config.not.install": {
        "zh": u"当前设备未安装RAID CONFIG",
        "en": "RAID CONFIG is not installed on the current device."
    },
    "check.ibmc.version.lower.config.bios.pwd": {
        "zh": u"当前设备的iBMC固件版本不支持配置BIOS密码，请先升级iBMC固件版本到{}及以上。",
        "en": "The iBMC firmware version of the current device does not support BIOS password configuration. "
              "Upgrade the iBMC firmware version to {} or later."
    },
    "check.expansion.module.config.fw.version": {
        "zh": u"配套SAS{}级联板的固件版本为：{}",
        "en": "The matching SAS{} expansion module firmware version is:{}."
    },
    "check.expansion.module.config.driver.version": {
        "zh": u"配套SAS级联板的驱动版本为：{}",
        "en": "The matching SAS expansion module driver version is:{}."
    },
    "check.expansion.module.current.fw.version": {
        "zh": u"当前设备SAS{}级联板({})的固件版本为：{}",
        "en": "The current SAS{} expansion module({}) firmware version is:{}."
    },
    "check.expansion.module.module.fw.version": {
        "zh": u"当前设备SAS{}级联板({})的固件版本为：{} 。(要求{}及以上)",
        "en": "The current SAS{} expansion module({}) firmware version is:{}. (The version must be {} or later.)"
    },
    "check.expansion.module.current.driver.version": {
        "zh": u"当前设备SAS级联板的驱动版本为：{}",
        "en": "The current SAS expansion module driver version is:{}."
    },
    "check.expansion.module.fw.not.match": {
        "zh": u"当前设备SAS{}级联板({})的固件版本不匹配",
        "en": "The current SAS{} expansion module({}) firmware does not match that in the version mapping table."
    },
    "check.expansion.module.driver.not.match": {
        "zh": u"当前设备SAS级联板的驱动版本不匹配",
        "en": "The current SAS expansion module driver does not match that in the version mapping table."
    },
    "check.expansion.module.not.install": {
        "zh": u"当前设备不支持使用SAS{0}级联板或未查询到SAS{0}级联板硬件",
        "en": "The current device does not support the SAS{0} expansion module"
              " or the SAS{0} expansion module hardware is not found."
    },
    "check.expansion.module.not.version": {
        "zh": u"当前设备未查询到固件和驱动版本号，请安装级SAS联板驱动和固件后重试",
        "en": "No firmware or driver version is found on the current device. "
              "Install the driver and firmware of SAS expansion module and try again."
    },
    "check.expansion.module.not.ipmitool": {
        "zh": u"当前设备上没有ipmitool工具或暂未查询到SAS级联板设备",
        "en": "The ipmitool does not exist on the current device or the SAS expansion module device is not found."
    },
    "check.expansion.module.driver.not.support": {
        "zh": u"当前设备不涉及SAS级联板的驱动版本检查",
        "en": "The current device does not involve the check of the SAS expansion module driver version."
    },
    "check.expansion.module.fw.not.support": {
        "zh": u"当前设备不涉及SAS{}级联板的固件版本检查",
        "en": "The current device does not involve the check of the SAS{} expansion module firmware version."
    },
    "check.net.driver.not.match": {
        "zh": u"当前设备NET驱动版本不匹配",
        "en": "The current NET driver version does not match that in the version mapping table."
    },
    "check.net.driver.current.version": {
        "zh": u"当前设备NET驱动版本为：{}",
        "en": "The current NET driver version is: {}."
    },
    "check.net.driver.not.file": {
        "zh": u"当前设备未查询到驱动版本号，请安装NET驱动后重试",
        "en": "No driver version is found on the current device. Install the NET driver and try again."
    },
    "check.net.driver.not.support": {
        "zh": u"不涉及",
        "en": "N/A"
    },
    "check.net.driver.config.driver.version": {
        "zh": u"配套NET驱动版本为：{}",
        "en": "The matching NET driver version is: {}."
    },
}
