#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/06/09
@file: ip.py
@function:
"""
from Common.base import entity
from Common.base.entity import DeployException


class IpAddresses(object):

    def create_redfish_data(self, oem_key, ip_version):
        raise DeployException("This is no implemented method.")


class Ipv4Addresses(IpAddresses):

    def __init__(self, ip, subnet_mask, gateway):
        self._ip = ip
        self._subnet_mask = subnet_mask
        self._gateway = gateway
        self._logger = entity.create_logger(__file__)

    def create_redfish_data(self, oem_key, ip_version):
        data = {"IPv4Addresses": [
            {"AddressOrigin": "Static", "Address": self._ip,
             "SubnetMask": self._subnet_mask, "Gateway": self._gateway}]
        }
        self._logger.info("current ip version is :{}".format(ip_version))
        if oem_key and ip_version != "IPv4":
            data["Oem"] = {oem_key: {"IPVersion": "IPv4AndIPv6"}}
        return data

    @property
    def ip(self):
        return self._ip


class Ipv6Addresses(IpAddresses):

    def __init__(self, ip, prefix, gateway):
        self._ip = ip
        self._prefix = prefix
        self._gateway = gateway
        self._logger = entity.create_logger(__file__)

    def create_redfish_data(self, oem_key, ip_version):
        data = {"IPv6Addresses": [
            {"AddressOrigin": "Static", "Address": self._ip,
             "PrefixLength": int(self._prefix)}],
            "IPv6DefaultGateway": self._gateway
        }
        self._logger.info("current ip version is :{}".format(ip_version))
        if oem_key and ip_version != "IPv6":
            data["Oem"] = {oem_key: {"IPVersion": "IPv4AndIPv6"}}
        return data

    @property
    def ip(self):
        return self._ip
