#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/06/08
@file: login.py
@function:
"""
from Business.adaptor import java_adaptor


class LoginInfo(object):

    def __init__(self, ip, username, password, new_password, port=443):
        self.ip = ip
        self.username = username
        self.password = password
        self.new_password = new_password
        self.port = port

    def update_password_to_new(self):
        self._password = self._new_password

    def had_new_password(self):
        return bool(self._new_password)

    @property
    def ip(self):
        return self._ip

    @ip.setter
    def ip(self, ip):
        if java_adaptor.get_string_utils().isValidIPV6(ip):
            ip = "[{}]".format(ip)
        self._ip = ip

    @property
    def username(self):
        return self._username

    @username.setter
    def username(self, username):
        self._username = username.strip()

    @property
    def password(self):
        return java_adaptor.get_aes_encrypt().decrypt(self._password, java_adaptor.get_patch_util().importAESPk())

    @password.setter
    def password(self, password):
        self._password = java_adaptor.get_aes_encrypt().encrypt(password, java_adaptor.get_patch_util().importAESPk())

    @property
    def new_password(self):
        return java_adaptor.get_aes_encrypt().decrypt(self._new_password, java_adaptor.get_patch_util().importAESPk())

    @new_password.setter
    def new_password(self, new_password):
        self._new_password = java_adaptor.get_aes_encrypt().encrypt(
            new_password,
            java_adaptor.get_patch_util().importAESPk())

    @property
    def port(self):
        return self._port

    @port.setter
    def port(self, port):
        self._port = port

    @property
    def auth(self):
        return self.username, self.password

    def __str__(self):
        return "ip: {}, userName: {}, port: {}, has new password: {}".format(
            self.ip, self.username, self.port, self.had_new_password())
