#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

import traceback
from Common.base import context_util
from Common.base import entity
from Common.base.entity import ResultFactory
from Common.base.entity import DeployException
from Common.protocol.redfish.redfish_util import get_all_bios_info, \
    set_one_bios_info


def config_bios_info(context, bios_key, bios_should_value):
    logger = entity.create_logger(__file__)
    login_info = context_util.get_login_info(context)
    origin_info = []
    # BIOS设置
    try:
        bios_info, resource = get_all_bios_info(login_info, logger)
        origin_info.append(resource)
        value = bios_info.get(bios_key)
        logger.info("The dev {} value: {} should value :{}".format(bios_key, value, bios_should_value))
        if not value:
            return ResultFactory.create_pass(origin_info)
        if value != bios_should_value:
            origin_info.append(set_one_bios_info(login_info, bios_key, bios_should_value, logger))
        return ResultFactory.create_pass(resource)
    except DeployException as de:
        logger.error(de.message)
        logger.error(str(traceback.format_exc()))
        return ResultFactory.create_not_pass(de.origin_info, de.err_msg)
