#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/30
@file: bonding_opts_builder.py
@function: 绑定opts建造者
@modify:
"""


class BondOpt(object):
    def __init__(self, key, index):
        self.key = key
        self.index = index
        self._value = None

    @property
    def value(self):
        return self._value

    @value.setter
    def value(self, value):
        if not isinstance(value, str):
            raise ValueError
        self._value = value

    def __str__(self):
        return "key={} index={} value={}".format(
            self.key, self.index, self.value)


class BondOptsBuilder(object):

    def __init__(self):
        self._mode = BondOpt("mode", 0)
        self._miimon = BondOpt("miimon", 1)
        self._xmit_hash_policy = BondOpt("xmit_hash_policy", 3)
        self._lacp_rate = BondOpt("lacp_rate", 2)
        self._arp_broadcast = BondOpt("arp_broadcast", 4)

    def mode(self, mode):
        self._mode.value = mode
        return self

    def miimon(self, miimon="100"):
        self._miimon.value = miimon
        return self

    def xmit_hash_policy(self, policy="layer3+4"):
        self._xmit_hash_policy.value = policy
        return self

    def lacp_rate(self, rate="fast"):
        self._lacp_rate.value = rate
        return self

    def arp_broadcast(self, arp_broadcast="1"):
        self._arp_broadcast.value = arp_broadcast
        return self

    def get_build_info(self):
        opts = list()
        for opt in vars(self).values():
            if isinstance(opt, BondOpt) and opt.value:
                opts.append(opt)
        opts.sort(key=lambda o: o.index)
        return "'{}'".format(" ".join(["{}={}".format(
            opt.key, opt.value) for opt in opts]))
