#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@time: 2021/10/18
@file: check_main_board_uids_service.py
@function: 根据主板的UID判断是否对应的主板类型
"""
from Common.protocol.redfish import redfish_util

# VE机型支持的主板UID
VE_SUPPORTED_MAIN_BOARD_UIDS = ("0x0207b900", "0x0207b901", "0x0207a100", "0x0207a101")

# V6机型支持的主板UID
# 1288HV6(DP1210)   0x0201bd00,0x0201ad00
# 2288HV6（DP2210） 0x0201b500,0x0201b100
# 5288 V6(DP4210) 0x0201b501,0x0201b101
V6_SUPPORTED_MAIN_BOARD_UIDS = ("0x0201bd00", "0x0201ad00", "0x0201b500", "0x0201b100", "0x0201b501", "0x0201b101")


def is_ve_supported_main_board(login_info, logger):
    product_unique_id, _ = redfish_util.get_product_unique_id(login_info, logger)
    return product_unique_id in VE_SUPPORTED_MAIN_BOARD_UIDS


def is_v6_supported_main_board(login_info, logger):
    product_unique_id, _ = redfish_util.get_product_unique_id(login_info, logger)
    return product_unique_id in V6_SUPPORTED_MAIN_BOARD_UIDS
