# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from Common.base import entity
from Common.base.entity import DeployException
from Common.protocol.redfish import redfish_util
from Common.protocol.redfish.entity.http import HttpClient

# 数据集群模块的设备类型
DEV_TYPE_DATA_CLUSTER_MODULE = 'Data Cluster Module'
LOGGER = entity.create_logger(__file__)


def handle_dev_modify_bmc_new_password(login_info, dev_type):
    """
    处理修改设备的BMC密码逻辑
    :param login_info: 设备登录信息
    :param dev_type: 设备类型
    :return: 执行结果，原始信息，错误信息
    """
    if not check_dev_need_modify_bmc_new_password(login_info, dev_type):
        LOGGER.info("not need modify bmc new pwd : {}".format(login_info.ip))
        return True, "", ""
    try:
        resp_info = redfish_util.modify_user_password(login_info, login_info.username, login_info.new_password, LOGGER)
        # 原有连接已经被远程注销，此处释放缓存
        HttpClient.release_session(login_info, LOGGER)
        return True, resp_info, ""
    except DeployException as de:
        LOGGER.info("modify bmc pwd failed: {}".format(de.message))
        return False, de.origin_info, entity.create_msg("modify.bmc.password.failed").format(login_info.username)


def check_dev_need_modify_bmc_new_password(login_info, dev_node):
    """
    检查当前设备是否需要修改BMC的新密码
    修改密码，同时要求用户填写了新密码且新旧密码不一致
    :param login_info:登录信息
    :param dev_node:设备
    :return:是否需要修改密码
    """
    # 存在新密码且不相同，则需修改密码
    return login_info.had_new_password() and login_info.password != login_info.new_password
