#! /usr/bin/python
# -*- coding: UTF-8 -*-
import re

NUM8 = 8
NUM0 = 0


def compress_ipv6(ipv6):
    """
    将ipv6格式压缩 如 abcd::0压缩成 abdc::
    :param ipv6: ip
    :return:  压缩后格式
    """
    full_ip = _full_decompress_ipv6(ipv6)
    # compress as linux model
    compress_ip = re.sub(r'^0{1,3}(.*)', r'\1', full_ip.lower())
    compress_ip = re.sub(r'((?:(?:^|:)0+\b){2,}):?(?!\S*\b\1:0+\b)(\S*)', r'::\2', compress_ip)
    compress_ip = re.sub(r':0{1,3}([0-9a-fA-F]+)', r":\1", compress_ip)

    return compress_ip


def _decompress_ipv6(ipv6):
    ip_arr = ipv6.split("::")
    if len(ip_arr) > 1:
        count = len(ip_arr[0].split(":")) + len(ip_arr[1].split(":"))
        zero_count = NUM8 - count
        full_ip = ip_arr[0]
        if full_ip == "":
            full_ip = "0"
        for _ in range(0, zero_count):
            full_ip += ":0"
        full_ip += ":"
        full_ip += ip_arr[1]
        if ip_arr[1] == "":
            full_ip += "0"
        return full_ip.lower()
    else:
        return ipv6.lower()


def _full_decompress_ipv6(ipv6):
    full_ip = _decompress_ipv6(ipv6)
    ip_arr = full_ip.split(":")
    for i in range(NUM0, NUM8):
        ip_arr[i] = "{0:0>4}".format(ip_arr[i])
    return ":".join(ip_arr)
