/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.config;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicegraph.config.EnclosureCfg;
import com.huawei.ism.tool.devicegraph.config.ModuleCfg;
import com.huawei.ism.tool.devicegraph.config.RackCfg;
import com.huawei.ism.tool.devicegraph.config.SlotCfg;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.ViewType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DeviceGraphConfig {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceGraphConfig.class);
    private static final String CFG_PATH = ApplicationContext.getInstance().getDeviceGraphCfgPath();
    private static final String IMG_PATH = ApplicationContext.getInstance().getDeviceImgCfgPath();
    private static final String HD_CFG_PATH = ApplicationContext.getInstance().getHDDeviceGraphCfgPath();
    private static final String HD_IMG_PATH = ApplicationContext.getInstance().getHDDeviceImgCfgPath();
    private static DeviceGraphConfig instance;
    private RackCfg rackCfg = new RackCfg();
    private RackCfg hdRackCfg = new RackCfg();
    private EnclosureCfg firstEnclosure = null;
    private Map<String, Map<String, EnclosureCfg>> enclosureMap = new HashMap<String, Map<String, EnclosureCfg>>();
    private Map<String, Map<String, EnclosureCfg>> hdEnclosureMap = new HashMap<String, Map<String, EnclosureCfg>>();
    private Map<String, Map<String, ModuleCfg>> moduleMap = new HashMap<String, Map<String, ModuleCfg>>();
    private Map<String, Map<String, ModuleCfg>> hdModuleMap = new HashMap<String, Map<String, ModuleCfg>>();

    private DeviceGraphConfig() {
        InputStream stream = null;
        stream = this.getInputStream(CFG_PATH);
        Document doc = null;
        try {
            doc = XmlUtils.parseDocument(stream);
        }
        finally {
            StreamUtils.closeStream(null, stream);
        }
        Element root = doc.getDocumentElement();
        this.parseBayCfg(root, false);
        this.parseEnclosureCfg(root, false);
        this.parseModuleCfg(root, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceGraphConfig(boolean isHDGraph) {
        InputStream stream = null;
        InputStream hdstream = null;
        stream = this.getInputStream(CFG_PATH);
        hdstream = isHDGraph ? this.getInputStream(HD_CFG_PATH) : null;
        Document doc = null;
        Document hdDoc = null;
        try {
            doc = stream != null ? XmlUtils.parseDocument(stream) : null;
            hdDoc = isHDGraph && hdstream != null ? XmlUtils.parseDocument(hdstream) : null;
        }
        finally {
            StreamUtils.closeStream(null, stream);
            if (isHDGraph) {
                StreamUtils.closeStream(null, hdstream);
            }
        }
        if (doc == null) {
            LOGGER.error("can not get inputStream from " + CFG_PATH);
            return;
        }
        Element root = doc.getDocumentElement();
        this.parseBayCfg(root, false);
        this.parseEnclosureCfg(root, false);
        this.parseModuleCfg(root, false);
        if (isHDGraph && null != hdDoc) {
            Element hdRoot = hdDoc.getDocumentElement();
            this.parseEnclosureCfg(hdRoot, true);
            this.parseModuleCfg(hdRoot, true);
            this.parseBayCfg(root, true);
        }
    }

    private InputStream getInputStream(String Path2) {
        InputStream inputStream;
        block2: {
            inputStream = null;
            try {
                inputStream = new FileInputStream(new File(Path2));
            }
            catch (Exception e) {
                StreamUtils.closeStream(null, inputStream);
                inputStream = DeviceGraphConfig.class.getResourceAsStream(Path2);
                if (inputStream != null) break block2;
                LOGGER.error("cannot get file, path is: " + Path2);
            }
        }
        return inputStream;
    }

    public static synchronized DeviceGraphConfig getInstance() {
        boolean isHDGraph = ApplicationContext.getInstance().isHDGraph();
        if (null == instance) {
            instance = new DeviceGraphConfig(isHDGraph);
        }
        return instance;
    }

    public EnclosureCfg getEnclosureCfg(String logicType, String model) {
        String validMode = StringUtils.isNULLStr(model) ? "default" : model;
        Map<String, EnclosureCfg> map = this.enclosureMap.get(logicType);
        return null == map ? null : map.get(validMode.toUpperCase(Locale.ENGLISH));
    }

    public EnclosureCfg getHdEnclosureCfg(String logicType, String model) {
        String validModel = StringUtils.isNULLStr(model) ? "default" : model;
        Map<String, EnclosureCfg> map = this.hdEnclosureMap.get(logicType);
        return null == map ? null : map.get(validModel.toUpperCase(Locale.ENGLISH));
    }

    public ModuleCfg getModuleCfg(String type, String model) {
        String validModel = StringUtils.isNULLStr(model) ? "default" : model;
        Map<String, ModuleCfg> map = this.moduleMap.get(type);
        return null == map ? null : map.get(validModel.toUpperCase(Locale.ENGLISH));
    }

    public ModuleCfg getHdModuleCfg(String type, String model) {
        String validModel = StringUtils.isNULLStr(model) ? "default" : model;
        Map<String, ModuleCfg> map = this.hdModuleMap.get(type);
        return null == map ? null : map.get(validModel.toUpperCase(Locale.ENGLISH));
    }

    public RackCfg getRackCfg() {
        return this.rackCfg;
    }

    public EnclosureCfg getFirstEnclosure() {
        return this.firstEnclosure;
    }

    public ImageIcon getImage(String imageName) {
        String path = this.getImagePath(imageName);
        InputStream imageStream = this.getInputStream(path);
        if (imageStream != null) {
            File imageTempFile = FileUtils.getTempFileFromInputStream(imageStream, imageName);
            return new ImageIcon(FilePathUtils.getCanonicalPath(imageTempFile));
        }
        LOGGER.error(imageName + " not found");
        return null;
    }

    public String getImagePath(String imageName) {
        if (IMG_PATH.startsWith("/cbb")) {
            return IMG_PATH + "/" + imageName;
        }
        return IMG_PATH + File.separator + imageName;
    }

    public String getHDImagePath(String imageName) {
        if (HD_IMG_PATH.startsWith("/cbb")) {
            return HD_IMG_PATH + "/" + imageName;
        }
        return HD_IMG_PATH + File.separator + imageName;
    }

    public ImageIcon getHDImage(String imageName) {
        String path = this.getHDImagePath(imageName);
        InputStream imageStream = DeviceGraphConfig.class.getResourceAsStream(path);
        if (imageStream != null) {
            File imageTempFile = FileUtils.getTempFileFromInputStream(imageStream, imageName);
            return new ImageIcon(FilePathUtils.getCanonicalPath(imageTempFile));
        }
        LOGGER.error(imageName + " not found");
        return null;
    }

    private void parseBayCfg(Element root, boolean isHDGraph) {
        RackCfg rack = isHDGraph ? this.hdRackCfg : this.rackCfg;
        Element racksElem = XmlUtils.getChild(root, "racks");
        if (null == racksElem) {
            LOGGER.info("No rack elements configured.");
            return;
        }
        Element rackElem = XmlUtils.getChild(racksElem, "rack");
        rack.setBackImage(XmlUtils.getAttribute(rackElem, "backImage"));
        rack.setFrontImage(XmlUtils.getAttribute(rackElem, "frontImage"));
        rack.setType(XmlUtils.getAttribute(rackElem, "type"));
        rack.setHeight(Integer.parseInt(XmlUtils.getAttribute(rackElem, "height")));
        rack.setWidth(Integer.parseInt(XmlUtils.getAttribute(rackElem, "width")));
        rack.setUnitHeight(Integer.parseInt(XmlUtils.getAttribute(rackElem, "unitHeight")));
        rack.setPadding(Integer.parseInt(XmlUtils.getAttribute(rackElem, "padding")));
    }

    private void buildSlotMap(Element e, Map<String, Map<String, SlotCfg>> frontSlotMap, Map<String, Map<String, SlotCfg>> backSlotMap) {
        for (Element elem : XmlUtils.getChildren(e, "slotType")) {
            ViewType view;
            Map<String, Map<String, SlotCfg>> typeSlotMap;
            Map<String, SlotCfg> map;
            String type = XmlUtils.getAttribute(elem, "type");
            int width = Integer.parseInt(XmlUtils.getAttribute(elem, "width"));
            int height = Integer.parseInt(XmlUtils.getAttribute(elem, "height"));
            String maskImage = XmlUtils.getAttribute(elem, "maskImage");
            String viewType = XmlUtils.getAttribute(elem, "viewType");
            if (null == viewType) {
                viewType = "FRONT";
            }
            if (null == (map = (typeSlotMap = ViewType.FRONT.equals((Object)(view = ViewType.valueOf(viewType.toUpperCase(Locale.ENGLISH)))) ? frontSlotMap : backSlotMap).get(type))) {
                map = new HashMap<String, SlotCfg>();
                typeSlotMap.put(type, map);
            }
            for (Element slotEm : XmlUtils.getChildren(elem, "slot")) {
                String name = XmlUtils.getAttribute(slotEm, "name");
                String[] coordinate = XmlUtils.getAttribute(slotEm, "coordinate").split(",");
                SlotCfg slot = new SlotCfg();
                slot.setxCoordinates(Integer.parseInt(coordinate[0]));
                slot.setyCoordinates(Integer.parseInt(coordinate[1]));
                slot.setWidth(width);
                slot.setHeight(height);
                slot.setMaskImage(maskImage);
                map.put(name, slot);
            }
        }
    }

    private void parseEnclosureCfg(Element root, boolean isHDGraph) {
        Map<String, Map<String, EnclosureCfg>> enc = isHDGraph ? this.hdEnclosureMap : this.enclosureMap;
        Element enclosureRoot = XmlUtils.getChild(root, "enclosures");
        for (Element elem : XmlUtils.getChildren(enclosureRoot, "enclosure")) {
            String model;
            String logicType = XmlUtils.getAttribute(elem, "logicType");
            Map<String, EnclosureCfg> map = enc.get(logicType);
            if (null == map) {
                map = new HashMap<String, EnclosureCfg>();
                enc.put(logicType.toUpperCase(Locale.ENGLISH), map);
            }
            if (StringUtils.isNULLStr(model = XmlUtils.getAttribute(elem, "model"))) {
                model = "default";
            }
            EnclosureCfg en = new EnclosureCfg();
            en.setWidth(Integer.parseInt(XmlUtils.getAttribute(elem, "width")));
            en.setHeight(Integer.parseInt(XmlUtils.getAttribute(elem, "height")));
            en.setUnitCount(Integer.parseInt(XmlUtils.getAttribute(elem, "unitCount")));
            en.setFrontImage(XmlUtils.getAttribute(elem, "frontImage"));
            en.setBackImage(XmlUtils.getAttribute(elem, "backImage"));
            HashMap<String, Map<String, SlotCfg>> frontSlotMap = new HashMap<String, Map<String, SlotCfg>>();
            HashMap<String, Map<String, SlotCfg>> backSlotMap = new HashMap<String, Map<String, SlotCfg>>();
            this.buildSlotMap(elem, frontSlotMap, backSlotMap);
            if (isHDGraph) {
                en.setHdFrontSlotMap(frontSlotMap);
                en.setHdBackSlotMap(backSlotMap);
            } else {
                en.setFrontSlotMap(frontSlotMap);
                en.setBackSlotMap(backSlotMap);
            }
            if (this.firstEnclosure == null) {
                this.firstEnclosure = en;
            }
            map.put(model.toUpperCase(Locale.ENGLISH), en);
        }
    }

    private void parseModuleCfg(Element root, boolean isHdGraph) {
        Map<String, Map<String, ModuleCfg>> mmap = isHdGraph ? this.hdModuleMap : this.moduleMap;
        Element moduleRoot = XmlUtils.getChild(root, "modules");
        for (Element elem : XmlUtils.getChildren(moduleRoot, "module")) {
            String model;
            String type = XmlUtils.getAttribute(elem, "type");
            Map<String, ModuleCfg> map = mmap.get(type);
            if (null == map) {
                map = new HashMap<String, ModuleCfg>();
                mmap.put(type.toUpperCase(Locale.ENGLISH), map);
            }
            if (StringUtils.isNULLStr(model = XmlUtils.getAttribute(elem, "model"))) {
                model = "default";
            }
            ModuleCfg module = new ModuleCfg();
            module.setWidth(Integer.parseInt(XmlUtils.getAttribute(elem, "width")));
            module.setHeight(Integer.parseInt(XmlUtils.getAttribute(elem, "height")));
            module.setFrontImage(XmlUtils.getAttribute(elem, "frontImage"));
            HashMap<String, Map<String, SlotCfg>> frontSlotMap = new HashMap<String, Map<String, SlotCfg>>();
            this.buildSlotMap(elem, frontSlotMap, new HashMap<String, Map<String, SlotCfg>>());
            if (isHdGraph) {
                module.setHdFrontSlotMap(frontSlotMap);
            } else {
                module.setFrontSlotMap(frontSlotMap);
            }
            map.put(model.toUpperCase(Locale.ENGLISH), module);
        }
    }
}

