/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.ui.components;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tool.devicegraph.Constants;
import com.huawei.ism.tool.devicegraph.config.DeviceGraphConfig;
import com.huawei.ism.tool.devicegraph.config.EnclosureCfg;
import com.huawei.ism.tool.devicegraph.config.ModuleCfg;
import com.huawei.ism.tool.devicegraph.config.SlotCfg;
import com.huawei.ism.tool.devicegraph.util.GraphUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class EnclosureHDGraph
extends mxGraphComponent {
    private static final long serialVersionUID = 7373877675549909660L;
    private static DeviceGraphConfig graphCfg = DeviceGraphConfig.getInstance();
    private IEnclosureInfo info = null;
    private List<IHardwareInfo> frontSubModules = new ArrayList<IHardwareInfo>();
    private List<IHardwareInfo> backSubModules = new ArrayList<IHardwareInfo>();
    private int rackIndex = 0;
    private boolean isBack;
    private EnclosureCfg enclosureCfg = null;
    private mxGraph graph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnclosureHDGraph(IEnclosureInfo info, List<IHardwareInfo> hardwaresInEn, boolean isBack, mxGraph graphValue) {
        super(graphValue);
        this.graph = graphValue;
        try {
            this.info = info;
            this.isBack = isBack;
            this.enclosureCfg = graphCfg.getHdEnclosureCfg(info.getLogicTypeName(), info.getModelName());
            if (null == this.enclosureCfg) {
                throw new EncapsulatedRuntimeException("enclosureCfg is null.");
            }
            Object parent = this.graph.getDefaultParent();
            this.graph.getModel().beginUpdate();
            this.classifySubModules(hardwaresInEn);
            String img = DeviceGraphConfig.getInstance().getHDImagePath(this.enclosureCfg.getBackImage());
            mxCell cell = GraphUtils.addImage(this.graph, parent, img, new Rectangle(0, 0, this.getEnclosureWidth(), this.getEnclosureHeight()));
            this.graph.setDefaultParent(cell);
            if (isBack) {
                this.initBackSubModules();
            } else {
                this.initFrontSubModules();
            }
            GraphUtils.setDefaultStyle(this.graph, this);
            this.setOpaque(true);
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    private void initFrontSubModules() {
        Object parent = this.graph.getDefaultParent();
        for (IHardwareInfo subModule : this.frontSubModules) {
            SlotCfg slotCfg = this.enclosureCfg.getFrontCfgByLocation(subModule.getTypeName(), subModule.getLocation());
            if (slotCfg == null) continue;
            String img = DeviceGraphConfig.getInstance().getImagePath(slotCfg.getMaskImage());
            int x = Constants.PLACE_HOLDER_CELL_WIDTH + slotCfg.getxCoordinates();
            int y = slotCfg.getyCoordinates();
            GraphUtils.addImage(this.graph, parent, img, new Rectangle(x, y, slotCfg.getWidth(), slotCfg.getHeight()));
        }
    }

    private void initBackSubModules() {
        Object parent = this.graph.getDefaultParent();
        for (IHardwareInfo subModule : this.backSubModules) {
            SlotCfg slotCfg = null;
            String img = "";
            if (MOType.INTF_MODULE.name().equals(subModule.getTypeName())) {
                ModuleCfg moduleCfg;
                slotCfg = this.enclosureCfg.getBackCfgByLocation(subModule.getTypeName(), subModule.getLocation());
                if (ApplicationContext.getInstance().isHDGraph()) {
                    slotCfg = this.enclosureCfg.getHdBackCfgByLocation(subModule.getTypeName(), subModule.getLocation());
                }
                if (null == (moduleCfg = DeviceGraphConfig.getInstance().getHdModuleCfg(subModule.getTypeName(), subModule.getModelName()))) continue;
                img = DeviceGraphConfig.getInstance().getImagePath(moduleCfg.getFrontImage());
                if (ApplicationContext.getInstance().isHDGraph()) {
                    img = DeviceGraphConfig.getInstance().getHDImagePath(moduleCfg.getFrontImage());
                }
            } else {
                slotCfg = this.enclosureCfg.getBackCfgByLocation(subModule.getTypeName(), subModule.getLocation());
                if (ApplicationContext.getInstance().isHDGraph()) {
                    slotCfg = this.enclosureCfg.getHdBackCfgByLocation(subModule.getTypeName(), subModule.getLocation());
                }
                if (slotCfg == null) continue;
                img = DeviceGraphConfig.getInstance().getImagePath(slotCfg.getMaskImage());
                if (ApplicationContext.getInstance().isHDGraph()) {
                    img = DeviceGraphConfig.getInstance().getHDImagePath(slotCfg.getMaskImage());
                }
            }
            if (slotCfg == null) continue;
            int x = slotCfg.getxCoordinates();
            int y = slotCfg.getyCoordinates();
            GraphUtils.addImage(this.graph, parent, img, new Rectangle(x, y, slotCfg.getWidth(), slotCfg.getHeight()));
        }
    }

    private void classifySubModules(List<IHardwareInfo> subModules) {
        for (IHardwareInfo subModule : subModules) {
            if (EnumDefine.ENCLOSURE_TYPE_E.CTRL.name().equals(this.info.getLogicTypeName())) {
                this.classifyCtrlSubModules(subModule);
                continue;
            }
            if (EnumDefine.ENCLOSURE_TYPE_E.EXP.name().equals(this.info.getLogicTypeName())) {
                this.classifyExpSubModules(subModule);
                continue;
            }
            if (EnumDefine.ENCLOSURE_TYPE_E.DSW.name().equals(this.info.getLogicTypeName())) {
                this.classifyDswSubModules(subModule);
                continue;
            }
            if ("SVP".equals(this.info.getLogicTypeName())) {
                this.classifySvpSubModules(subModule);
                continue;
            }
            return;
        }
    }

    private void classifyCtrlSubModules(IHardwareInfo subModule) {
        if (MOType.BACKUP_POWER.name().equals(subModule.getTypeName())) {
            this.frontSubModules.add(subModule);
        } else if (MOType.INTF_MODULE.name().equals(subModule.getTypeName()) || MOType.POWER.name().equals(subModule.getTypeName())) {
            this.backSubModules.add(subModule);
        } else {
            this.frontSubModules.add(subModule);
            this.backSubModules.add(subModule);
        }
    }

    private void classifyExpSubModules(IHardwareInfo subModule) {
        if (MOType.DISK.name().equals(subModule.getTypeName())) {
            this.frontSubModules.add(subModule);
        } else if (MOType.EXPBOARD.name().equals(subModule.getTypeName()) || MOType.FAN.name().equals(subModule.getTypeName()) || MOType.POWER.name().equals(subModule.getTypeName())) {
            this.backSubModules.add(subModule);
        }
    }

    private void classifyDswSubModules(IHardwareInfo subModule) {
        if (MOType.POWER.name().equals(subModule.getTypeName()) || MOType.FAN.name().equals(subModule.getTypeName())) {
            this.frontSubModules.add(subModule);
        }
    }

    private void classifySvpSubModules(IHardwareInfo subModule) {
        if (MOType.DISK.name().equals(subModule.getTypeName())) {
            this.frontSubModules.add(subModule);
        } else if (MOType.POWER.name().equals(subModule.getTypeName())) {
            this.backSubModules.add(subModule);
        }
    }

    public int getRackIndex() {
        return this.rackIndex;
    }

    public void setRackIndex(int rackIndex) {
        this.rackIndex = rackIndex;
    }

    public IEnclosureInfo getEnclosureInfo() {
        return this.info;
    }

    public int getEnclosureHeight() {
        return this.enclosureCfg.getHeight();
    }

    public int getEnclosureWidth() {
        return this.enclosureCfg.getWidth();
    }

    public int getStartU() {
        String[] strs = this.info.getLocation().split("\\.");
        return Integer.parseInt(strs[1].replaceAll("U", ""));
    }
}

