/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.file;

import com.huawei.ism.tool.obase.utils.StringUtils;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    private static final List<String> CMD_BLACK_LIST = Arrays.asList("<", ">", "&", "|", "'", "$", ";", "!", "`", "\\\\", "\\\n");

    public static boolean isCmdInject(String cmd) {
        if (StringUtils.isNULLStr(cmd)) {
            return false;
        }
        String tempCmd = cmd.toLowerCase(Locale.ENGLISH);
        return CMD_BLACK_LIST.stream().anyMatch(tempCmd::contains);
    }

    public static Optional<SecureRandom> createSecureRandom() {
        try {
            SecureRandom source = SecureRandom.getInstanceStrong();
            int cipherLen = 256;
            byte[] nonce = new byte[cipherLen / 2];
            source.nextBytes(nonce);
            SP800SecureRandom random = new SP800SecureRandomBuilder(source, true).setEntropyBitsRequired(384).buildCTR((BlockCipher)AESEngine.newInstance(), cipherLen, nonce, false);
            random.nextInt();
            return Optional.of(random);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("No such algorithm found.", e);
            return Optional.empty();
        }
    }

    public static String generatePassword(int pwdLen) throws InvalidParameterException {
        if (pwdLen < 8) {
            throw new InvalidParameterException("Invalid password length.");
        }
        SecureRandom random = SecurityUtils.createSecureRandom().orElseThrow(() -> new InvalidParameterException("No such algorithm found."));
        StringBuilder defaultPwd = new StringBuilder();
        String dict = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789`#$%^&-_=+";
        int digitChar = 0;
        int lowCaseChar = 0;
        int topCaseChar = 0;
        int specialChar = 0;
        int dictLen = dict.length();
        while (defaultPwd.length() < pwdLen) {
            char c = dict.charAt(random.nextInt(dictLen));
            defaultPwd.append(c);
            if (c >= 'a' && c <= 'z') {
                lowCaseChar = 1;
            } else if (c >= 'A' && c <= 'Z') {
                topCaseChar = 1;
            } else if (c >= '0' && c <= '9') {
                digitChar = 1;
            } else {
                specialChar = 1;
            }
            if (defaultPwd.length() != pwdLen || digitChar + lowCaseChar + topCaseChar + specialChar != 1) continue;
            defaultPwd.deleteCharAt(0);
        }
        return defaultPwd.toString();
    }

    public static String generateAuthorizationKey() {
        return SecurityUtils.generatePassword(36);
    }

    private SecurityUtils() {
    }
}

