/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.IDeviceDiscoveryService;
import com.huawei.ism.tool.obase.connection.CustomDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.MultiRouteManager;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.ProdocutDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionCreator {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionCreator.class);
    private DevNode devNode = null;
    private ISshJudge sshJudge = null;
    private boolean pwdWillExpireBreak = false;
    private boolean isDeviceMgr = true;
    private String strictHostKeyChecking;
    private String knownHostsInfo;
    private IDeviceDiscoveryService service = (IDeviceDiscoveryService)PublicServiceManage.getInstance().getService(IDeviceDiscoveryService.class);

    public SshConnectionCreator(DevNode devNode, ISshJudge sshJudge, boolean pwdWillExpireBreak, boolean isDeviceMgr) {
        this.devNode = devNode;
        this.pwdWillExpireBreak = pwdWillExpireBreak;
        this.isDeviceMgr = isDeviceMgr;
        this.setSshJudge(devNode, sshJudge);
    }

    private void setSshJudge(DevNode node, ISshJudge judgeSSH) {
        DeviceType deviceType = node.getDeviceType();
        if (null != deviceType) {
            boolean isMatch;
            String type = node.getDeviceType().toString();
            log.info("ssh connection ! check the pkg:{} {} IDeviceDiscoveryService:", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)type), (Object)this.service);
            if (null != this.service && (isMatch = this.service.checkConfigProductPkg(type))) {
                log.info("ssh connection ! check the realy pkg:{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)type));
                Set judge = this.service.loadEchos(type);
                this.sshJudge = new ProdocutDefaultSshJudge(judge);
                return;
            }
        }
        boolean judge = judgeSSH == null;
        log.info("ssh connection ! sshJudge is null?:{}", (Object)judge);
        this.sshJudge = judge ? (this.sshJudge = new CustomDefaultSshJudge()) : judgeSSH;
    }

    public SshConnection create() throws ToolException {
        SshConnection connection = this.createConnectionBySocks5(this.devNode, this.pwdWillExpireBreak);
        if (connection == null) {
            connection = this.createConnectionByMultiRoutes(this.devNode, this.pwdWillExpireBreak);
        }
        if (connection == null) {
            connection = this.createSimpleSshConnection(this.devNode, this.pwdWillExpireBreak);
        }
        connection.setPwdWillExpireBreak(this.pwdWillExpireBreak);
        connection.setDeviceMgr(this.isDeviceMgr);
        return connection;
    }

    public SshConnection createKAdminConn() throws ToolException {
        return this.createKAdminSshConnection(this.devNode, this.pwdWillExpireBreak);
    }

    private SshConnection createConnectionBySocks5(DevNode node, boolean isPwdWillExpire) throws ToolException {
        Socks5Proxy proxy = node.getSocks5Proxy();
        if (proxy == null) {
            return null;
        }
        String ip = node.getIp();
        int port = node.getPort();
        SshConnection connection = new SshConnection(ip, node.getLoginUser(), port, node.getPriKey(), this.sshJudge);
        connection.setdNode(node);
        this.setConnectionCheckingInfo(connection);
        connection.connect(isPwdWillExpire, this.isDeviceMgr);
        return connection;
    }

    private SshConnection createConnectionByMultiRoutes(DevNode node, boolean isPwdWillExpire) throws ToolException {
        List<MultiRouteNode> routeNodes = node.getSshForwardList();
        if (routeNodes == null || routeNodes.isEmpty()) {
            return null;
        }
        MultiRouteManager multiRouteManager = new MultiRouteManager(routeNodes);
        String ip = node.getIp();
        SshConnection connection = null;
        try {
            connection = multiRouteManager.getTunnelConnection(node, this.sshJudge, isPwdWillExpire, this.isDeviceMgr, this::setConnectionCheckingInfo);
        }
        catch (Exception e) {
            log.error("get tunnel connection error.", e);
            multiRouteManager.close();
            throw new ToolException("build.connection.failed", new String[]{ip}, e.getMessage(), e);
        }
        return connection;
    }

    private SshConnection createSimpleSshConnection(DevNode dNode, boolean isPwdWillExpire) throws ToolException {
        SshConnection connection = new SshConnection(dNode.getIp(), dNode.getLoginUser(), dNode.getPort(), dNode.getPriKey(), this.sshJudge);
        connection.setdNode(dNode);
        this.setConnectionCheckingInfo(connection);
        connection.connect(isPwdWillExpire, this.isDeviceMgr);
        return connection;
    }

    private SshConnection createKAdminSshConnection(DevNode dNode, boolean isPwdWillExpire) throws ToolException {
        String userName = dNode.getKAdminUser().getUserName();
        String password = dNode.getKAdminUser().getPassword();
        SshConnection connection = new SshConnection(dNode.getIp(), userName, password, dNode.getPort(), this.sshJudge);
        connection.setdNode(dNode);
        this.setConnectionCheckingInfo(connection);
        connection.connect(isPwdWillExpire, this.isDeviceMgr);
        return connection;
    }

    private void setConnectionCheckingInfo(SshConnection connection) {
        if (!StringUtils.isNULLStr(this.strictHostKeyChecking)) {
            connection.setStrictHostKeyChecking(this.strictHostKeyChecking);
        }
        if (!StringUtils.isNULLStr(this.knownHostsInfo)) {
            connection.setKnownHostsInfo(this.knownHostsInfo);
        }
    }

    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public void setKnownHostsInfo(String knownHostsInfo) {
        this.knownHostsInfo = knownHostsInfo;
    }
}

