/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.wizard;

import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardTitlePane;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class WizardRootPaneUI
extends BasicRootPaneUI
implements Serializable {
    private static final long serialVersionUID = -6333312716713869858L;
    private static final String[] BORDER_KEYS = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private static final int[] CURSOR_MAPPING = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    private Window win;
    private JComponent titlePane;
    private transient MouseInputListener mouseInputListener;
    private transient LayoutManager layoutManager;
    private transient LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private JComponent titleComponent = null;
    private boolean isShowMinimize;
    private boolean isShowMaxsize;

    public JComponent getTitleComponent() {
        return this.titleComponent;
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpCallBack) {
        if (null == this.titleComponent) {
            return;
        }
        ((WizardTitlePane)this.titleComponent).setHelpActionObserver(helpCallBack);
    }

    public void setHelpIconNotShown() {
        if (null == this.titleComponent) {
            return;
        }
        ((WizardTitlePane)this.titleComponent).getHelpButton().hide();
        ((WizardTitlePane)this.titleComponent).getHelpButton().setEnabled(false);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WizardRootPaneUI();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        if (component instanceof JRootPane) {
            this.root = (JRootPane)component;
            int style = this.root.getWindowDecorationStyle();
            if (style != 0) {
                this.installClientDecorations(this.root);
            }
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    void installBorder(JRootPane rootPane) {
        int style = rootPane.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(rootPane);
        } else {
            LookAndFeel.installBorder(rootPane, BORDER_KEYS[style]);
        }
    }

    private void uninstallBorder(JRootPane rootPane) {
        LookAndFeel.uninstallBorder(rootPane);
    }

    private void installWindowListeners(Component parent) {
        this.win = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.win != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener();
            }
            this.win.addMouseListener(this.mouseInputListener);
            this.win.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners() {
        if (this.win != null) {
            this.win.removeMouseListener(this.mouseInputListener);
            this.win.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        this.titleComponent = new WizardTitlePane(jRootPane, this.isShowMinimize, this.isShowMaxsize);
        this.setTitlePane(jRootPane, this.titleComponent);
        this.installWindowListeners(jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.win != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners();
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        int style = jRootPane.getWindowDecorationStyle();
        if (style == 0) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this.win != null) {
            this.win.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.win = null;
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane rootPane, JComponent tPane) {
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (tPane != null) {
            layeredPane.add((Component)tPane, JLayeredPane.FRAME_CONTENT_LAYER);
            tPane.setVisible(true);
        }
        this.titlePane = tPane;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        String propertyName = event.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane rootPane = (JRootPane)event.getSource();
            int style = rootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(rootPane);
            if (style != 0) {
                this.installClientDecorations(rootPane);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners();
            if (((JRootPane)event.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root.getParent());
            }
        }
    }

    public void setShowMinimize(boolean isShowMinimize) {
        this.isShowMinimize = isShowMinimize;
    }

    public boolean isShowMinimize() {
        return this.isShowMinimize;
    }

    public void setShowMaxsize(boolean isShowMaxsize) {
        this.isShowMaxsize = isShowMaxsize;
    }

    public boolean isShowMaxsize() {
        return this.isShowMaxsize;
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            JRootPane rootPane = WizardRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = event.getPoint();
            Window window = (Window)event.getSource();
            if (null == window) {
                return;
            }
            window.toFront();
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(window, dragWindowOffset, WizardRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int frameState = frame != null ? frame.getExtendedState() : 0;
            this.pressMouse(dragWindowOffset, window, convertedDragWindowOffset, frame, dialog, frameState);
        }

        private void pressMouse(Point dragWindowOffset, Window window, Point convertedDragWindowOffset, Frame frame, Dialog dialog, int frameState) {
            boolean part3;
            JComponent pane = WizardRootPaneUI.this.getTitlePane();
            boolean part1 = frame != null && frame.isResizable();
            boolean part2 = (frameState & 6) == 0;
            boolean bl = part3 = dialog != null && dialog.isResizable();
            if (pane != null && pane.contains(convertedDragWindowOffset)) {
                this.reduceDepth(dragWindowOffset, window, frame, dialog, frameState);
            } else if (part1 && part2 || part3) {
                this.dragOffsetX = (int)dragWindowOffset.getX();
                this.dragOffsetY = (int)dragWindowOffset.getY();
                this.dragWidth = window.getWidth();
                this.dragHeight = window.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(window, (int)dragWindowOffset.getX(), (int)dragWindowOffset.getY()));
            }
        }

        private void reduceDepth(Point dragWindowOffset, Window window, Frame frame, Dialog dialog, int frameState) {
            boolean temp;
            boolean bl = temp = frame != null && (frameState & 6) == 0 || dialog != null;
            if (temp && (int)dragWindowOffset.getY() >= 5 && (int)dragWindowOffset.getX() >= 5 && (int)dragWindowOffset.getX() < window.getWidth() - 5) {
                this.isMovingWindow = true;
                this.dragOffsetY = (int)dragWindowOffset.getY();
                this.dragOffsetX = (int)dragWindowOffset.getX();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (this.dragCursor != 0 && WizardRootPaneUI.this.win != null && !WizardRootPaneUI.this.win.isValid()) {
                WizardRootPaneUI.this.win.validate();
                WizardRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            boolean tmp;
            JRootPane rootPane = WizardRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Window wind = (Window)event.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (wind instanceof Frame) {
                frame = (Frame)wind;
            } else if (wind instanceof Dialog) {
                dialog = (Dialog)wind;
            }
            int cursor = this.getCursor(this.calculateCorner(wind, event.getX(), event.getY()));
            boolean bl = tmp = frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0;
            if (cursor != 0 && (tmp || dialog != null && dialog.isResizable())) {
                wind.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                wind.setCursor(WizardRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension dim, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            int correction;
            int xValue = (int)(bounds.getX() + (double)deltaX);
            int yValue = (int)(bounds.getY() + (double)deltaY);
            bounds.setLocation(xValue, yValue);
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (dim == null) {
                return;
            }
            if (bounds.width < dim.width) {
                correction = dim.width - bounds.width;
                if (deltaX != 0) {
                    int boundsRecX = (int)bounds.getX();
                    int boundsRecY = (int)bounds.getY();
                    bounds.setBounds(boundsRecX -= correction, boundsRecY, bounds.width, bounds.height);
                }
                bounds.width = dim.width;
            }
            if (bounds.height < dim.height) {
                correction = dim.height - bounds.height;
                if (deltaY != 0) {
                    int boundsY = (int)bounds.getY();
                    int boundsX = (int)bounds.getX();
                    bounds.setBounds(boundsX, boundsY -= correction, bounds.width, bounds.height);
                }
                bounds.height = dim.height;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Window wind = (Window)mouseEvent.getSource();
            Point pt = mouseEvent.getPoint();
            if (this.isMovingWindow) {
                Point eventLocationOnScreen = mouseEvent.getLocationOnScreen();
                wind.setLocation((int)(eventLocationOnScreen.getX() - (double)this.dragOffsetX), (int)(eventLocationOnScreen.getY() - (double)this.dragOffsetY));
            } else if (this.dragCursor == 0) {
                return;
            }
            Rectangle windRectangle = wind.getBounds();
            Rectangle startBounds = new Rectangle(windRectangle);
            Dimension min = wind.getMinimumSize();
            this.adjustPosition(pt, windRectangle, min);
            if (!windRectangle.equals(startBounds)) {
                wind.setBounds(windRectangle);
                if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                    wind.validate();
                    WizardRootPaneUI.this.getRootPane().repaint();
                }
            }
        }

        private void adjustPosition(Point point, Rectangle rectangle, Dimension dimension) {
            switch (this.dragCursor) {
                case 11: {
                    this.adjust(rectangle, dimension, 0, 0, (int)(point.getX() + (double)(this.dragWidth - this.dragOffsetX) - (double)rectangle.width), 0);
                    break;
                }
                case 9: {
                    this.adjust(rectangle, dimension, 0, 0, 0, (int)(point.getY() + (double)(this.dragHeight - this.dragOffsetY) - (double)rectangle.height));
                    break;
                }
                case 8: {
                    this.adjust(rectangle, dimension, 0, (int)(point.getY() - (double)this.dragOffsetY), 0, -((int)point.getY() - this.dragOffsetY));
                    break;
                }
                case 10: {
                    this.adjust(rectangle, dimension, (int)point.getX() - this.dragOffsetX, 0, -((int)point.getX() - this.dragOffsetX), 0);
                    break;
                }
                case 7: {
                    this.adjust(rectangle, dimension, 0, (int)point.getY() - this.dragOffsetY, (int)point.getX() + (this.dragWidth - this.dragOffsetX) - rectangle.width, -((int)point.getY() - this.dragOffsetY));
                    break;
                }
                case 5: {
                    this.adjust(rectangle, dimension, 0, 0, (int)point.getX() + (this.dragWidth - this.dragOffsetX) - rectangle.width, (int)point.getY() + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                    break;
                }
                case 6: {
                    this.adjust(rectangle, dimension, (int)point.getX() - this.dragOffsetX, (int)point.getY() - this.dragOffsetY, -((int)point.getX() - this.dragOffsetX), -((int)point.getY() - this.dragOffsetY));
                    break;
                }
                case 4: {
                    this.adjust(rectangle, dimension, (int)point.getX() - this.dragOffsetX, 0, -((int)point.getX() - this.dragOffsetX), (int)point.getY() + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                    break;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            WizardRootPaneUI.this.lastCursor = window.getCursor();
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            Window window = (Window)event.getSource();
            window.setCursor(WizardRootPaneUI.this.lastCursor);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Window window = (Window)event.getSource();
            if (!(window instanceof Frame)) {
                return;
            }
            Frame frame = (Frame)window;
            Point convertedPoint = SwingUtilities.convertPoint(window, event.getPoint(), WizardRootPaneUI.this.getTitlePane());
            int state = frame.getExtendedState();
            JComponent component = WizardRootPaneUI.this.getTitlePane();
            if (null == component || !component.contains(convertedPoint)) {
                return;
            }
            if (event.getClickCount() % 2 == 0 && (event.getModifiers() & 0x10) != 0) {
                if (!frame.isResizable()) {
                    return;
                }
                IsmPlafUtils.setFrameMaxBounds((Frame)frame);
                if ((state & 6) != 0) {
                    frame.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(state | 6);
                }
            }
        }

        private int calculateCorner(Window window, int xValue, int yValue) {
            Insets insets = window.getInsets();
            int xPosition = this.calculatePosition(xValue - insets.left, window.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(yValue - insets.top, window.getHeight() - insets.top - insets.bottom);
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return CURSOR_MAPPING[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension cpdDim = null;
            int cpdWidth = 0;
            int cpdHeight = 0;
            Dimension mbdDim = null;
            int mbdWidth = 0;
            int mbdHeight = 0;
            Dimension tpdDim = null;
            int tpdWidth = 0;
            int tpdHeight = 0;
            if (parent instanceof JRootPane) {
                JRootPane rootPane = (JRootPane)parent;
                cpdDim = this.createCpdData(rootPane);
                mbdDim = this.createMbdData(rootPane);
                tpdDim = this.createTpdData(rootPane);
                if (cpdDim != null) {
                    cpdWidth = cpdDim.width;
                    cpdHeight = cpdDim.height;
                }
                if (mbdDim != null) {
                    mbdWidth = mbdDim.width;
                    mbdHeight = mbdDim.height;
                }
                if (tpdDim != null) {
                    tpdWidth = tpdDim.width;
                    tpdHeight = tpdDim.height;
                }
            }
            Insets insets = parent.getInsets();
            return new Dimension(Math.max(Math.max(cpdWidth, mbdWidth), tpdWidth) + insets.left + insets.right, cpdHeight + mbdHeight + tpdHeight + insets.top + insets.bottom);
        }

        private Dimension createTpdData(JRootPane root) {
            JComponent titlePane;
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof WizardRootPaneUI && (titlePane = ((WizardRootPaneUI)root.getUI()).getTitlePane()) != null) {
                return titlePane.getPreferredSize();
            }
            return null;
        }

        private Dimension createMbdData(JRootPane root) {
            if (root.getJMenuBar() != null) {
                return root.getJMenuBar().getPreferredSize();
            }
            return null;
        }

        private Dimension createCpdData(JRootPane root) {
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            return cpd;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd = null;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets insets = parent.getInsets();
            if (parent instanceof JRootPane) {
                JComponent titlePane;
                Dimension mbd;
                Dimension cpd;
                JRootPane rootPane = (JRootPane)parent;
                Container container = rootPane.getContentPane();
                Dimension dimension = cpd = container != null ? container.getMinimumSize() : rootPane.getSize();
                if (cpd != null) {
                    cpWidth = cpd.width;
                    cpHeight = cpd.height;
                }
                if (rootPane.getJMenuBar() != null && (mbd = rootPane.getJMenuBar().getMinimumSize()) != null) {
                    mbWidth = mbd.width;
                    mbHeight = mbd.height;
                }
                if (rootPane.getWindowDecorationStyle() != 0 && rootPane.getUI() instanceof WizardRootPaneUI && (titlePane = ((WizardRootPaneUI)rootPane.getUI()).getTitlePane()) != null) {
                    tpd = titlePane.getMinimumSize();
                }
            }
            if (tpd != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + insets.left + insets.right, cpHeight + mbHeight + tpHeight + insets.top + insets.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd = null;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets insets = target.getInsets();
            if (target instanceof JRootPane) {
                JComponent titlePane;
                Dimension mbd;
                Dimension cpd;
                JRootPane root = (JRootPane)target;
                if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                    cpWidth = cpd.width;
                    cpHeight = cpd.height;
                }
                if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                    mbWidth = mbd.width;
                    mbHeight = mbd.height;
                }
                if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof WizardRootPaneUI && (titlePane = ((WizardRootPaneUI)root.getUI()).getTitlePane()) != null) {
                    tpd = titlePane.getMaximumSize();
                }
            }
            if (tpd != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + insets.top + insets.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += insets.left + insets.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (parent instanceof JRootPane) {
                Dimension tpd;
                JRootPane rootPane = (JRootPane)parent;
                Rectangle rootPaneBounds = rootPane.getBounds();
                Insets insets = rootPane.getInsets();
                int nextY = 0;
                int wValue = rootPaneBounds.width - insets.right - insets.left;
                int hValue = rootPaneBounds.height - insets.top - insets.bottom;
                JComponent titlePane = null;
                if (rootPane.getLayeredPane() != null) {
                    rootPane.getLayeredPane().setBounds(insets.left, insets.top, wValue, hValue);
                }
                if (rootPane.getGlassPane() != null) {
                    rootPane.getGlassPane().setBounds(insets.left, insets.top, wValue, hValue);
                }
                if (rootPane.getWindowDecorationStyle() != 0 && rootPane.getUI() instanceof WizardRootPaneUI) {
                    titlePane = ((WizardRootPaneUI)rootPane.getUI()).getTitlePane();
                }
                if (titlePane != null && (tpd = titlePane.getPreferredSize()) != null) {
                    int tpHeight = tpd.height;
                    titlePane.setBounds(0, 0, wValue, tpHeight);
                    nextY += tpHeight;
                }
                if (rootPane.getJMenuBar() != null) {
                    Dimension mbd = rootPane.getJMenuBar().getPreferredSize();
                    rootPane.getJMenuBar().setBounds(0, nextY, wValue, mbd.height);
                    nextY += mbd.height;
                }
                if (rootPane.getContentPane() != null) {
                    rootPane.getContentPane().setBounds(0, nextY, wValue, hValue < nextY ? 0 : hValue - nextY);
                }
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

