/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.wizard;

import com.huawei.ism.tool.obase.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.plaf.FontUIResource;

public class WizardStepItem
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel stepPpanel = new JPanel();
    private WizardNumberPanel numberPanel = null;
    private JTextArea descriptionTextArea = null;
    private String stepName = null;
    private boolean currentStep = false;
    private String description = null;
    private int stepNumber = 1;
    private JLabel stepLabel = null;

    public WizardStepItem(String stepName, String descrip, int stepNumber) {
        this.stepName = stepName;
        this.description = descrip;
        this.stepNumber = stepNumber;
        this.initUI();
    }

    private void initUI() {
        this.stepLabel = new JLabel(this.stepName);
        Dimension dimension = new Dimension(151, (int)this.stepLabel.getPreferredSize().getHeight());
        UiMethod.setComponentSize(dimension, this.stepLabel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.insets.right = 10;
        this.stepPpanel.setLayout(new BoxLayout(this.stepPpanel, 0));
        this.numberPanel = new WizardNumberPanel(this.stepNumber);
        this.stepPpanel.add(this.numberPanel);
        this.stepPpanel.add(Box.createHorizontalStrut(10));
        this.stepPpanel.add(this.stepLabel);
        this.add((Component)this.stepPpanel, gridBagConstraints);
        if (!StringUtils.isNULLStr(this.description)) {
            this.descriptionTextArea = UCD.createTextArea((String)this.description);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets.top = 12;
            this.add((Component)this.descriptionTextArea, gridBagConstraints);
            this.descriptionTextArea.setFont(this.getStandtardsDescriptionFont());
            this.descriptionTextArea.setForeground(WizardConstants.WIZARD_STEP_CURRENT_STEP_DESCRIPTION_COLOR);
        }
        this.setBackground(WizardConstants.WIZARD_BACKGROUND);
        this.stepPpanel.setBackground(WizardConstants.WIZARD_BACKGROUND);
        this.stepLabel.setBackground(WizardConstants.WIZARD_BACKGROUND);
        this.stepLabel.setForeground(WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
        this.stepLabel.setFont(this.getStandtardsStepFont());
        this.numberPanel.setLableFont(IsmFontFactory.getArialBold13());
    }

    public void setLabelTextColor(Color color) {
        this.stepLabel.setForeground(color);
    }

    public JTextArea getDescriptionTextArea() {
        return this.descriptionTextArea;
    }

    public void setDescriptionTextArea(JTextArea descriptionTextArea) {
        this.descriptionTextArea = descriptionTextArea;
    }

    public JLabel getStepLabel() {
        return this.stepLabel;
    }

    public JPanel getStepPpanel() {
        return this.stepPpanel;
    }

    public void setStepPpanel(JPanel stepPpanel) {
        this.stepPpanel = stepPpanel;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setStepNumber(int number) {
        this.stepNumber = number;
    }

    public String getDesciption() {
        return this.description;
    }

    public boolean isCurrent() {
        return this.currentStep;
    }

    @Override
    public String toString() {
        return this.stepName + this.description;
    }

    @Override
    public String getUIClassID() {
        return "WizardStepItemUI";
    }

    public void setSelected(boolean isCurrent) {
        this.currentStep = isCurrent;
        this.numberPanel.setCurrent(isCurrent);
    }

    private FontUIResource getStandtardsStepFont() {
        if (!ApplicationContext.getInstance().isEnglishEnv()) {
            return IsmFontFactory.getSimSunBold13();
        }
        return IsmFontFactory.getArialBold13();
    }

    private FontUIResource getStandtardsDescriptionFont() {
        if (!ApplicationContext.getInstance().isEnglishEnv()) {
            return IsmFontFactory.getSimSunPlain12();
        }
        return IsmFontFactory.getArailPlain12();
    }

    static class WizardNumberPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel jLabel = new JLabel();
        private boolean currentPanel = false;

        public WizardNumberPanel(int number) {
            String numberStr = "" + number;
            this.jLabel.setText(numberStr);
            this.jLabel.setForeground(WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
            this.add(this.jLabel);
        }

        @Override
        public String getUIClassID() {
            return "WizardNumberPanelUI";
        }

        public boolean isCurrent() {
            return this.currentPanel;
        }

        public void setCurrent(boolean isCurrent) {
            this.currentPanel = isCurrent;
        }

        public void setLableFont(FontUIResource font) {
            this.jLabel.setFont(font);
        }
    }
}

