/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.entity.DevMap;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EnvHelper {
    public static Map<String, String> getDevMapForRest(DevNode dev) {
        DevMap<String, String> devMapDict = new DevMap<String, String>();
        devMapDict.put("sn", dev.getDeviceSerialNumber());
        devMapDict.put("type", dev.getDeviceType().toString());
        devMapDict.put("version", dev.getProductVersion());
        devMapDict.put("name", dev.getDeviceName());
        devMapDict.put("ip", dev.getIp());
        devMapDict.put("tlvPort", "0");
        devMapDict.put("sshPort", String.valueOf(dev.getPort()));
        devMapDict.put("devInnerIpList", EnvHelper.buildIpListStr(dev.getIpList()));
        devMapDict.put("user", dev.getLoginUser().getUserName());
        devMapDict.put("pawd", dev.getLoginUser().getPassword());
        devMapDict.put("devPassword", dev.getDeveloperPwd());
        return devMapDict;
    }

    private static String buildIpListStr(List<String> ipList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ipList.size(); ++i) {
            String ip = ipList.get(i);
            if (StringUtils.isNULLStr(ip)) continue;
            sb.append(ip);
            if (i >= ipList.size() - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static boolean isSuppportRest(DevNode dev) {
        return EnvHelper.isDorado(dev) || dev.getProductVersion().compareTo("V300R006C00") >= 0;
    }

    public static boolean isDorado(DevNode dev) {
        return dev.getDeviceType().toString().toLowerCase(Locale.ENGLISH).contains("dorado");
    }
}

