/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class FileChooseUtils {
    private static final String DEFAULT_PATH_FILE = "file_choose_default.properties";
    private static final FileChooseUtils INSTANCE = new FileChooseUtils();
    private Properties propertites = null;
    private String tmpPath = ApplicationContext.getInstance().getTmpPath();

    /*
     * Loose catch block
     */
    private FileChooseUtils() {
        this.propertites = new Properties();
        FileInputStream is = null;
        try {
            File file = this.getChooseDefaultFile();
            is = new FileInputStream(file.getCanonicalFile());
            this.propertites.load(is);
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property load error. file {} not found.", (Object)DEFAULT_PATH_FILE);
            StreamUtils.closeStream(null, is);
        }
        catch (IOException e2) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property load error.", e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, is);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, is);
        }
        StreamUtils.closeStream(null, is);
    }

    public static FileChooseUtils getInstance() {
        return INSTANCE;
    }

    private File getChooseDefaultFile() throws IOException {
        File newFile;
        File tmpFile = new File(this.tmpPath);
        if (!tmpFile.exists() && !tmpFile.mkdir()) {
            ToolLoggerFactory.getLogger(this.getClass()).error("mkdir error.");
        }
        if (!(newFile = new File(this.tmpPath, DEFAULT_PATH_FILE)).exists() && !newFile.createNewFile()) {
            ToolLoggerFactory.getLogger(this.getClass()).error("create file error.");
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String put(String keyStr, String valueStr) {
        Enumeration<?> enumeration = this.propertites.propertyNames();
        if (!enumeration.hasMoreElements()) {
            this.propertites.setProperty(keyStr, valueStr);
        } else {
            Enumeration<?> e = this.propertites.propertyNames();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (s.equals(keyStr)) continue;
                this.propertites.setProperty(s, this.propertites.getProperty(s));
            }
            this.propertites.setProperty(keyStr, valueStr);
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(new File(ApplicationContext.getInstance().getTmpPath(), DEFAULT_PATH_FILE).getCanonicalFile());
            this.propertites.store(os, "test");
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property store error. file {} not found.", (Object)DEFAULT_PATH_FILE);
            StreamUtils.closeStream(os, null);
        }
        catch (IOException e2) {
            ToolLoggerFactory.getLogger(this.getClass()).error("property store error.", e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(os, null);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(os, null);
        }
        StreamUtils.closeStream(os, null);
        return valueStr;
    }

    public String get(String key) {
        return this.propertites.getProperty(key);
    }

    public Map<String, String> getMapData() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> e = this.propertites.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, this.propertites.getProperty(key));
        }
        return map;
    }
}

