/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final String TRUE = "true";
    private static final String PRODUCT_SUPORT_PKG_PATH = "productSuportPkgPath";
    private static final String END_CFG_TOOL_PREFER = "endCfgToolPrefer";
    private static final int BUFF_SIZE = 10240;
    private static final String TOOLKIT = "toolkit";
    private static final String PACKAGES = "packages";
    private static final String RW = "rw";
    private static final int TOOBIG = 0x40000000;
    private static final int TOOMANY = 10240;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHelpFromClasspath(ClassLoader cl, String fileName) {
        String helpDir = ApplicationContext.getInstance().getHelpPath();
        String lan = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        String vender = "_huawei";
        String chm = new StringBuffer(fileName).append("_" + lan).append(vender).append(".html").toString();
        String helpPath = new StringBuffer().append(helpDir).append("/").append(chm).toString();
        InputStream in = null;
        try {
            in = cl.getResourceAsStream(helpPath);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("get class path fialed when createHelpFromClasspath", e);
        }
        finally {
            StreamUtils.closeStream(null, in);
        }
        if (null == in) {
            return;
        }
        String workDir = ApplicationContext.getInstance().getWorkPath();
        String destChm = new StringBuffer(fileName).append("_" + lan).append(".html").toString();
        String destPath = new StringBuffer().append(workDir).append(File.separator).append(helpDir).append(File.separator).append(destChm).toString();
        File destFile = FilePathUtils.checkFile((File)new File(destPath));
        if (destFile.exists()) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destFile.getCanonicalFile());
            byte[] buf = new byte[10240];
            int n = 0;
            while ((n = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, n);
            }
        }
        catch (IOException e) {
            try {
                ToolLoggerFactory.getLogger(FileUtils.class).error("File input Field", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(out, in);
                throw throwable;
            }
            StreamUtils.closeStream(out, in);
        }
        StreamUtils.closeStream(out, in);
    }

    public static void openHelpFile(String fileName, Window parent) {
        FileUtils.openHelpFile(fileName, parent, ".html");
    }

    public static void openHelpFile(String fileName, Window parent, String type) {
        String htmlFileName = fileName + "_" + ApplicationContext.getInstance().getCurrentLanguage().getLanguage() + type;
        String workDir = ApplicationContext.getInstance().getWorkPath();
        File helpFilePath = new File(workDir, ApplicationContext.getInstance().getHelpPath());
        File helpFile = FilePathUtils.checkFile((File)new File(helpFilePath, htmlFileName));
        ToolLoggerFactory.getLogger(FileUtils.class).info("explorer help file:" + helpFile);
        if (!helpFile.exists()) {
            if (ApplicationContext.getInstance().isJunit()) {
                return;
            }
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString("toolbase.layout.errordialog.messagename"));
        } else {
            OSCmdUtils.openHelpFile(helpFile);
        }
    }

    public static boolean openHtmlFile(String urlPath) {
        return OSCmdUtils.openHtmlUrl(urlPath);
    }

    public static void createDir(String filePath) {
        com.huawei.ism.tool.base.utils.FileUtils.createDir((String)filePath);
    }

    public static void createDir(File path) {
        com.huawei.ism.tool.base.utils.FileUtils.createDir((File)path);
    }

    public static void clearDir(String dir) {
        com.huawei.ism.tool.base.utils.FileUtils.clearDir((String)dir);
    }

    public static void copyDir(String sourceDir, String targetDir) {
        com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)sourceDir, (String)targetDir);
    }

    public static void deleteAllInFolder(String path) {
        com.huawei.ism.tool.base.utils.FileUtils.deleteAllInFolder((String)path);
    }

    public static void deleteFile(File file) {
        com.huawei.ism.tool.base.utils.FileUtils.deleteFile((File)file);
    }

    public static void deleteFiles(List<File> fileList) {
        fileList.stream().filter(File::exists).forEach(FileUtils::deleteFile);
    }

    public static void deleteAllInFolder(String path, File[] excludeFiles) {
        com.huawei.ism.tool.base.utils.FileUtils.deleteAllInFolder((String)path, (File[])excludeFiles);
    }

    public static void copyDir(String sourceDir, String targetDir, File[] excludeFiles) {
        com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)sourceDir, (String)targetDir, (File[])excludeFiles);
    }

    public static String getProductSuprotPkgPath() {
        String path = System.getenv(PRODUCT_SUPORT_PKG_PATH);
        String toolCfg = UserOpDataSaveUtil.getToolIniProp((String)END_CFG_TOOL_PREFER);
        if (StringUtils.isNULLStr(path) || TRUE.equals(toolCfg)) {
            path = ApplicationContext.getInstance().getPackagesPath();
            File file = FilePathUtils.checkFile((File)new File(path, TOOLKIT));
            boolean exists = file.exists();
            if (!exists) {
                path = new File(ApplicationContext.getInstance().getWorkPath()).getParentFile().getParent() + File.separator + PACKAGES + File.separator + TOOLKIT;
                return path;
            }
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                path = ApplicationContext.getInstance().getPackagesPath() + File.separator + TOOLKIT;
            }
        }
        return path;
    }

    public static String getAddDevProductSuprotPkgPath() {
        String toolBoxPath;
        String path = ApplicationContext.getInstance().getPackagesPath();
        File file = new File(path, TOOLKIT);
        if (file.exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(FileUtils.class).info("exception occured when fetching toolkit package dir:" + e);
            }
        }
        if (new File(path = new File(toolBoxPath = ApplicationContext.getInstance().getWorkPath()).getParentFile().getParent() + File.separator + PACKAGES + File.separator + TOOLKIT).exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("exception occured when fetching package dir:" + e);
            }
        }
        return System.getenv(PRODUCT_SUPORT_PKG_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean unZip(String outPath, String unzipfile) {
        fout = null;
        dout = null;
        zin = null;
        try {
            zin = new ZipInputStream(new FileInputStream(FilePathUtils.checkFile((String)unzipfile)));
            entries = 0;
lbl7:
            // 3 sources

            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.isDirectory()) ** GOTO lbl-1000
                if (FileUtils.mkdirsFile(outPath, entry)) continue;
                var7_9 = false;
                ** GOTO lbl23
            }
            ** GOTO lbl44
        }
        catch (IOException e) {
            try {
                ToolLoggerFactory.getLogger(FileUtils.class).error("", e);
                var6_6 = false;
            }
            catch (Throwable var12_14) {
                FileUtils.closeStream(zin);
                FileUtils.closeStream(dout);
                FileUtils.closeStream(fout);
                throw var12_14;
            }
lbl23:
            // 1 sources

            FileUtils.closeStream(zin);
            FileUtils.closeStream(dout);
            FileUtils.closeStream(fout);
            return var7_9;
lbl-1000:
            // 1 sources

            {
                targetFile = new File(entry.getName());
                outDir = FilePathUtils.checkFile((File)new File(outPath + File.separator + Objects.toString(targetFile.getParent(), "")));
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                fout = new FileOutputStream(FilePathUtils.checkFile((String)(outPath + File.separator + targetFile.getPath())));
                StreamUtils.closeResource(null, dout);
                dout = new DataOutputStream(fout);
                b = new byte[1024];
                len = 0;
                total = 0;
                while ((len = zin.read(b)) != -1 && (total += len) <= 0x40000000) {
                    dout.write(b, 0, len);
                }
                FileUtils.exceedMaxNumber(++entries);
                if (total <= 0x40000000) ** GOTO lbl7
                throw new IllegalStateException("File being extracted is huge.");
lbl44:
                // 1 sources

                var7_9 = true;
            }
            FileUtils.closeStream(zin);
            FileUtils.closeStream(dout);
            FileUtils.closeStream(fout);
            return var7_9;
            FileUtils.closeStream(zin);
            FileUtils.closeStream(dout);
            FileUtils.closeStream(fout);
            return var6_6;
        }
    }

    private static boolean mkdirsFile(String outPath, ZipEntry entry) {
        File directory = FilePathUtils.checkFile((File)new File(outPath, entry.getName()));
        if (!directory.exists() && !directory.mkdirs()) {
            log.info("create failed:{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)directory.getName()));
            return false;
        }
        return true;
    }

    private static void closeStream(Object obj) {
        if (null == obj) {
            return;
        }
        try {
            if (obj instanceof ZipInputStream) {
                ((ZipInputStream)obj).closeEntry();
            } else if (obj instanceof DataOutputStream) {
                ((DataOutputStream)obj).close();
            } else if (obj instanceof FileOutputStream) {
                ((FileOutputStream)obj).close();
            }
        }
        catch (IOException e) {
            log.error("close stream error!", e);
        }
    }

    public static void close(Closeable ... cs) {
        if (cs != null) {
            for (Closeable closeable : cs) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    log.error("close stream error!", e);
                }
            }
        }
    }

    public static void replaceContentInLine(File file, String target, String replacement) {
        FileUtils.replaceContentInLine(file, target, replacement, "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void replaceContentInLine(File file, String target, String replacement, String lineSeparator) {
        String replaceStr = "";
        String line = "";
        long point = 0L;
        long lastPoint = 0L;
        boolean isInstar = false;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        RandomAccessFile fixFile = null;
        String parentPath = file.getParent();
        try {
            File replaceFile = File.createTempFile(parentPath, null);
            replaceFile.deleteOnExit();
            fos = new FileOutputStream(replaceFile);
            fixFile = new RandomAccessFile(file, RW);
            while ((line = fixFile.readLine()) != null) {
                if (isInstar) {
                    line = line + lineSeparator;
                    fos.write(line.getBytes(StandardCharsets.UTF_8));
                }
                if (line.contains(target) && !isInstar) {
                    replaceStr = line.replace(target, replacement) + lineSeparator;
                    point = lastPoint;
                    isInstar = true;
                }
                lastPoint = fixFile.getFilePointer();
            }
            fixFile.seek(point);
            fixFile.writeBytes(replaceStr);
            fis = new FileInputStream(replaceFile);
            byte[] bytes = new byte[1024];
            while (-1 != fis.read(bytes)) {
                fixFile.write(bytes);
            }
        }
        catch (FileNotFoundException e) {
            log.error("Find file has error file  not found.");
            FileUtils.close(fos, fixFile, fis);
        }
        catch (IOException e2) {
            log.error("Read file has error", e2);
            {
                catch (Throwable throwable) {
                    FileUtils.close(fos, fixFile, fis);
                    throw throwable;
                }
            }
            FileUtils.close(fos, fixFile, fis);
        }
        FileUtils.close(fos, fixFile, fis);
    }

    public static boolean isNormalPath(String path) {
        path = path.replaceAll("\\\\", "");
        path = path.replaceAll("/", "");
        path = path.replaceAll(":", "");
        if ((path = path.replaceAll("\\.", "")).contains("  ")) {
            return false;
        }
        return path.matches("[\\w ]+");
    }

    public static File getDefaultDirectory() {
        File file = FileSystemView.getFileSystemView().getDefaultDirectory();
        if (!FileUtils.isNormalPath(FilePathUtils.getCanonicalPath((File)file))) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            file = FilePathUtils.checkFile((File)new File(tmpdir));
        }
        return file;
    }

    public static void exceedMaxNumber(int entries) {
        if (entries > 10240) {
            throw new IllegalStateException("Too many files to unzip.");
        }
    }

    public static String formatIpForPath(String ip) {
        return ip.replace(":", "_");
    }
}

