/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class OSCmdUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(OSCmdUtils.class);
    private static final int WAIT_STREAM_TIMEOUT = 500;
    private static final int DEFAULT_CMD_TIMEOUT = 30;
    private static final String EXEC_CMD_BAT = "execCmd.bat";

    private OSCmdUtils() {
    }

    public static String executeCmd(String cmd) {
        return OSCmdUtils.executeCmd(cmd, 30);
    }

    public static Process createCmdProcess(String ... cmd) throws IOException {
        if (cmd.length > 1) {
            return Runtime.getRuntime().exec(cmd);
        }
        return Runtime.getRuntime().exec(cmd[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeCmd(String cmd, int timeoutSecond) {
        cmd = Normalizer.normalize(cmd, Normalizer.Form.NFKC);
        InputStream inputStream = null;
        String result = "";
        try {
            Process pro = OSCmdUtils.createCmdProcess(cmd);
            inputStream = pro.getInputStream();
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(inputStream);
            Future future = ThreadPoolManager.getInstance().submit((Callable)streamClear);
            result = (String)future.get(timeoutSecond, TimeUnit.SECONDS);
            StreamUtils.closeStream(null, inputStream);
        }
        catch (Exception e1) {
            LOGGER.error("Clear cmd output stream error :", e1);
        }
        finally {
            StreamUtils.closeStream(null, inputStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeCmdInOsPath(String cmd, int timeoutSecond) {
        cmd = Normalizer.normalize(cmd, Normalizer.Form.NFKC);
        InputStream ip = null;
        String result = "";
        String[] commands = new String[]{"cmd.exe", "/C", cmd};
        Process pro = null;
        try {
            pro = OSCmdUtils.createCmdProcess(commands);
            ip = pro.getInputStream();
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(ip);
            Future future = ThreadPoolManager.getInstance().submit((Callable)streamClear);
            result = (String)future.get(timeoutSecond, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            try {
                LOGGER.error("Clear ins error :", e1);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, ip);
                throw throwable;
            }
            StreamUtils.closeStream(null, ip);
        }
        StreamUtils.closeStream(null, ip);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeCmdInPath(String cmd, String path) {
        String out;
        File bat = new File(EXEC_CMD_BAT);
        BufferedWriter bw = null;
        OutputStreamWriter os = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(bat);
            os = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(os);
            if (path.indexOf(58) > 0) {
                bw.write(path.substring(0, 2));
                bw.newLine();
            }
            bw.write("cd " + OSCmdUtils.quote(path));
            bw.newLine();
            bw.write(cmd);
            bw.newLine();
        }
        catch (IOException e) {
            String deleted2;
            try {
                LOGGER.error("Failed to create bat for " + OSCmdUtils.quote(cmd), e);
                if (bat.exists()) {
                    boolean deleted2 = bat.delete();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Delete file result: " + deleted2);
                    }
                }
                deleted2 = "";
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, fos);
                StreamUtils.closeResource(null, os);
                StreamUtils.closeResource(bw, bw);
                throw throwable;
            }
            StreamUtils.closeResource(null, fos);
            StreamUtils.closeResource(null, os);
            StreamUtils.closeResource(bw, bw);
            return deleted2;
        }
        StreamUtils.closeResource(null, fos);
        StreamUtils.closeResource(null, os);
        StreamUtils.closeResource(bw, bw);
        try {
            out = OSCmdUtils.executeCmd("CMD /C " + OSCmdUtils.quote(bat.getCanonicalPath()));
        }
        catch (IOException e) {
            out = "";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Executed command " + OSCmdUtils.quote(cmd) + " in dir " + OSCmdUtils.quote(path));
        }
        boolean ret = bat.delete();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Result of delete file:" + ret);
        }
        return out;
    }

    private static String quote(String str) {
        return "\"" + str + "\"";
    }

    public static boolean explorerFile(File htmlFile) {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            try {
                return OSCmdUtils.exeExportFile(htmlFile.getCanonicalPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        return com.huawei.ism.tool.base.utils.OSCmdUtils.explorerFile((File)htmlFile);
    }

    public static boolean openHelpFile(File helpFile) {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            try {
                return OSCmdUtils.exeExportFile(helpFile.getCanonicalPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        File fileToOpenInLinux = com.huawei.ism.tool.base.utils.OSCmdUtils.selectFileToOpenInLinux((File)helpFile);
        return com.huawei.ism.tool.base.utils.OSCmdUtils.explorerFile((File)fileToOpenInLinux);
    }

    public static boolean openHtmlUrl(String urlPath) {
        try {
            OSCmdUtils.executeCmd("rundll32 url.dll,FileProtocolHandler " + urlPath);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("new URL error: ", e);
            return false;
        }
    }

    public static int openFile(File file) {
        if (!file.exists()) {
            LOGGER.error("file :{} not exists, open failed", (Object)file.getName());
            return 3;
        }
        if (!Desktop.isDesktopSupported()) {
            return -1;
        }
        Desktop dp = Desktop.getDesktop();
        if (!dp.isSupported(Desktop.Action.OPEN)) {
            return -2;
        }
        try {
            dp.open(file);
            return 0;
        }
        catch (IOException e) {
            LOGGER.error("cannot open file: {}", (Object)file, (Object)e);
            return 3;
        }
    }

    public static boolean explorerFile(String path) {
        return OSCmdUtils.explorerFile(new File(path));
    }

    public static synchronized boolean isPortInUsing(int port) {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            String cmd = "netstat -aon | findstr " + port;
            String res = OSCmdUtils.executeCmd(cmd);
            return res.contains(":" + port);
        }
        return false;
    }

    public static String getLocalAddress(String devIp, int port) {
        return NetUtil.getLocalIP(devIp, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exeExportFile(String path) {
        InputStream inputStream = null;
        String[] commands = new String[]{"explorer.exe", path.startsWith("\"") || path.endsWith("\"") ? path : "\"" + path + "\""};
        try {
            Process pro = OSCmdUtils.createCmdProcess(commands);
            inputStream = pro.getInputStream();
            ProcessStreamClearCall streamClear = new ProcessStreamClearCall(inputStream);
            Future future = ThreadPoolManager.getInstance().submit((Callable)streamClear);
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            boolean bl;
            try {
                LOGGER.error("Clear cmd output stream error :", e1);
                bl = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, inputStream);
                throw throwable;
            }
            StreamUtils.closeStream(null, inputStream);
            return bl;
        }
        StreamUtils.closeStream(null, inputStream);
        return true;
    }

    private static class ProcessStreamClearCall
    implements Callable<String> {
        private InputStream ins;
        private StringBuffer buff = new StringBuffer();

        public ProcessStreamClearCall(InputStream ins) {
            this.ins = ins;
        }

        @Override
        public String call() {
            try {
                byte[] bs = new byte[1024];
                int bSize = 0;
                while ((bSize = this.ins.read(bs)) != -1) {
                    this.buff.append(new String(bs, 0, bSize, Charset.defaultCharset()));
                    if (bSize == bs.length) continue;
                    Thread.sleep(500L);
                }
            }
            catch (Exception e1) {
                LOGGER.error("Read ins error :", e1);
            }
            return this.buff.toString();
        }
    }
}

