/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ToolDataAccess {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, Object> objectMap = new HashMap<String, Object>();

    public void saveObject(String uuid, Object obj) {
        if (null != obj) {
            try {
                this.lock.writeLock().lock();
                this.objectMap.put(uuid, obj);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public Object getObject(String uuid) {
        Set<String> keys = this.objectMap.keySet();
        for (String key : keys) {
            if (!uuid.equals(key)) continue;
            return this.objectMap.get(key);
        }
        ToolLoggerFactory.getLogger(ToolDataAccess.class).error("Can not find object in cache,uuid :" + uuid);
        return null;
    }

    public boolean isUuidContains(String uuid) {
        return this.objectMap.containsKey(uuid);
    }

    public void removeObject(String uuid) {
        try {
            this.lock.writeLock().lock();
            this.objectMap.remove(uuid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeAllObject() {
        try {
            this.lock.writeLock().lock();
            this.objectMap.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Map<String, Object> getAllObjects() {
        return this.objectMap;
    }
}

