/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils.in;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonMethod {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonMethod.class);
    private static final int SLEEP_60 = 60;
    private static final int SLEEP_120 = 120;
    private static final int SLEEP_300 = 300;
    private static final int END_SLEEP_300 = 300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePassword(Process pro, String password) {
        String result;
        block8: {
            OutputStream outs;
            block7: {
                result = "";
                ExecutorService es = null;
                outs = null;
                try {
                    ProcessStreamClearCall streamClear = new ProcessStreamClearCall(pro);
                    es = Executors.newCachedThreadPool();
                    Future<String> future = es.submit(streamClear);
                    result = future.get(60L, TimeUnit.SECONDS);
                    if (-1 != result.indexOf("password")) {
                        outs = pro.getOutputStream();
                        outs.write(password.getBytes(Charset.defaultCharset()));
                        outs.close();
                    }
                    future = es.submit(new ProcessStreamClearCall(pro, true));
                    result = future.get(120L, TimeUnit.SECONDS);
                    if (es == null) break block7;
                    es.shutdownNow();
                }
                catch (Exception e1) {
                    LOGGER.error("Clear ins error :", e1);
                    break block8;
                }
                finally {
                    if (es != null) {
                        es.shutdownNow();
                    }
                    StreamUtils.closeStream(outs, null);
                    CommonMethod.destroyProcess(pro);
                }
            }
            StreamUtils.closeStream((OutputStream)outs, null);
            CommonMethod.destroyProcess(pro);
        }
        return result;
    }

    private static void destroyProcess(Process process) {
        try {
            process.exitValue();
            LOGGER.info("the process is finished.");
        }
        catch (Exception e) {
            LOGGER.error("the process is not finish,destroy it! process:" + process, e);
            process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcessResult(Process pro) {
        ProcessStreamClearCall streamClear = new ProcessStreamClearCall(pro, true);
        ExecutorService es = null;
        try {
            es = Executors.newCachedThreadPool();
            Future<String> future = es.submit(streamClear);
            String string = future.get(3600L, TimeUnit.SECONDS);
            return string;
        }
        catch (Exception ee) {
            LOGGER.error("Exeception :", ee);
            String string = "";
            return string;
        }
        finally {
            if (es != null) {
                es.shutdownNow();
            }
            CommonMethod.destroyProcess(pro);
        }
    }

    public static String getCurrentDateStrLine() {
        String dateStr = StringUtils.formatDate(Calendar.getInstance(), "yyyyMMddHHmmss");
        return dateStr.trim();
    }

    public static class ProcessStreamClearCall
    implements Callable<String> {
        private Process pro = null;
        private boolean isWaitfor = false;
        private StringBuffer sb = new StringBuffer();

        public ProcessStreamClearCall(Process pro) {
            this(pro, false);
        }

        public ProcessStreamClearCall(Process process, boolean isWaitfor) {
            this.pro = process;
            this.isWaitfor = isWaitfor;
        }

        @Override
        public String call() {
            try {
                this.refleshOutput(this.pro.getInputStream());
                this.sb.append(ToolConstants.ENTER + "stdout over---------------------------------------------------" + ToolConstants.ENTER);
                this.refleshOutput(this.pro.getErrorStream());
                this.sb.append(ToolConstants.ENTER + "stderr over---------------------------------------------------" + ToolConstants.ENTER);
            }
            catch (InterruptedException e) {
                LOGGER.error("Read ins error :", e);
            }
            catch (IOException e) {
                LOGGER.error("Read ins error :", e);
            }
            if (!this.isWaitfor) {
                return this.sb.toString();
            }
            try {
                this.readResult();
            }
            finally {
                try {
                    Thread.sleep(300L);
                    this.refleshOutput(this.pro.getInputStream());
                    this.refleshOutput(this.pro.getErrorStream());
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Last time input buff!!!:" + this.sb);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Last time output error", e);
                }
            }
            return this.sb.toString();
        }

        private void readResult() {
            while (true) {
                try {
                    Thread.sleep(300L);
                    this.pro.exitValue();
                }
                catch (RuntimeException e) {
                    this.logException(e);
                    continue;
                }
                catch (InterruptedException ee) {
                    LOGGER.info("this process thread has been interrupted", ee);
                }
                catch (Exception eee) {
                    LOGGER.info("this process thread has been interrupted", eee);
                }
                break;
            }
        }

        private void logException(RuntimeException exception) {
            try {
                LOGGER.info("exception", exception);
                LOGGER.info("the process is not over");
                this.refleshOutput(this.pro.getInputStream());
                this.refleshOutput(this.pro.getErrorStream());
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("input buff!!!:" + this.sb);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("the second output error", e);
            }
            catch (IOException e) {
                LOGGER.error("the second output error", e);
            }
            catch (Exception e1) {
                LOGGER.error("the second output error", e1);
            }
        }

        private void refleshOutput(InputStream is) throws InterruptedException, IOException {
            if (is == null) {
                return;
            }
            while (true) {
                Thread.sleep(300L);
                int len = is.available();
                if (len <= 0) break;
                byte[] bs = new byte[len];
                int bSize = is.read(bs);
                this.sb.append(new String(bs, 0, bSize, Charset.defaultCharset()));
            }
        }
    }
}

