/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils.parser;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import utils.Products;

public class FeatureSupportConfig {
    private static final Logger log = LoggerFactory.getLogger(FeatureSupportConfig.class);
    private static final String NODE_SUPPORT_DEVTYPE = "devtype";
    private static final String NODE_SUPPORT_VERSION = "version";
    private static final String NODE_SUPPORT_VERSION_TYPE = "type";
    private static final String NODE_SUPPORT_VERSION_DEVVERSION = "deviceVersion";
    private static final String NODE_SUPPORT_VERSION_TGTVERSION = "targetVersion";
    private static final String NODE_SUPPORT_VERSIONITEM = "versionItem";
    private static final String SUPPORT_TYPE_WHITE = "white";
    private static final String SUPPORT_TYPE_BLACK = "black";
    private List<String> devType = new ArrayList<String>();
    private List<VersionNode> whiteItems = new ArrayList<VersionNode>();
    private List<VersionNode> blackItems = new ArrayList<VersionNode>();

    public boolean isSupport(String devType, String devVersion, String targetVersion) {
        if (!this.devType.contains(devType)) {
            return false;
        }
        boolean isInSuppport = false;
        for (VersionNode versionNode : this.whiteItems) {
            if (!versionNode.isMeet(devVersion, targetVersion)) continue;
            isInSuppport = true;
        }
        boolean isInBlack = false;
        for (VersionNode blackItem : this.blackItems) {
            if (!blackItem.isMeet(devVersion, targetVersion)) continue;
            isInBlack = true;
        }
        return isInSuppport && !isInBlack;
    }

    public List<String> getDevType() {
        return this.devType;
    }

    public void setDevType(List<String> devType) {
        this.devType = devType;
    }

    public List<VersionNode> getWhiteItems() {
        return this.whiteItems;
    }

    public void setWhiteItems(List<VersionNode> whiteItems) {
        this.whiteItems = whiteItems;
    }

    public List<VersionNode> getBlackItems() {
        return this.blackItems;
    }

    public void setBlackItems(List<VersionNode> blackItems) {
        this.blackItems = blackItems;
    }

    public VersionNode createVersionNode() {
        return new VersionNode();
    }

    public static List<FeatureSupportConfig> parse(NodeList modelList) {
        ArrayList<FeatureSupportConfig> featureSupports = new ArrayList<FeatureSupportConfig>();
        for (int j = 0; j < modelList.getLength(); ++j) {
            Node node = modelList.item(j);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            FeatureSupportConfig model = new FeatureSupportConfig();
            String devTypeStr = XmlUtils.getTextContentOfChild((Element)ele, (String)NODE_SUPPORT_DEVTYPE);
            List<String> devTypes = FeatureSupportConfig.splitByComma(devTypeStr);
            model.getDevType().addAll(devTypes);
            NodeList versionList = XmlUtils.searchNodeByExp((Element)ele, (String)NODE_SUPPORT_VERSION);
            if (versionList == null) {
                log.info("not find version node. versionList is null.");
                return featureSupports;
            }
            ArrayList<VersionNode> whiteNodes = new ArrayList<VersionNode>();
            ArrayList<VersionNode> blackNodes = new ArrayList<VersionNode>();
            for (int x = 0; x < versionList.getLength(); ++x) {
                VersionNode versionNode = model.createVersionNode();
                FeatureSupportConfig.parseVersionEle(versionList.item(x), versionNode);
                if (SUPPORT_TYPE_BLACK.equalsIgnoreCase(versionNode.getType())) {
                    blackNodes.add(versionNode);
                    continue;
                }
                whiteNodes.add(versionNode);
            }
            model.setWhiteItems(whiteNodes);
            model.setBlackItems(blackNodes);
            featureSupports.add(model);
        }
        return featureSupports;
    }

    private static void parseVersionEle(Node node, VersionNode versionNode) {
        Element versionEle = (Element)node;
        String type = versionEle.getAttribute(NODE_SUPPORT_VERSION_TYPE);
        if (StringUtils.isNULLStr((String)type)) {
            type = SUPPORT_TYPE_WHITE;
        }
        versionNode.setType(type);
        NodeList versionItemList = XmlUtils.searchNodeByExp((Element)versionEle, (String)NODE_SUPPORT_VERSIONITEM);
        if (versionItemList == null) {
            log.info("not find versionItem node. versionItemList is null.");
            return;
        }
        for (int x = 0; x < versionItemList.getLength(); ++x) {
            Node versionItemNode = versionItemList.item(x);
            if (!(versionItemNode instanceof Element)) continue;
            Element versionItemEle = (Element)versionItemNode;
            String name = versionItemEle.getAttribute("name");
            String oper = versionItemEle.getAttribute("oper");
            String value = versionItemEle.getTextContent();
            if (NODE_SUPPORT_VERSION_DEVVERSION.equalsIgnoreCase(name)) {
                versionNode.setDevVersionItem(name, value, oper);
                continue;
            }
            if (!NODE_SUPPORT_VERSION_TGTVERSION.equalsIgnoreCase(name)) continue;
            versionNode.setTargetVersionItem(name, value, oper);
        }
    }

    private static List<String> splitByComma(String str) {
        String[] strArray;
        ArrayList<String> srtList = new ArrayList<String>();
        for (String strr : strArray = str.split(",")) {
            if (StringUtils.isNULLStr((String)strr)) continue;
            srtList.add(strr.trim());
        }
        return srtList;
    }

    public class VersionItem {
        private String name = "";
        private String value = "";
        private String oper = "";

        public VersionItem(String name, String value, String oper) {
            this.name = name;
            this.value = value;
            this.oper = oper;
        }

        private boolean isMeet(String activeVal) {
            boolean met = false;
            switch (this.oper) {
                case "gt": {
                    met = Products.compareVersion(activeVal, this.value) > 0;
                    break;
                }
                case "lt": {
                    met = Products.compareVersion(activeVal, this.value) < 0;
                    break;
                }
                case "ge": {
                    met = Products.compareVersion(activeVal, this.value) >= 0;
                    break;
                }
                case "le": {
                    met = Products.compareVersion(activeVal, this.value) <= 0;
                    break;
                }
                default: {
                    met = this.value.equals(activeVal);
                }
            }
            return met;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getOper() {
            return this.oper;
        }

        public void setOper(String oper) {
            this.oper = oper;
        }
    }

    public class VersionNode {
        private String type = "";
        private VersionItem devVersionItem;
        private VersionItem targetVersionItem;

        public boolean isMeet(String devVersion, String targetVersion) {
            return this.devVersionItem.isMeet(devVersion) && this.targetVersionItem.isMeet(targetVersion);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public VersionItem getDevVersionItem() {
            return this.devVersionItem;
        }

        public void setDevVersionItem(String name, String value, String oper) {
            this.devVersionItem = new VersionItem(name, value, oper);
        }

        public VersionItem getTargetVersionItem() {
            return this.targetVersionItem;
        }

        public void setTargetVersionItem(String name, String value, String oper) {
            this.targetVersionItem = new VersionItem(name, value, oper);
        }
    }
}

