/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AuthHandler;
import io.nats.client.Connection;
import io.nats.client.Options;
import io.nats.client.impl.NatsImpl;
import java.io.IOException;

public abstract class Nats {
    public static final String CLIENT_VERSION;
    public static final String CLIENT_LANGUAGE = "java";

    public static Connection connect() throws IOException, InterruptedException {
        Options options = new Options.Builder().server("nats://localhost:4222").build();
        return Nats.createConnection(options, false);
    }

    public static Connection connect(String url) throws IOException, InterruptedException {
        Options options = new Options.Builder().server(url).build();
        return Nats.createConnection(options, false);
    }

    public static Connection connect(String url, AuthHandler handler) throws IOException, InterruptedException {
        Options options = new Options.Builder().server(url).authHandler(handler).build();
        return Nats.createConnection(options, false);
    }

    public static Connection connect(Options options) throws IOException, InterruptedException {
        return Nats.createConnection(options, false);
    }

    public static void connectAsynchronously(Options options, boolean reconnectOnConnect) throws InterruptedException {
        if (options.getConnectionListener() == null) {
            throw new IllegalArgumentException("Connection Listener required in connectAsynchronously");
        }
        Thread t = new Thread(() -> {
            try {
                NatsImpl.createConnection(options, reconnectOnConnect);
            }
            catch (Exception ex) {
                options.getErrorListener().exceptionOccurred(null, ex);
            }
        });
        t.setName("NATS - async connection");
        t.start();
    }

    public static AuthHandler credentials(String credsFile) {
        return NatsImpl.credentials(credsFile);
    }

    public static AuthHandler credentials(String jwtFile, String nkeyFile) {
        return NatsImpl.credentials(jwtFile, nkeyFile);
    }

    public static AuthHandler staticCredentials(char[] jwt, char[] nkey) {
        return NatsImpl.staticCredentials(jwt, nkey);
    }

    private static Connection createConnection(Options options, boolean reconnectOnConnect) throws IOException, InterruptedException {
        return NatsImpl.createConnection(options, reconnectOnConnect);
    }

    private Nats() {
    }

    static {
        String cv;
        try {
            cv = Nats.class.getPackage().getImplementationVersion();
        }
        catch (Exception ignore) {
            cv = null;
        }
        CLIENT_VERSION = cv == null ? "development" : cv;
    }
}

