/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack;

import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.IBizPackageExtParser;
import com.huawei.ism.tool.bizpack.parse.ConfigParser;
import com.huawei.ism.tool.bizpack.parse.PackageConfigParser;
import com.huawei.ism.tool.bizpack.parse.ProcessInfoParser;
import com.huawei.ism.tool.bizpack.parse.ProductsParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizPackageParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizPackageParser.class);
    private static final String PACKAGE_CONFIG_FILE = "package.ini";
    private static final String PACKAGE_FLOW_DIR = "flow";
    private static final String PACKAGE_PRODUCTS_FILE = "products.xml";
    private Class<? extends BizPackage> pkgClass = BizPackage.class;
    private List<ConfigParser> extParsers = new ArrayList<ConfigParser>();

    public BizPackageParser() {
    }

    public BizPackageParser(Class<? extends BizPackage> pkgClass) {
        this.pkgClass = pkgClass;
    }

    public List<BizPackage> parseBizPackages(String packagePath) {
        File parentFile = new File(packagePath);
        if (!parentFile.exists() || !parentFile.isDirectory()) {
            return new ArrayList<BizPackage>();
        }
        ArrayList<BizPackage> bizPackages = new ArrayList<BizPackage>();
        File[] files = parentFile.listFiles();
        if (files == null) {
            return new ArrayList<BizPackage>();
        }
        for (File current : files) {
            BizPackage bizPackage = this.parseBizPackage(current);
            if (bizPackage == null) continue;
            bizPackages.add(bizPackage);
        }
        return bizPackages;
    }

    public BizPackage parseBizPackage(String packagePath) {
        File bizPackageFile = new File(packagePath);
        return this.parseBizPackage(bizPackageFile);
    }

    public BizPackage parseBizPackage(File bizPackageFile) {
        BizPackage bizPackage;
        if (!bizPackageFile.exists() || !bizPackageFile.isDirectory()) {
            LOGGER.error("the file is not valid package file. file name: {}", (Object)bizPackageFile);
            return null;
        }
        List<ConfigParser> parsers = this.constructParser(bizPackageFile);
        if (parsers == null) {
            return null;
        }
        try {
            bizPackage = this.pkgClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        try {
            bizPackage.setAbsolutPath(bizPackageFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error("get the bizPackageFile CanonicalPath failed.");
            return null;
        }
        for (ConfigParser parser : parsers) {
            if (parser.parse(bizPackage)) continue;
            return null;
        }
        return bizPackage;
    }

    public void addExtParser(IBizPackageExtParser extParser) {
        this.extParsers.add(extParser);
    }

    private List<ConfigParser> constructParser(File bizPackageFile) {
        String bizPackageFilePath = null;
        try {
            bizPackageFilePath = bizPackageFile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        ArrayList<ConfigParser> parsers = new ArrayList<ConfigParser>();
        String packConfigFileName = bizPackageFilePath + File.separator + PACKAGE_CONFIG_FILE;
        File packConfigFile = new File(packConfigFileName);
        if (!packConfigFile.exists()) {
            return null;
        }
        parsers.add(new PackageConfigParser(packConfigFile));
        String productsFileName = bizPackageFilePath + File.separator + PACKAGE_PRODUCTS_FILE;
        parsers.add(new ProductsParser(new File(productsFileName)));
        String flowFolderName = bizPackageFilePath + File.separator + PACKAGE_FLOW_DIR;
        File flowDir = new File(flowFolderName);
        if (!flowDir.exists() || !flowDir.isDirectory()) {
            return null;
        }
        File[] flowFiles = flowDir.listFiles();
        if (flowFiles == null) {
            LOGGER.error("Getting Files is null");
            return parsers;
        }
        for (File flowFile : flowFiles) {
            if (!flowFile.getAbsolutePath().endsWith(".xml")) continue;
            parsers.add(new ProcessInfoParser(flowFile, bizPackageFilePath));
        }
        parsers.addAll(this.extParsers);
        return parsers;
    }
}

