/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.GridFileChooser;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class GetUserInPutDialogLayout
extends JPanel {
    private static final long serialVersionUID = -5565920588350803374L;
    private static final int BORDER_SIZE = 20;
    private static final String ICON_TYPE = ".gif";
    private static final Font SUGGEST_FONT = new Font("", 1, 14);
    private JLabel descLabel = new JLabel();
    private JButton cancel = UiMethod.createButton((String)ResourceUtil.getString("bizpack.selectdevice.cancelButton"), (char)'C');
    private JButton confirm = UiMethod.createButton((String)ResourceUtil.getString("bizpack.selectdevice.confirmButton"), (char)'O');
    private Map<String, Component> id2Component = new HashMap<String, Component>();
    private JPanel inputPanel = new JPanel();
    private JPanel errPanel = new JPanel();
    private ButtonGroup radioGroup = new ButtonGroup();
    private JLabel currentResultTxt = new JLabel();
    private JLabel currentResultSuggustion = new JLabel();
    private Dimension size = new Dimension(300, 200);

    public GetUserInPutDialogLayout(String desc, String inputJsonArray, Dimension size) {
        this.size = size;
        this.setDesc(desc);
        this.initUi();
        this.createInputPanel(inputJsonArray);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.descLabel, "descLabel");
        AutomateUtils.setNameAttribute(this.cancel, "cancelBtn");
        AutomateUtils.setNameAttribute(this.confirm, "confirmBtn");
        AutomateUtils.setNameAttribute(this.inputPanel, "inputPanel");
        AutomateUtils.setNameAttribute(this.errPanel, "errPanel");
        AutomateUtils.setNameAttribute(this.currentResultTxt, "currentResultTxt");
        AutomateUtils.setNameAttribute(this.currentResultSuggustion, "currentResultTxt");
    }

    void initUi() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.confirm);
        bottomPanel.add(Box.createHorizontalStrut(10));
        bottomPanel.add(this.cancel);
        JScrollPane jPan = new JScrollPane(this.inputPanel);
        jPan.setBorder(new EmptyBorder(1, 1, 1, 1));
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{this.descLabel}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{jPan}), Box.createVerticalStrut(12), UiMethod.buildCompsLeft((Component[])new Component[]{this.errPanel}), Box.createVerticalGlue(), new JSeparator(), bottomPanel});
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)20), "Center");
    }

    private void createInputPanel(String inputJsonArray) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridheight = 1;
        c.insets = new Insets(0, 2, 12, 12);
        this.inputPanel.setLayout(new GridBagLayout());
        JSONArray arry = new JSONArray(inputJsonArray);
        for (int i = 0; i < arry.length(); ++i) {
            JSONObject jsonObject = (JSONObject)arry.get(i);
            this.createOneLine(c, jsonObject);
        }
    }

    private void createOneLine(GridBagConstraints c, JSONObject jsonObject) {
        String id = (String)jsonObject.get("id");
        String name = (String)jsonObject.get("name");
        String type = (String)jsonObject.get("type");
        JLabel nameLabel = new JLabel(name);
        this.inputPanel.add((Component)nameLabel, c);
        Component input = null;
        input = this.getRadioComponent(c, jsonObject, id, type, input);
        this.id2Component.put(id, input);
        ++c.gridx;
        c.fill = 2;
        if (null != input) {
            if (jsonObject.has("weightx")) {
                c.weightx = 1.0;
            }
            this.inputPanel.add(input, c);
            JLabel toolTip = new JLabel();
            if (jsonObject.has("toolTip")) {
                String tipStr = (String)jsonObject.get("toolTip");
                toolTip.setToolTipText(tipStr);
                toolTip.setIcon(ResourceUtil.getImage("ic_help.png"));
            }
            c.fill = 3;
            ++c.gridx;
            c.weightx = 1.0;
            this.inputPanel.add((Component)UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{toolTip}), c);
            if (jsonObject.has("isShow")) {
                boolean isShow = "True".equals(jsonObject.getString("isShow"));
                input.setVisible(isShow);
                nameLabel.setVisible(isShow);
                toolTip.setVisible(isShow);
                this.id2Component.put(id + "_toolTip", toolTip);
                this.id2Component.put(id + "_label", nameLabel);
            }
        }
        c.gridx = 0;
        if (type.equals("label")) {
            ++c.gridy;
        }
        ++c.gridy;
        c.weightx = 0.0;
        c.gridheight = 1;
        c.fill = 0;
    }

    private Component getRadioComponent(GridBagConstraints c, JSONObject jsonObject, String id, String type, Component input) {
        JComponent result = input;
        if (type.equals("textField")) {
            String defaultStr;
            result = new JTextField(10);
            if (jsonObject.has("default") && !StringUtils.isNULLStr(defaultStr = (String)jsonObject.get("default"))) {
                ((JTextField)result).setText(defaultStr);
            }
        } else if (type.equals("pwdField")) {
            result = new JPasswordField(10);
        } else if (type.equals("label")) {
            result = this.setTextArea(c, jsonObject, id);
        } else if (type.equals("dropdown")) {
            JComboBox<String> comboBox = new JComboBox<String>();
            String ruletxt = (String)jsonObject.get("rule");
            String defaultStr = (String)jsonObject.get("default");
            this.addComBoxItems(comboBox, ruletxt);
            comboBox.setSelectedItem(defaultStr);
            result = comboBox;
        } else if (type.equals("filechooser")) {
            GridFileChooser filechooser = new GridFileChooser(jsonObject);
            result = filechooser;
        } else if (type.equals("radiobutton")) {
            JRadioButton radiobutton = new JRadioButton();
            String radioTxt = (String)jsonObject.get("desc");
            radiobutton.setText(radioTxt);
            String enableStr = (String)jsonObject.get("enable");
            if (enableStr.equalsIgnoreCase("false")) {
                radiobutton.setEnabled(false);
            } else {
                radiobutton.setEnabled(true);
            }
            String checkStr = (String)jsonObject.get("checked");
            if (checkStr.equalsIgnoreCase("true")) {
                radiobutton.setSelected(true);
            } else {
                radiobutton.setSelected(false);
            }
            this.radioGroup.add(radiobutton);
            result = radiobutton;
        }
        return result;
    }

    private Component setTextArea(GridBagConstraints c, JSONObject jsonObject, String id) {
        JTextArea area = new JTextArea();
        String labelTxt = (String)jsonObject.get("labelTxt");
        if ("productModel".equalsIgnoreCase(id)) {
            area.setLineWrap(false);
        } else {
            area.setLineWrap(true);
        }
        area.setText(labelTxt);
        area.setOpaque(false);
        area.setEditable(false);
        JTextArea input = area;
        c.gridheight = 2;
        c.fill = 1;
        return input;
    }

    public void addComBoxItems(JComboBox<String> comboBox, String jsonStr) {
        String[] items;
        for (String item : items = jsonStr.split("##")) {
            comboBox.addItem(item);
        }
    }

    public JLabel getDesc() {
        return this.descLabel;
    }

    public void setDesc(String descTxt) {
        int maxWidth = this.size.width - 40;
        this.descLabel.setText("<html>" + descTxt + "</html>");
        View view = BasicHTML.createHTMLView(this.descLabel, this.descLabel.getText());
        view.setSize(maxWidth, 2.1474836E9f);
        int hei = (int)view.getMinimumSpan(1);
        this.descLabel.setPreferredSize(new Dimension(maxWidth, hei));
    }

    public void showErrMsg(List<String> msgs) {
        this.currentResultTxt.setFont(SUGGEST_FONT);
        String resultIcon = msgs.get(0);
        this.currentResultTxt.setIcon(ResourceUtil.getImage(resultIcon + ICON_TYPE));
        this.currentResultTxt.setText(msgs.get(1));
        int maxWidth = this.size.width - 80;
        this.currentResultSuggustion.setText("<html>" + msgs.get(2) + "</html>");
        View view = BasicHTML.createHTMLView(this.currentResultSuggustion, this.currentResultSuggustion.getText());
        view.setSize(maxWidth, 2.1474836E9f);
        int hei = (int)view.getMinimumSpan(1);
        this.currentResultSuggustion.setPreferredSize(new Dimension(maxWidth, hei));
        this.errPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.errPanel.add((Component)this.currentResultTxt, c);
        c.insets = new Insets(5, 20, 0, 0);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.errPanel.add((Component)this.currentResultSuggustion, c);
        this.errPanel.setVisible(true);
    }

    public void clearErrMsg() {
        this.errPanel.removeAll();
        this.errPanel.setVisible(false);
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public void setCancel(JButton cancel) {
        this.cancel = cancel;
    }

    public JButton getConfirm() {
        return this.confirm;
    }

    public void setConfirm(JButton confirm) {
        this.confirm = confirm;
    }

    public Map<String, Component> getId2Component() {
        return this.id2Component;
    }

    public void setId2Component(Map<String, Component> id2Component) {
        this.id2Component = id2Component;
    }
}

