/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.action.WizardAction;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.WizardItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SelectWizardDialogLayout
extends JPanel {
    private static final long serialVersionUID = 5279093061820095625L;
    private static final String WELCOME_IMAGE = "welcome_left_banner.png";
    private static final int ITEM_TOP_PADDING = 36;
    private static final double WEIGHTX_2 = 2.0;
    private List<WizardItem> wizardItems = new ArrayList<WizardItem>();

    public SelectWizardDialogLayout() {
        this.initLayout();
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.insets = new Insets(13, 1, 10, 10);
        this.add((Component)this.buildLeftImagePanel(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.buildRightFuncItemPanel(), gbc);
        ++gbc.gridx;
        gbc.weightx = 2.0;
        this.add((Component)new JLabel(), gbc);
    }

    private JPanel buildLeftImagePanel() {
        JPanel leftImagePanel = new JPanel();
        URL imageUrl = ResourceUtil.getImageUrl(WELCOME_IMAGE);
        if (imageUrl != null) {
            ImageIcon image = new ImageIcon(imageUrl);
            JLabel imgLabel = new JLabel(image);
            leftImagePanel.add((Component)imgLabel, "West");
        }
        return leftImagePanel;
    }

    private JPanel buildRightFuncItemPanel() {
        JPanel rightFuncItemPanel = new JPanel();
        rightFuncItemPanel.setOpaque(false);
        rightFuncItemPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(36, 0, 12, 0);
        c.gridy = 0;
        List<BizWizardConfig> types = BizPackageContext.getInstance().getCurBizPackage().getBizWizardCfg();
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        for (BizWizardConfig type : types) {
            ++c.gridy;
            ImageIcon img = util.getImage(type.getIconPath());
            String name = util.getString(type.getTitle());
            String desc = util.getString(type.getDescription());
            WizardAction action = new WizardAction(type);
            WizardItem item = new WizardItem(img, name, desc, action);
            AutomateUtils.setNameAttribute((Component)((Object)item), type.getId() + type.getWizardTitle());
            rightFuncItemPanel.add((Component)((Object)item), c);
            this.wizardItems.add(item);
        }
        ++c.gridy;
        c.weighty = 1.0;
        rightFuncItemPanel.add((Component)new JLabel(), c);
        this.setBorder(new EmptyBorder(3, 3, 5, 0));
        return rightFuncItemPanel;
    }

    public List<WizardItem> getWizardItems() {
        return this.wizardItems;
    }
}

