/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step;

import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.ui.IFlowUIState;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink.GuideLink;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink.GuideLinkGroup;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CancelWizardWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBizStep
extends FlowWizardCard
implements IAutoProcess {
    private static final Logger log = LoggerFactory.getLogger(AbstractBizStep.class);
    protected static final String PROCESS = "process";
    protected static final String BEFORE = "before";
    protected static final String AFTER = "after";
    private JythonExecuter jythonExecuter;
    private JythonContext ssEnv;
    private String cancelScriptAbs = "";
    private boolean backwardAbs = true;
    private boolean inCancel = false;
    private int index = this.getStageIndex();
    private int allStageNum = 1;
    private String paramAbs = "";
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();

    public AbstractBizStep() {
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
        new AutoProcessObserver((IAutoProcess)this);
    }

    protected IFlowUIState getInitUIState() {
        FlowWizardState tmpState = this.getInitUiState();
        return tmpState;
    }

    protected void chgWizState(boolean isSucc) {
        final FlowWizardState state = this.getUIState(isSucc, this.backwardAbs);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractBizStep.this.changeUIState(state);
            }
        });
    }

    protected void chgWizState4FruEval(boolean isSucc) {
        final FlowWizardState state = this.getUIStateGoBackFromLastStep(isSucc);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractBizStep.this.changeUIState(state);
            }
        });
    }

    protected void setDocLinkParentWindow(BizStepConfig cfg) {
        GuideLinkGroup group = cfg.getGuideLinkGroup();
        List<GuideLink> links = group.getLinks();
        for (GuideLink guideLink : links) {
            guideLink.setParent(this.getParentWindow());
        }
    }

    protected FlowWizardState getUIState(boolean isSucc, boolean backwizardEnable) {
        FlowWizardState state = backwizardEnable ? this.getUIStateBackwizardEnable(isSucc) : this.getUIStateBackwizardDisable(isSucc);
        return state;
    }

    private FlowWizardState getUIStateBackwizardEnable(boolean isSucc) {
        FlowWizardState state = isSucc ? (this.index == 0 ? FlowWizardState.FIRST_STEP : (this.index >= this.allStageNum - 1 ? FlowWizardState.LAST_STEP_SUCCESS : FlowWizardState.MIDDLE_STEP)) : (this.index == 0 ? FlowWizardState.FIRST_STEP_RUNNING : (this.index >= this.allStageNum - 1 ? FlowWizardState.LAST_STEP_FAILED : FlowWizardState.MIDDLE_STEP_FAILED));
        return state;
    }

    private FlowWizardState getUIStateGoBackFromLastStep(boolean isSucc) {
        FlowWizardState state = this.getUIStateBackwizardEnable(isSucc);
        if (this.index >= this.allStageNum - 1) {
            state = FlowWizardState.LAST_STEP_PRE_SUC;
        }
        return state;
    }

    private FlowWizardState getInitUiState() {
        FlowWizardState state = this.index == 0 ? FlowWizardState.FIRST_STEP : (this.index >= this.allStageNum - 1 ? FlowWizardState.LAST_STEP : FlowWizardState.MIDDLE_STEP_RUNNING);
        return state;
    }

    private FlowWizardState getUIStateBackwizardDisable(boolean isSucc) {
        FlowWizardState state = isSucc ? (this.index == 0 ? FlowWizardState.FIRST_STEP : (this.index >= this.allStageNum - 1 ? FlowWizardState.LAST_STEP_SUCCESS : FlowWizardState.MIDDLE_STEP_SUCCESS)) : (this.index == 0 ? FlowWizardState.FIRST_STEP_RUNNING : (this.index >= this.allStageNum - 1 ? FlowWizardState.LAST_STEP_RUNNING : FlowWizardState.MIDDLE_STEP_RUNNING));
        return state;
    }

    protected void setRunningUiStatus() {
        FlowWizardState state = FlowWizardState.FIRST_STEP_DISABLE;
        state = this.index == 0 ? FlowWizardState.FIRST_STEP_DISABLE : (this.index >= this.allStageNum - 1 ? FlowWizardState.LAST_STEP_DISABLE : FlowWizardState.MIDDLE_STEP_DISABLE);
        FlowWizardState finalState = state;
        SwingUtilities.invokeLater(() -> {
            this.changeUIState(finalState);
            log.info("AbstractBizStep setRunningUiStatus refresh ui to running status.");
        });
    }

    protected boolean cancel() {
        this.inCancel = true;
        Window parentWindows = this.getParentWindow();
        if (parentWindows instanceof JDialog) {
            this.ssEnv.getDict().put("dialog4DB", BEFORE);
            String dangerMsg = this.getDangerMsg();
            LoggerFactory.getLogger(AbstractBizStep.class).info("dangerMsg:" + dangerMsg);
            if ("".equals(dangerMsg)) {
                WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)((JDialog)parentWindows), (String)ResourceUtil.getString("bizpackage.desc.cancel"));
                if (0 == wdialog.getValue()) {
                    if (!this.cancelScriptAbs.equals("")) {
                        this.ssEnv.getDict().put("dialog4DB", AFTER);
                        this.execCancel();
                    }
                    return true;
                }
            } else {
                WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)((JDialog)parentWindows), (String)dangerMsg);
                if (0 == wdialog.getValue()) {
                    return true;
                }
            }
        }
        this.inCancel = false;
        return false;
    }

    protected String getDangerMsg() {
        if ("".equals(this.cancelScriptAbs)) {
            return "";
        }
        List fs = AsyncExcutor.execute((Window)this.getParentWindow(), (Callable[])new Callable[]{new CancelWizardWaitDialog(this.getScriptPath(), this.cancelScriptAbs)});
        WaitDialogResult result = (WaitDialogResult)fs.get(0);
        if (!WaitDialogResult.handleResult(this.getParentWindow(), result)) {
            return "";
        }
        if (((Boolean)this.ssEnv.getDict().get("succ")).booleanValue()) {
            return "";
        }
        String dangerMsg = (String)this.ssEnv.getDict().get("dangerMsg");
        if (dangerMsg == null || "".equals(dangerMsg)) {
            return "";
        }
        return dangerMsg;
    }

    protected void execCancel() {
        if ("".equals(this.cancelScriptAbs)) {
            return;
        }
        List fs = AsyncExcutor.execute((Window)this.getParentWindow(), (Callable[])new Callable[]{new CancelWizardWaitDialog(this.getScriptPath(), this.cancelScriptAbs)});
        WaitDialogResult result = (WaitDialogResult)fs.get(0);
        if (!WaitDialogResult.handleResult(this.getParentWindow(), result)) {
            return;
        }
        if (!((Boolean)this.ssEnv.getDict().get("succ")).booleanValue()) {
            String errText = (String)this.ssEnv.getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            return;
        }
    }

    protected String getScriptPath() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append(PROCESS);
        return scriptPath.toString();
    }

    protected void setAllStageNum() {
        int tmpNum = BizPackageContext.getInstance().getCurWizardStepNum();
        this.allStageNum = tmpNum > 0 ? tmpNum : BizPackageContext.getInstance().getCurBizWizardCfg().getSteps().size();
    }

    protected void setCurStepID() {
        BizPackageContext.getInstance().setCurStepId(this.getId());
    }

    protected TaskResult getDevGraphExecResult() {
        JythonContext jssEnv = BizPackageContext.getInstance().getJythonContext();
        if (!((Boolean)jssEnv.getDict().get("succ")).booleanValue()) {
            String errText = (String)jssEnv.getDict().get("errMsg");
            TaskResult result = new TaskResult(TaskResult.Result.FAILED);
            result.setErrorLocaleDescription(errText);
            return result;
        }
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    protected void paintDevGraph(IDevgGraphInit devgGraphInit) {
        InitDevEntryThread devEntryThread = new InitDevEntryThread(devgGraphInit);
        devEntryThread.start();
    }

    public abstract void initByConfig(BizStepConfig var1);

    public JythonExecuter getJythonExecuter() {
        return this.jythonExecuter;
    }

    public void setJythonExecuter(JythonExecuter jythonExecuter) {
        this.jythonExecuter = jythonExecuter;
    }

    public JythonContext getSsEnv() {
        return this.ssEnv;
    }

    public void setSsEnv(JythonContext ssEnv) {
        this.ssEnv = ssEnv;
    }

    public String getCancelScriptAbs() {
        return this.cancelScriptAbs;
    }

    public void setCancelScriptAbs(String cancelScriptAbs) {
        this.cancelScriptAbs = cancelScriptAbs;
    }

    public boolean isInCancel() {
        return this.inCancel;
    }

    public void setInCancel(boolean inCancel) {
        this.inCancel = inCancel;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getAllStageNum() {
        return this.allStageNum;
    }

    public void setAllStageNum(int allStageNum) {
        this.allStageNum = allStageNum;
    }

    public boolean isBackwardAbs() {
        return this.backwardAbs;
    }

    public void setBackwardAbs(boolean backwardAbs) {
        this.backwardAbs = backwardAbs;
    }

    public String getParamAbs() {
        return this.paramAbs;
    }

    public void setParamAbs(String paramAbs) {
        this.paramAbs = paramAbs;
    }

    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }

    public void onStepDialogDisplayed() {
    }

    public void onStepFinished(AutoProcessStatus status) {
    }

    private class InitDevEntryThread
    extends Thread {
        private IDevgGraphInit devgGraphInit;

        public InitDevEntryThread(IDevgGraphInit devgGraphInit) {
            this.devgGraphInit = devgGraphInit;
        }

        @Override
        public void run() {
            List fs = AsyncExcutor.execute((Window)AbstractBizStep.this.getParentWindow(), (Callable[])new Callable[]{new InitDevGraphCallable(this.devgGraphInit)});
            TaskResult taskResult = (TaskResult)fs.get(0);
            if (taskResult != null && taskResult.getResult() == TaskResult.Result.FAILED) {
                DialogUtils.showErrorDialog((Window)AbstractBizStep.this.getParentWindow(), (String)taskResult.getErrorLocaleDescription());
            }
        }
    }

    private static class InitDevGraphCallable
    implements Callable<TaskResult> {
        private IDevgGraphInit devgGraphInit;

        public InitDevGraphCallable(IDevgGraphInit devgGraphInit) {
            this.devgGraphInit = devgGraphInit;
        }

        @Override
        public TaskResult call() {
            return this.devgGraphInit.initDevGraph();
        }
    }

    private static class InitDevGraphTask
    extends ServiceTask {
        private IDevgGraphInit devgGraphInit;

        public InitDevGraphTask(IDevgGraphInit devgGraphInit) {
            this.devgGraphInit = devgGraphInit;
        }

        protected TaskResult doTask() {
            return this.devgGraphInit.initDevGraph();
        }
    }
}

