/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.GridFileChooser;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.FlexConfigStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.FlexConfigStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.comp.ItemRow;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.comp.RowPan;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.DropDownItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.IInputComponent;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputButton;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.TextfieldItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexConfigStep
extends AbstractBizStep
implements IDevgGraphInit {
    private static final Logger log = LoggerFactory.getLogger(FlexConfigStep.class);
    private String flexScriptPath = "";
    private String pyName = "";
    private ExecPyScriptTask flexConfigTask;
    private FlexConfigStepCfg flexCfg;
    private boolean hasErrDialog = false;
    private FlexConfigStepLayout flexConfigLayout;
    private Map<String, IInputComponent> inputComponents = new HashMap<String, IInputComponent>();

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        if (stepConfig instanceof FlexConfigStepCfg) {
            this.flexCfg = (FlexConfigStepCfg)stepConfig;
            this.flexConfigLayout = new FlexConfigStepLayout(this.flexCfg);
            this.flexConfigLayout.setTipsTxt(resource.getString(this.flexCfg.getPrompt()));
            if (!StringUtils.isNULLStr(this.flexCfg.getPromise())) {
                this.flexConfigLayout.getCheck().setText(resource.getString(this.flexCfg.getPromise()));
                this.flexConfigLayout.getCheck().setToolTipText(resource.getString(this.flexCfg.getPromise()));
                this.setStatus();
            }
            this.flexScriptPath = this.getScriptPath();
            this.pyName = this.flexCfg.getScriptFile();
            this.initCheckListener();
            super.setParamAbs(this.flexCfg.getParam());
            super.setBackwardAbs(this.flexCfg.isBackward());
            super.setCancelScriptAbs(this.flexCfg.getCancelScript());
            this.setDocLinkParentWindow(this.flexCfg);
        }
    }

    private void initCheckListener() {
        JCheckBox check = this.flexConfigLayout.getCheck();
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexConfigStep.this.setStatus();
            }
        });
        this.flexConfigLayout.getAddBtn().addActionListener(new AddRowListener());
    }

    protected boolean init() {
        this.setCurStepID();
        this.flexCfg = (FlexConfigStepCfg)BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId());
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        super.setIndex(this.getStageIndex());
        if (!StringUtils.isNULLStr(this.flexCfg.getPromise())) {
            this.flexConfigLayout.getCheck().setSelected(false);
            this.setStatus();
        } else {
            this.chgWizState(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List fs = AsyncExcutor.execute((Window)FlexConfigStep.this.getParentWindow(), (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(FlexConfigStep.this.flexScriptPath, FlexConfigStep.this.pyName, "init", FlexConfigStep.this.getParamAbs())});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                boolean flag = result.isFlag();
                if (!flag && result.getException() instanceof SignException) {
                    DialogUtils.showErrorDialog((Window)FlexConfigStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.wizard.flexconfig.notsigned"));
                    return;
                }
                if (!flag) {
                    DialogUtils.showErrorDialog((Window)FlexConfigStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.wizard.flexconfig.scriptinitfailed"));
                    return;
                }
                FlexConfigStep.this.flexConfigTask = result.getTask();
                if (null == FlexConfigStep.this.flexConfigTask) {
                    DialogUtils.showErrorDialog((Window)FlexConfigStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.wizard.flexconfig.scriptinitfailed"));
                    return;
                }
                if (FlexConfigStep.this.flexCfg.isNeedDeviceGraph()) {
                    FlexConfigStep.this.paintDevGraph(FlexConfigStep.this);
                }
                FlexConfigStep.this.flexConfigLayout.init(FlexConfigStep.this.flexCfg);
                FlexConfigStep.this.initData();
                IStep currentStep = BizPackageContext.getInstance().getCurrentStep();
                if (currentStep != null && currentStep instanceof FlexConfigStep) {
                    ((FlexConfigStep)currentStep).notifyObserver(AutoProcessStatus.DISPLAY);
                }
            }
        });
        return true;
    }

    public void initData() {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        String retInit = (String)ssEnv.getDict().get("retData_init");
        if (retInit == null) {
            log.info("no init data return");
            return;
        }
        boolean isGraphInMiddle = "middle".equalsIgnoreCase((String)this.flexCfg.getAllAtributeMap().getOrDefault("graphLoc", ""));
        JSONArray jsonArr = new JSONArray(retInit);
        for (int i = 0; i < jsonArr.length(); ++i) {
            JSONObject oneRowObj = (JSONObject)jsonArr.get(i);
            String oneRowStr = oneRowObj.toString();
            ItemRow row = new ItemRow(oneRowStr);
            this.flexCfg.getItemRowMap().put(row.getRowKey(), row);
            if (isGraphInMiddle) {
                JComponent rowPan = this.flexConfigLayout.createOneInputRow(row);
                rowPan.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1, true));
                this.flexConfigLayout.addInputItemRow(rowPan);
            } else {
                this.flexConfigLayout.addRow(this.flexConfigLayout.createOneRow(row));
            }
            this.initListener(row);
            this.addInputComponent(row);
        }
        log.info(String.format(Locale.ROOT, "inputComponents is: %s", this.inputComponents.toString()));
        this.putData(this.flexCfg);
    }

    private void addInputComponent(ItemRow row) {
        String rowKey = row.getRowKey();
        Map<String, IInputComponent> compsMap = row.getCompsMap();
        List<InputItem> items = row.getInputItems();
        for (InputItem item : items) {
            String itemKey = item.getId();
            IInputComponent comp = compsMap.get(itemKey);
            String componentKey = String.format(Locale.ROOT, "%s#%s", rowKey, itemKey);
            this.inputComponents.put(componentKey, comp);
        }
    }

    private void addRow() {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        if (!ExecPyUtils.execInitScript(this.pyName, "", "addRow")) {
            return;
        }
        if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
            String errMsg = (String)ssEnv.getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errMsg);
            log.error("init presetting step dropDown Text err.{}", (Object)errMsg);
            return;
        }
        String rowData = (String)ssEnv.getDict().get("retData");
        if (log.isInfoEnabled()) {
            log.info("add a row data:{}", (Object)rowData);
        }
        ItemRow row = new ItemRow(rowData);
        this.flexCfg.getItemRowMap().put(row.getRowKey(), row);
        JComponent rowPan = this.flexConfigLayout.createOneRow(row);
        this.initListener(row);
        this.flexConfigLayout.addRow(rowPan);
        this.putData(this.flexCfg);
    }

    private void initListener(ItemRow row) {
        String rowKey = row.getRowKey();
        Map<String, IInputComponent> compsMap = row.getCompsMap();
        List<InputItem> items = row.getInputItems();
        for (InputItem item : items) {
            if (!item.isAct()) continue;
            IInputComponent comp = compsMap.get(item.getId());
            if (comp instanceof InputButton) {
                this.initButtonListener(rowKey, comp);
                continue;
            }
            if (comp instanceof TextfieldItem) {
                this.initTextFieldListener(row, item, comp);
                continue;
            }
            if (comp instanceof DropDownItem) {
                this.initComboBoxListener(row, item, comp);
                continue;
            }
            if (!(comp instanceof GridFileChooser)) continue;
        }
    }

    private ExecPyScriptTask initOneTaskExecPy(String scriptPath, String pyfile) {
        try {
            ExecPyScriptTask task = new ExecPyScriptTask(scriptPath, pyfile);
            return task;
        }
        catch (FileNotFoundException e) {
            log.error("py file not found.");
        }
        catch (SignException e) {
            log.error("py file not signed", (Throwable)e);
        }
        return null;
    }

    private void initComboBoxListener(final ItemRow row, final InputItem item, final IInputComponent comp) {
        DropDownItem textfieldItem = (DropDownItem)comp;
        JComboBox combox = (JComboBox)textfieldItem.getComponent();
        final String rowKey = row.getRowKey();
        combox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IStep currentStep;
                List<String> list;
                if (log.isInfoEnabled()) {
                    log.info("value changed. item id={}", (Object)item.getId());
                    log.info("valuvalue={}", (Object)StringUtils.getCleanMessage(comp.getValue()));
                }
                if (!FlexConfigStep.this.checkValueChg(FlexConfigStep.this.getItemId(rowKey, item.getId()), comp.getValue())) {
                    return;
                }
                Object object = FlexConfigStep.this.getSsEnv().getDict().get(FlexConfigStep.this.getItemId(rowKey, item.getId()));
                String preValue = (String)object;
                if (null == comp.getValue()) {
                    return;
                }
                FlexConfigStep.this.getSsEnv().getDict().put("input_changed_id", FlexConfigStep.this.getItemId(rowKey, item.getId()));
                FlexConfigStep.this.getSsEnv().getDict().put(FlexConfigStep.this.getItemId(rowKey, item.getId()), comp.getValue());
                if (log.isInfoEnabled()) {
                    log.info("click Combox[{}]", (Object)FlexConfigStep.this.getItemId(rowKey, item.getId()));
                }
                if (!FlexConfigStep.this.initDropFreshListener(row, list = item.getRefreshItems(), item.getInitSript(), item.getInitParam())) {
                    comp.setValue(preValue);
                    FlexConfigStep.this.getSsEnv().getDict().put(FlexConfigStep.this.getItemId(rowKey, item.getId()), preValue);
                }
                if ((currentStep = BizPackageContext.getInstance().getCurrentStep()) != null && currentStep instanceof FlexConfigStep) {
                    ((FlexConfigStep)currentStep).notifyObserver(AutoProcessStatus.SUCCESS);
                }
            }
        });
    }

    private boolean initDropFreshListener(ItemRow row, List<String> list, String script, String param) {
        List fs = AsyncExcutor.execute((Window)this.getParentWindow(), (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(this.flexScriptPath, script, "refreshData", param)});
        WaitDialogResult result = (WaitDialogResult)fs.get(0);
        boolean flag = result.isFlag();
        if (!flag) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.wizard.flexconfig.execPythonFailed"));
        }
        Boolean isRefresh = (Boolean)this.getSsEnv().getDict().get("isRefresh");
        if (log.isInfoEnabled()) {
            log.info("isRefresh:{}", (Object)isRefresh);
        }
        if (isRefresh == null) {
            isRefresh = true;
        }
        if (!isRefresh.booleanValue()) {
            this.getSsEnv().getDict().put("isRefresh", true);
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        for (String id : list) {
            String retId = "return_" + id;
            IInputComponent comp = row.getCompsMap().get(id);
            if (!(comp instanceof DropDownItem)) {
                log.error("refresh item is not drop down item, err type.");
                continue;
            }
            DropDownItem downItem = (DropDownItem)comp;
            JComboBox combox = (JComboBox)downItem.getComponent();
            combox.removeAllItems();
            this.refreshCombox(retId, combox);
        }
        return true;
    }

    private void refreshCombox(String retId, JComboBox combox) {
        String jsondata = (String)BizPackageContext.getInstance().getJythonContext().getDict().get(retId);
        try {
            String[] dropList;
            JSONObject jsonObject = new JSONObject(jsondata);
            String ruleData = jsonObject.getString("rule");
            String defaultData = jsonObject.getString("default");
            for (String dropData : dropList = ruleData.split(",")) {
                combox.addItem(dropData);
            }
            combox.setSelectedItem(defaultData);
        }
        catch (Exception e) {
            log.error("read dropdown data err." + jsondata, (Throwable)e);
        }
    }

    private void initTextFieldListener(final ItemRow row, final InputItem inputItem, final IInputComponent comp) {
        final List<String> refreshItems = inputItem.getRefreshItems();
        TextfieldItem textFieldItem = (TextfieldItem)comp;
        JTextField textField = (JTextField)textFieldItem.getComponent();
        final String rowKey = row.getRowKey();
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (log.isInfoEnabled()) {
                    log.info("refresh={}", (Object)inputItem.getId());
                }
                if (!FlexConfigStep.this.checkValueChg(FlexConfigStep.this.getItemId(rowKey, inputItem.getId()), comp.getValue())) {
                    return;
                }
                FlexConfigStep.this.getSsEnv().getDict().put("input_changed_id", FlexConfigStep.this.getItemId(rowKey, inputItem.getId()));
                FlexConfigStep.this.getSsEnv().getDict().put(FlexConfigStep.this.getItemId(rowKey, inputItem.getId()), comp.getValue());
                FlexConfigStep.this.refreshItem(refreshItems, row);
            }

            @Override
            public void focusGained(FocusEvent e) {
                log.info("get focus");
            }
        });
    }

    private void refreshItem(List<String> refreshItems, ItemRow row) {
        this.flexConfigTask.execFunc("refreshData", "textField");
        if (!(((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue() || this.hasErrDialog || this.isInCancel())) {
            this.hasErrDialog = true;
            String errText = (String)this.getSsEnv().getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            this.hasErrDialog = false;
            return;
        }
        if (!((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue()) {
            return;
        }
        if (((Boolean)this.getSsEnv().getDict().get("remind")).booleanValue()) {
            return;
        }
        Map<String, IInputComponent> comps = row.getCompsMap();
        String rowKey = row.getRowKey();
        for (String id : refreshItems) {
            String itemId = this.getItemId(rowKey, id);
            String text = (String)this.getSsEnv().getDict().get(itemId);
            IInputComponent lable = comps.get(id);
            lable.setValue(text);
        }
    }

    private boolean checkValueChg(String id, String curValue) {
        Object object = this.getSsEnv().getDict().get(id);
        if (null == object) {
            return true;
        }
        String preValue = (String)object;
        return !preValue.equals(curValue);
    }

    private String getItemId(String rowKey, String id) {
        StringBuilder itemId = new StringBuilder();
        itemId.append(this.getId());
        itemId.append('_');
        itemId.append(rowKey);
        itemId.append('_');
        itemId.append(id);
        return itemId.toString();
    }

    private void initButtonListener(final String rowKey, IInputComponent comp) {
        InputButton inputBtn = (InputButton)comp;
        JButton button = (JButton)inputBtn.getComponent();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarningDialog dialog = DialogUtils.showYesNoDialog((Window)FlexConfigStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.wizard.flexconfig.deleteerror"));
                if (0 != dialog.getValue()) {
                    return;
                }
                FlexConfigStep.this.flexConfigTask.execFunc("delRow", rowKey);
                FlexConfigStep.this.flexConfigLayout.removeRow(rowKey);
                FlexConfigStep.this.flexCfg.getItemRowMap().remove(rowKey);
                if (log.isInfoEnabled()) {
                    log.info("remove rowKey= {}", (Object)rowKey);
                }
            }
        });
    }

    private void setStatus() {
        if (this.flexConfigLayout.getCheck().isSelected()) {
            this.chgWizState(true);
        } else {
            this.chgWizState(false);
        }
    }

    @Override
    public TaskResult initDevGraph() {
        if (!this.flexConfigTask.execFunc("initDevGraph", this.getParamAbs())) {
            TaskResult result = new TaskResult(TaskResult.Result.FAILED);
            String errorMsg = ResourceUtil.getString("bizpack.wizard.flexconfig.execscriptfailed");
            result.setErrorLocaleDescription(errorMsg);
            return result;
        }
        return this.getDevGraphExecResult();
    }

    private void verifyFailProc() {
        String failItem = (String)this.getSsEnv().getDict().get("failItems");
        if (null != failItem && !failItem.isEmpty()) {
            String[] failList = failItem.split(",");
            Map<String, JComponent> rowMap = this.flexConfigLayout.getRealRowMap();
            for (Map.Entry<String, JComponent> entry : rowMap.entrySet()) {
                RowPan row = (RowPan)entry.getValue();
                row.rePaint();
            }
            for (String fail : failList) {
                RowPan row = (RowPan)rowMap.get(fail);
                row.setWarning();
            }
        }
        this.flexConfigTask.execFunc("verifyFailed", "");
    }

    public boolean ending() {
        log.info("ending");
        boolean saveFlag = false;
        boolean verifyDataFlag = false;
        this.putData(this.flexCfg);
        this.flexConfigTask.execFunc("verifyData", "");
        verifyDataFlag = (Boolean)this.getSsEnv().getDict().get("verifySucc");
        if (!verifyDataFlag) {
            this.verifyFailProc();
            return false;
        }
        saveFlag = this.flexCfg.isEndLoading() ? this.execSaveData() : this.flexConfigTask.execFunc("saveData", "");
        if (!saveFlag && !this.hasErrDialog) {
            this.hasErrDialog = true;
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpack.wizard.flexconfig.execscriptfailed"));
            this.hasErrDialog = false;
            return false;
        }
        if (!saveFlag && this.hasErrDialog) {
            return false;
        }
        if (!((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue() && !this.hasErrDialog) {
            this.hasErrDialog = true;
            String errText = (String)this.getSsEnv().getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            this.hasErrDialog = false;
            return false;
        }
        return (Boolean)this.getSsEnv().getDict().get("succ") != false || !this.hasErrDialog;
    }

    private void putData(FlexConfigStepCfg cfg) {
        Map<String, ItemRow> itemRowMap = cfg.getItemRowMap();
        log.info("save data starts....");
        for (Map.Entry<String, ItemRow> entry : itemRowMap.entrySet()) {
            List<InputItem> inputItems = entry.getValue().getInputItems();
            Map<String, IInputComponent> comps = entry.getValue().getCompsMap();
            for (InputItem inputItem : inputItems) {
                IInputComponent comp = comps.get(inputItem.getId());
                if (null == comp || null == comp.getValue()) continue;
                this.getSsEnv().getDict().put(this.getItemId(entry.getKey(), inputItem.getId()), comp.getValue());
            }
        }
        log.info("save data ends ....");
    }

    private boolean execSaveData() {
        ProgressDialog progressDialog = new ProgressDialog(this.getParentWindow());
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        TaskResult result = taskExecutor.execute((ServiceTask)new EndLoadingTask());
        return result != null && TaskResult.Result.SUCCESS == result.getResult();
    }

    public boolean flowExiting() {
        if (this.hasErrDialog) {
            return false;
        }
        return this.cancel();
    }

    protected FlowWizardCardLayout getLayout() {
        return this.flexConfigLayout;
    }

    @Override
    public void onStepDialogDisplayed() {
        String currentProcess = AutoProcessConfig.getInstance().getCurrentProcess();
        String inputJson = ((String)AutoProcessConfig.getInstance().getProcessInput().get(currentProcess)).trim();
        JSONObject jsonObject = new JSONObject(inputJson);
        String key = jsonObject.getString("key");
        String value = jsonObject.getString("value");
        IInputComponent inputComponent = this.inputComponents.get(key);
        inputComponent.setValue(value);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        if (BizPackageContext.getInstance().getWizard() instanceof FlowWizardDialog) {
            FlowWizardDialog wizardDialog = (FlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(Navigation.NEXT);
        }
    }

    private class EndLoadingTask
    extends ServiceTask {
        private EndLoadingTask() {
        }

        protected TaskResult doTask() {
            if (FlexConfigStep.this.flexConfigTask.execFunc("saveData", FlexConfigStep.this.getParamAbs())) {
                return new TaskResult(TaskResult.Result.SUCCESS);
            }
            return new TaskResult(TaskResult.Result.FAILED);
        }
    }

    private class AddRowListener
    implements ActionListener {
        private AddRowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlexConfigStep.this.addRow();
            log.info("create row");
        }
    }
}

