/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.MultiExecStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.MultiExecType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MultiDevExecStepCfg
extends BizStepConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiExecStepCfg.class);
    private static final String MUL_TABLE = "device-table";
    private static final String MUL_COLUMN = "column";
    private TableItem mulTable = new TableItem(this.getId());
    private MultiExecType mulmode = MultiExecType.CHECK;
    private String mulsignColId = "";
    private int multiMaxNum = 1;
    private boolean radioDialog = false;
    private boolean nextStepWarn = false;
    private boolean dispAllTask = false;

    @Override
    public void loadConfig(Element node) {
        Element multableNodeElement;
        String multiNumStr;
        String isDispAllTask;
        String nextWarn;
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        String radioDialogStr = this.getAttribute(node, "radioDialog", "");
        if (radioDialogStr.equalsIgnoreCase("true")) {
            this.setRadioDialog(true);
        }
        this.setPrompt(this.getAttribute(node, "prompt", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        String mulauto = this.getAttribute(node, "auto", "");
        if (mulauto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        if ((nextWarn = this.getAttribute(node, "nextStepWarn", "")).equalsIgnoreCase("true")) {
            this.setNextStepWarn(true);
        }
        if ((isDispAllTask = this.getAttribute(node, "dispAllTask", "")).equalsIgnoreCase("true")) {
            this.setDispAllTask(true);
        }
        String mulbackwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(mulbackwardStr);
        String mulmodeName = this.getAttribute(node, "mode", "");
        if ("exec".equalsIgnoreCase(mulmodeName.trim())) {
            this.setMode(MultiExecType.EXEC);
        }
        if (!"".equalsIgnoreCase((multiNumStr = this.getAttribute(node, "multiDeviceMaxNum", "")).trim())) {
            this.multiMaxNum = Integer.valueOf(multiNumStr);
        }
        if ((multableNodeElement = XmlUtils.getChild(node, MUL_TABLE)) == null) {
            return;
        }
        String mulitemId = this.getAttribute(multableNodeElement, "id", "");
        String mulname = this.getAttribute(multableNodeElement, "name", "");
        this.mulTable.setId(mulitemId);
        this.mulTable.setName(mulname);
        this.loadOneTableColumn(multableNodeElement, this.mulTable);
        this.parseCommon(node);
        LOGGER.info("load config complete.");
    }

    private void loadOneTableColumn(Element node, TableItem tableItem) {
        NodeList columnList = node.getElementsByTagName(MUL_COLUMN);
        if (columnList == null || columnList.getLength() == 0) {
            return;
        }
        this.loadColumnElements(tableItem, columnList);
    }

    private void loadColumnElements(TableItem tableItem, NodeList columnList) {
        int tableLength = columnList.getLength();
        List<TableColumn> columnIdList = tableItem.getColumnIdList();
        for (int index = 0; index < tableLength; ++index) {
            String visible;
            Element nodeElement = (Element)columnList.item(index);
            String id = this.getAttribute(nodeElement, "id", "");
            String name = this.getAttribute(nodeElement, "name", "");
            String signKey = this.getAttribute(nodeElement, "signKey", "");
            if ("true".equalsIgnoreCase(signKey.trim())) {
                this.mulsignColId = id;
            }
            TableColumn mulselectTableColumn = new TableColumn();
            mulselectTableColumn.setId(id);
            mulselectTableColumn.setName(name);
            String lengthStr = this.getAttribute(nodeElement, "length", "");
            if (!"".equals(lengthStr.trim())) {
                int length = Integer.valueOf(lengthStr);
                mulselectTableColumn.setLength(length);
            }
            if ((visible = this.getAttribute(nodeElement, "visible", "")).trim().equalsIgnoreCase("false")) {
                mulselectTableColumn.setVisible(false);
            }
            columnIdList.add(mulselectTableColumn);
        }
    }

    public TableItem getIoTable() {
        return this.mulTable;
    }

    public void setIoTable(TableItem ioTable) {
        this.mulTable = ioTable;
    }

    public MultiExecType getMode() {
        return this.mulmode;
    }

    public void setMode(MultiExecType mode) {
        this.mulmode = mode;
    }

    public int getMultiMaxNum() {
        return this.multiMaxNum;
    }

    public void setMultiMaxNum(int multiNum) {
        this.multiMaxNum = multiNum;
    }

    public String getSignColId() {
        return this.mulsignColId;
    }

    public void setSignColId(String signColId) {
        this.mulsignColId = signColId;
    }

    public void setRadioDialog(boolean radioDialog) {
        this.radioDialog = radioDialog;
    }

    public boolean isRadioDialog() {
        return this.radioDialog;
    }

    public void setNextStepWarn(boolean nextStepWarn) {
        this.nextStepWarn = nextStepWarn;
    }

    public boolean isNextStepWarn() {
        return this.nextStepWarn;
    }

    public void setDispAllTask(boolean dispAllTask) {
        this.dispAllTask = dispAllTask;
    }

    public boolean isDispAllTask() {
        return this.dispAllTask;
    }
}

