/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.GridFileChooser;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileOnePyWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.PreSettingStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.PreSettingStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.DropDownItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.IInputComponent;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.ItemGroup;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.ReadOnlyItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.TextfieldItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreSettingStep
extends AbstractBizStep
implements IDevgGraphInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreSettingStep.class);
    private String preScriptPath = "";
    private String pyName = "";
    private ExecPyScriptTask preSetTask;
    private PreSettingStepCfg presetCfg;
    private boolean hashErrDialog = false;
    private PreSettingStepLayout preSettingLayout;

    protected FlowWizardCardLayout getLayout() {
        return this.preSettingLayout;
    }

    protected boolean init() {
        this.setCurStepID();
        PreSettingStepCfg preCfg = (PreSettingStepCfg)BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId());
        if (preCfg.isInitLoading()) {
            ProgressDialog progressDialog = new ProgressDialog(this.getParentWindow());
            ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
            taskExecutor.execute((ServiceTask)new InitLoadingTask());
        } else {
            this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        }
        this.setAllStageNum();
        super.setIndex(this.getStageIndex());
        if (!StringUtils.isNULLStr(this.presetCfg.getPromise())) {
            this.preSettingLayout.getCheck().setSelected(false);
            this.setStatus();
        } else {
            this.chgWizState(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List fs = AsyncExcutor.execute((Window)PreSettingStep.this.getParentWindow(), (Callable[])new Callable[]{new CompileOnePyWaitDialog(PreSettingStep.this.preScriptPath, PreSettingStep.this.pyName)});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                boolean flag = result.isFlag();
                if (!flag && result.getException() instanceof SignException) {
                    DialogUtils.showErrorDialog((Window)PreSettingStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned"));
                    return;
                }
                if (!flag) {
                    DialogUtils.showErrorDialog((Window)PreSettingStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                PreSettingStep.this.preSetTask = result.getTask();
                if (null == PreSettingStep.this.preSetTask) {
                    DialogUtils.showErrorDialog((Window)PreSettingStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                if (PreSettingStep.this.presetCfg.isNeedDeviceGraph()) {
                    PreSettingStep.this.paintDevGraph(PreSettingStep.this);
                }
            }
        });
        return true;
    }

    private void initListener(PreSettingStepCfg preCfg) {
        Map<String, ItemGroup> itemsGroups = preCfg.getItemsGroup();
        Map<String, IInputComponent> comps = this.preSettingLayout.getId2Component();
        if (!StringUtils.isNULLStr(preCfg.getPromise())) {
            this.initCheckListener();
        }
        for (Map.Entry<String, ItemGroup> itemsGroup : itemsGroups.entrySet()) {
            List<InputItem> inputItems = itemsGroup.getValue().getInputItems();
            for (InputItem inputItem : inputItems) {
                IInputComponent comp = comps.get(inputItem.getId());
                if (comp instanceof TextfieldItem) {
                    this.initOneTextFieldListener(inputItem, comp);
                    continue;
                }
                if (comp instanceof DropDownItem) {
                    this.initOneComboBoxListener(inputItem, comp);
                    continue;
                }
                if (!(comp instanceof GridFileChooser)) continue;
                ((GridFileChooser)comp).initListener(this.getParentWindow());
            }
        }
    }

    private void setStatus() {
        if (this.preSettingLayout.getCheck().isSelected()) {
            this.chgWizState(true);
        } else {
            this.chgWizState(false);
        }
    }

    private void initOneComboBoxListener(final InputItem inputItem, final IInputComponent comp) {
        DropDownItem textfieldItem = (DropDownItem)comp;
        JComboBox inputField = (JComboBox)textfieldItem.getComponent();
        inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("value changed=" + inputItem.getId());
                }
                if (!PreSettingStep.this.checkValueChg(PreSettingStep.this.getItemId(inputItem.getId()), comp.getValue())) {
                    return;
                }
                PreSettingStep.this.getSsEnv().getDict().put("input_changed_id", PreSettingStep.this.getItemId(inputItem.getId()));
                PreSettingStep.this.getSsEnv().getDict().put(PreSettingStep.this.getItemId(inputItem.getId()), comp.getValue());
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("click Combox[" + PreSettingStep.this.getItemId(inputItem.getId()) + "]");
                }
                if (!(list = inputItem.getRefreshItems()).isEmpty()) {
                    PreSettingStep.this.initDropFreshListener(list);
                }
            }
        });
    }

    private void initCheckListener() {
        JCheckBox check = this.preSettingLayout.getCheck();
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreSettingStep.this.setStatus();
            }
        });
    }

    private void initDropFreshListener(List<String> list) {
        this.preSetTask.execFunc("refreshData", this.getParamAbs());
        for (String id : list) {
            String jsonStr;
            IInputComponent item;
            String retId = "retData_" + id;
            IInputComponent comp = this.preSettingLayout.getId2Component().get(id);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("refreshData id=" + id);
            }
            if (comp instanceof ReadOnlyItem) {
                try {
                    item = (ReadOnlyItem)comp;
                    jsonStr = (String)BizPackageContext.getInstance().getJythonContext().getDict().get(retId);
                    ((ReadOnlyItem)item).setValue(jsonStr);
                }
                catch (Exception e) {
                    LOGGER.error("read ReadOnlyItem Text err.", (Throwable)e);
                }
                continue;
            }
            if (comp instanceof TextfieldItem) {
                try {
                    item = (TextfieldItem)comp;
                    jsonStr = (String)BizPackageContext.getInstance().getJythonContext().getDict().get(retId);
                    ((TextfieldItem)item).setValue(jsonStr);
                }
                catch (Exception e) {
                    LOGGER.error("read TextfieldItem Text err.", (Throwable)e);
                }
                continue;
            }
            if (!(comp instanceof DropDownItem)) {
                LOGGER.error("drop-down fresh item is not the right type.");
                continue;
            }
            DropDownItem downItem = (DropDownItem)comp;
            JComboBox box = (JComboBox)downItem.getComponent();
            box.removeAllItems();
            String jsonStr2 = (String)BizPackageContext.getInstance().getJythonContext().getDict().get(retId);
            try {
                String[] dropLists;
                JSONObject jsonObj = new JSONObject(jsonStr2);
                String rule = jsonObj.getString("rule");
                String defaultSelect = jsonObj.getString("default");
                for (String dropStr : dropLists = rule.split(",")) {
                    box.addItem(dropStr);
                }
                box.setSelectedItem(defaultSelect);
            }
            catch (Exception e) {
                LOGGER.error("read dropDown Text err." + jsonStr2, (Throwable)e);
            }
        }
    }

    private void initOneTextFieldListener(final InputItem inputItem, final IInputComponent comp) {
        final List<String> refreshItems = inputItem.getRefreshItems();
        if (null == refreshItems || refreshItems.isEmpty()) {
            return;
        }
        TextfieldItem textfieldItem = (TextfieldItem)comp;
        JTextField textField = (JTextField)textfieldItem.getComponent();
        AutomateUtils.setNameAttribute(textField, inputItem.getLabel());
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("refresh=" + inputItem.getId());
                }
                if (!PreSettingStep.this.checkValueChg(PreSettingStep.this.getItemId(inputItem.getId()), comp.getValue())) {
                    return;
                }
                PreSettingStep.this.getSsEnv().getDict().put("input_changed_id", PreSettingStep.this.getItemId(inputItem.getId()));
                PreSettingStep.this.getSsEnv().getDict().put(PreSettingStep.this.getItemId(inputItem.getId()), comp.getValue());
                PreSettingStep.this.refreshItem(refreshItems);
            }

            @Override
            public void focusGained(FocusEvent e) {
                LOGGER.info("get focus");
            }
        });
    }

    private boolean checkValueChg(String id, String curValue) {
        Object object = this.getSsEnv().getDict().get(id);
        if (null == object) {
            return true;
        }
        String preValue = (String)object;
        return !preValue.equals(curValue);
    }

    private void refreshItem(List<String> refreshItems) {
        this.preSetTask.execFunc("refreshData", this.getParamAbs());
        if (!(((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue() || this.hashErrDialog || this.isInCancel())) {
            this.hashErrDialog = true;
            String errText = (String)this.getSsEnv().getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            this.hashErrDialog = false;
            return;
        }
        if (!((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue()) {
            return;
        }
        Map<String, IInputComponent> comps = this.preSettingLayout.getId2Component();
        for (String id : refreshItems) {
            String itemId = this.getItemId(id);
            String text = (String)this.getSsEnv().getDict().get(itemId);
            IInputComponent lable = comps.get(id);
            lable.setValue(text);
        }
    }

    private String getItemId(String id) {
        StringBuilder itemId = new StringBuilder();
        itemId.append("input");
        itemId.append("_");
        itemId.append(this.getId());
        itemId.append("_");
        itemId.append(id);
        return itemId.toString();
    }

    public boolean ending() {
        LOGGER.info("end=");
        boolean saveDataFlag = false;
        this.putData(this.presetCfg);
        saveDataFlag = this.presetCfg.isEndLoading() ? this.execSaveData() : this.preSetTask.execFunc("saveData", this.getParamAbs());
        if (!saveDataFlag && !this.hashErrDialog) {
            this.hashErrDialog = true;
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.execscriptfailed"));
            this.hashErrDialog = false;
            return false;
        }
        if (!saveDataFlag && this.hashErrDialog) {
            return false;
        }
        if (!((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue() && !this.hashErrDialog) {
            this.hashErrDialog = true;
            String errText = (String)this.getSsEnv().getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            this.hashErrDialog = false;
            return false;
        }
        return (Boolean)this.getSsEnv().getDict().get("succ") != false || !this.hashErrDialog;
    }

    public boolean flowExiting() {
        if (this.hashErrDialog) {
            return false;
        }
        return this.cancel();
    }

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        if (stepConfig instanceof PreSettingStepCfg) {
            PreSettingStepCfg preCfg = (PreSettingStepCfg)stepConfig;
            this.preSettingLayout = new PreSettingStepLayout(preCfg);
            this.preSettingLayout.init(preCfg);
            this.preSettingLayout.setTipsTxt(resource.getString(preCfg.getPrompt()));
            if (!StringUtils.isNULLStr(preCfg.getPromise())) {
                this.preSettingLayout.getCheck().setText(resource.getString(preCfg.getPromise()));
                this.preSettingLayout.getCheck().setToolTipText(resource.getString(preCfg.getPromise()));
                this.setStatus();
            }
            this.initListener(preCfg);
            this.preScriptPath = this.getScriptPath();
            this.getSsEnv().getDict().put("importRootDir", this.preScriptPath);
            this.pyName = preCfg.getScriptFile();
            super.setParamAbs(preCfg.getParam());
            super.setBackwardAbs(preCfg.isBackward());
            super.setCancelScriptAbs(preCfg.getCancelScript());
            this.putData(preCfg);
            this.presetCfg = preCfg;
            this.setDocLinkParentWindow(preCfg);
        }
    }

    @Override
    public TaskResult initDevGraph() {
        if (!this.preSetTask.execFunc("initDevGraph", this.getParamAbs())) {
            TaskResult result = new TaskResult(TaskResult.Result.FAILED);
            String errorMsg = ResourceUtil.getString("bizpackage.error.preset.execscriptfailed");
            result.setErrorLocaleDescription(errorMsg);
            return result;
        }
        return this.getDevGraphExecResult();
    }

    private boolean execSaveData() {
        ProgressDialog progressDialog = new ProgressDialog(this.getParentWindow());
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        TaskResult result = taskExecutor.execute((ServiceTask)new EndLoadingTask());
        return null != result && TaskResult.Result.SUCCESS == result.getResult();
    }

    private void putData(PreSettingStepCfg preCfg) {
        List<String> inputGroups = preCfg.getInputGroups();
        Map<String, ItemGroup> inputGroupMap = preCfg.getItemsGroup();
        Map<String, IInputComponent> comps = this.preSettingLayout.getId2Component();
        for (String groupKey : inputGroups) {
            List<InputItem> inputItems = inputGroupMap.get(groupKey).getInputItems();
            for (InputItem inputItem : inputItems) {
                IInputComponent comp = comps.get(inputItem.getId());
                if (null == comp || null == comp.getValue()) continue;
                this.getSsEnv().getDict().put(this.getItemId(inputItem.getId()), comp.getValue());
            }
        }
    }

    private class InitLoadingTask
    extends ServiceTask {
        private InitLoadingTask() {
        }

        protected TaskResult doTask() {
            PreSettingStep.this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(PreSettingStep.this.getId()));
            return new TaskResult(TaskResult.Result.SUCCESS);
        }
    }

    private class EndLoadingTask
    extends ServiceTask {
        private EndLoadingTask() {
        }

        protected TaskResult doTask() {
            if (PreSettingStep.this.preSetTask.execFunc("saveData", PreSettingStep.this.getParamAbs())) {
                return new TaskResult(TaskResult.Result.SUCCESS);
            }
            return new TaskResult(TaskResult.Result.FAILED);
        }
    }
}

