/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.select;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.FileChooser;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.LoadItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoBoard;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SelectForReplaceStepCfg
extends BizStepConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectForReplaceStepCfg.class);
    private static final String SELECT_TABLE = "select-table";
    private static final String LOAD_ITEM = "load-item";
    private static final String COLUMN = "column";
    private static final String INFO = "info";
    private static final String INFO_ITEM = "info-item";
    private static final String FILE_CHOOSER = "file-chooser";
    private List<TableItem> selectTableList = new ArrayList<TableItem>();
    private LoadItem loadItem = null;
    private List<Object> infoList = new ArrayList<Object>();
    private boolean showAll = false;
    private boolean showItem = true;
    private String initScript = "";

    @Override
    public void loadConfig(Element node) {
        String showitemStr;
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        this.setPromise(this.getAttribute(node, "promise", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        String auto = this.getAttribute(node, "auto", "");
        String showallStr = this.getAttribute(node, "showall", "");
        this.setInitScript(this.getAttribute(node, "initScript", ""));
        if (node.hasAttribute("showitem") && (showitemStr = this.getAttribute(node, "showitem", "")).equals("false")) {
            LOGGER.info("showItem = false...");
            this.showItem = false;
        }
        if (showallStr.equals("true")) {
            this.showAll = true;
        }
        if (auto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        String backwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(backwardStr);
        Collection<Element> elements = XmlUtils.getChildren(node);
        for (Element element : elements) {
            if (element.getTagName().equals(SELECT_TABLE)) {
                this.parseSelectTable(element);
            }
            if (element.getTagName().equals(INFO)) {
                String name = this.getAttribute(element, "name", "");
                InfoBoard refreshBoard = new InfoBoard();
                refreshBoard.setName(name);
                this.infoList.add(refreshBoard);
                this.loadOneRefreshBoard(element, refreshBoard);
            }
            if (element.getTagName().equals(FILE_CHOOSER)) {
                this.parseFileChooserBord(element);
            }
            if (!element.getTagName().equals(LOAD_ITEM)) continue;
            this.parseLoadItem(element);
        }
        this.parseCommon(node);
    }

    private void parseFileChooserBord(Element element) {
        String title = this.getAttribute(element, "title", "");
        String desc = this.getAttribute(element, "desc", "");
        String id = this.getAttribute(element, "id", "");
        String label = this.getAttribute(element, "label", "");
        String type = this.getAttribute(element, "type", "");
        String mincapacity = this.getAttribute(element, "mincapacity", "");
        FileChooser fileChooserBoard = new FileChooser();
        try {
            int capacity = Integer.parseInt(mincapacity);
            fileChooserBoard.setMincapacity(capacity);
        }
        catch (Exception e) {
            LOGGER.error("get mincapacity err", (Throwable)e);
        }
        fileChooserBoard.setTitle(title);
        fileChooserBoard.setDesc(desc);
        fileChooserBoard.setId(id);
        fileChooserBoard.setLabelDesc(label);
        if (type.trim().equalsIgnoreCase(FileChooser.FileChooserType.DIR.toString())) {
            fileChooserBoard.setType(FileChooser.FileChooserType.DIR);
        } else if (type.trim().equalsIgnoreCase(FileChooser.FileChooserType.FILE.toString())) {
            fileChooserBoard.setType(FileChooser.FileChooserType.FILE);
        } else if (type.trim().equalsIgnoreCase(FileChooser.FileChooserType.DIR_AND_FILE.toString())) {
            fileChooserBoard.setType(FileChooser.FileChooserType.DIR_AND_FILE);
        }
        this.infoList.add(fileChooserBoard);
    }

    private void parseSelectTable(Element nodeElement) {
        String itemId = this.getAttribute(nodeElement, "itemId", "");
        String refreshItems = this.getAttribute(nodeElement, "refreshItems", "");
        String name = this.getAttribute(nodeElement, "name", "");
        String needSelectStr = this.getAttribute(nodeElement, "needSelect", "");
        String needMultiCheckStr = this.getAttribute(nodeElement, "needMultiCheck", "");
        String needFreshForDevGraph = this.getAttribute(nodeElement, "freshForDevGraph", "");
        TableItem tableItem = new TableItem(this.getId());
        tableItem.setParentId(this.getId());
        if (needSelectStr.equalsIgnoreCase("false")) {
            tableItem.setNeedSelect(false);
        }
        if (needMultiCheckStr.equalsIgnoreCase("true")) {
            tableItem.setNeedMultiCheck(true);
        }
        if (needFreshForDevGraph.equalsIgnoreCase("true")) {
            tableItem.setNeedFreshForDevGraph(true);
        }
        tableItem.setId(itemId);
        tableItem.setName(name);
        if (!refreshItems.equals("")) {
            String[] refreshIds = refreshItems.split(",");
            List<String> refreshList = Arrays.asList(refreshIds);
            tableItem.setRefreshItems(refreshList);
        }
        this.loadOneTableColumn(nodeElement, tableItem);
        this.selectTableList.add(tableItem);
    }

    private void parseLoadItem(Element nodeElement) {
        String name = this.getAttribute(nodeElement, "name", "");
        String script = this.getAttribute(nodeElement, "script", "");
        String desc = this.getAttribute(nodeElement, "desc", "");
        this.loadItem = new LoadItem(name, desc, script);
    }

    private void loadOneRefreshBoard(Element node, InfoBoard refreshBoard) {
        NodeList refreshItemNodes = node.getElementsByTagName(INFO_ITEM);
        if (refreshItemNodes == null || refreshItemNodes.getLength() == 0) {
            return;
        }
        int tableLength = refreshItemNodes.getLength();
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        List<InfoItem> refreshItems = refreshBoard.getRefreshItems();
        for (int index = 0; index < tableLength; ++index) {
            Element nodeElement = (Element)refreshItemNodes.item(index);
            String itemId = this.getAttribute(nodeElement, "id", "");
            String label = this.getAttribute(nodeElement, "label", "");
            InfoItem refreshItem = new InfoItem(this);
            refreshItem.setId(itemId);
            refreshItem.setLabelText(util.getString(label));
            refreshItems.add(refreshItem);
        }
    }

    private void loadOneTableColumn(Element node, TableItem tableItem) {
        NodeList columnList = node.getElementsByTagName(COLUMN);
        if (columnList == null || columnList.getLength() == 0) {
            return;
        }
        int tableLength = columnList.getLength();
        List<TableColumn> columnIdList = tableItem.getColumnIdList();
        for (int index = 0; index < tableLength; ++index) {
            Element nodeElement = (Element)columnList.item(index);
            TableColumn selectTableColumn = new TableColumn();
            String itemId = this.getAttribute(nodeElement, "id", "");
            String name = this.getAttribute(nodeElement, "name", "");
            String visible = this.getAttribute(nodeElement, "visible", "");
            String lengthStr = this.getAttribute(nodeElement, "length", "");
            if (!"".equals(lengthStr.trim())) {
                int length = Integer.parseInt(lengthStr);
                selectTableColumn.setLength(length);
            }
            selectTableColumn.setId(itemId);
            selectTableColumn.setName(name);
            if (visible.trim().equalsIgnoreCase("false")) {
                selectTableColumn.setVisible(false);
            }
            columnIdList.add(selectTableColumn);
        }
    }

    public List<TableItem> getSelectTableList() {
        return this.selectTableList;
    }

    public void setSelectTableList(List<TableItem> selectTableList) {
        this.selectTableList = selectTableList;
    }

    public List<Object> getInfoList() {
        return this.infoList;
    }

    public void setInfoList(List<Object> infoList) {
        this.infoList = infoList;
    }

    public boolean isShowall() {
        return this.showAll;
    }

    public void setShowall(boolean showall) {
        this.showAll = showall;
    }

    public boolean isShowitem() {
        return this.showItem;
    }

    public void setShowitem(boolean showitem) {
        this.showItem = showitem;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public void setInitScript(String initScript) {
        this.initScript = initScript;
    }

    public LoadItem getLoadItem() {
        return this.loadItem;
    }

    public void setLoadItem(LoadItem loadItem) {
        this.loadItem = loadItem;
    }
}

