/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.devicegraph.service.DeviceGraphUiImpl;
import com.huawei.ism.tool.devicegraph.service.DeviceHDGraphUiImpl;
import com.huawei.ism.tool.devicegraph.util.DeviceGraphOp;
import com.huawei.ism.tool.devicegraph.util.TypeConverter;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;
import com.huawei.ism.tool.framework.pubui.common.ui.AbstractDeviceGraph;
import com.huawei.ism.tool.framework.pubui.entity.DeviceStatusEnum;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevGraphUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevGraphUtils.class);
    private static final DevGraphUtils INSTANCE = new DevGraphUtils();
    private List<IHardwareInfo> hardwareList = null;

    private DevGraphUtils() {
    }

    public static DevGraphUtils getInstance() {
        return INSTANCE;
    }

    public boolean buildGraph(Map<String, String> cfgMap, List<Map<String, String>> devMapList, boolean isBack, boolean isSupportLight) {
        ApplicationContext context = ApplicationContext.getInstance();
        String graphConfigPath = cfgMap.get("graphConfigPath");
        String deviceImgCfgPath = cfgMap.get("deviceImgCfgPath");
        boolean isHdGraph = Boolean.valueOf(cfgMap.getOrDefault("isHdGraph", "false"));
        if (StringUtils.isNULLStr(graphConfigPath) || StringUtils.isNULLStr(deviceImgCfgPath)) {
            LOGGER.error("device image config path or graph config Path is null.");
            return false;
        }
        if (isHdGraph) {
            String hdGraphConfigPath = cfgMap.getOrDefault("hdGraphConfigPath", "");
            String string = cfgMap.getOrDefault("hdDeviceImgCfgPath", "");
            context.setHDGraph(isHdGraph);
            context.setHDDeviceGraphCfgPath(hdGraphConfigPath);
            context.setHDDeviceImgCfgPath(string);
        }
        context.setDeviceGraphCfgPath(graphConfigPath);
        context.setDeviceImgCfgPath(deviceImgCfgPath);
        this.hardwareList = new ArrayList<IHardwareInfo>();
        for (Map map : devMapList) {
            this.hardwareList.add(TypeConverter.buildHardware((Map)map));
        }
        Object uiImpl = null;
        uiImpl = isHdGraph ? new DeviceHDGraphUiImpl() : new DeviceGraphUiImpl();
        AbstractBizStepLayout abstractBizStepLayout = this.getCurStepLayout();
        if (null == abstractBizStepLayout) {
            LOGGER.error("cur step layout is null. step id:" + BizPackageContext.getInstance().getCurStepId());
            return false;
        }
        JScrollPane devGraphPane = abstractBizStepLayout.getDevGraphPane();
        if (null == devGraphPane) {
            LOGGER.error("cur step devGraphPane is null. step id:" + BizPackageContext.getInstance().getCurStepId());
            return false;
        }
        AbstractDeviceGraph deviceGraph = uiImpl.buildDeviceGraph("", this.hardwareList, isBack, isSupportLight);
        abstractBizStepLayout.setDevGraph(deviceGraph);
        devGraphPane.setViewportView(deviceGraph);
        return true;
    }

    public boolean highlightCable(Map<String, String> fromPortMap, Map<String, String> toPortMap, String status) {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        if (null == deviceGraph) {
            return false;
        }
        IHardwareInfo fromPort = TypeConverter.buildHardware(fromPortMap);
        IHardwareInfo toPort = TypeConverter.buildHardware(toPortMap);
        IHardwareInfo fromParent = this.getParentInfo(fromPort);
        deviceGraph.addHardware(fromPort.getTypeName(), fromPort);
        if (fromParent != null) {
            deviceGraph.addHardware(fromParent.getTypeName(), fromParent);
        }
        IHardwareInfo toParent = this.getParentInfo(toPort);
        deviceGraph.addHardware(toPort.getTypeName(), toPort);
        if (toParent != null) {
            deviceGraph.addHardware(toParent.getTypeName(), toParent);
        }
        deviceGraph.highlightCable((IPortInfo)fromPort, (IPortInfo)toPort, DeviceStatusEnum.valueOf(status));
        return true;
    }

    public boolean highlightModule(Map<String, String> moduleMap, String status) {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        if (null == deviceGraph) {
            return false;
        }
        LoggerFactory.getLogger(DeviceGraphOp.class).info("[HL]" + moduleMap);
        IHardwareInfo module = TypeConverter.buildHardware(moduleMap);
        ArrayList<IHardwareInfo> moduleList = new ArrayList<IHardwareInfo>();
        moduleList.add(module);
        if (module.getTypeName().contains("PORT")) {
            List<Rectangle> recList;
            IHardwareInfo parentPort = this.getParentInfo(module);
            deviceGraph.addHardware(module.getTypeName(), module);
            if (parentPort != null) {
                deviceGraph.addHardware(parentPort.getTypeName(), parentPort);
            }
            if (null != (recList = deviceGraph.getModulesLocation(moduleList))) {
                for (Rectangle rec : recList) {
                    deviceGraph.highLightModule(rec, DeviceStatusEnum.valueOf(status));
                }
            }
        } else {
            deviceGraph.highlightModules(moduleList, DeviceStatusEnum.valueOf(status));
        }
        return true;
    }

    public boolean highlightEnclosureModule(Map<String, String> encMap, Map<String, String> intfMap, String status) {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        if (null == deviceGraph) {
            return false;
        }
        LoggerFactory.getLogger(DeviceGraphOp.class).info("[HL]" + encMap);
        LoggerFactory.getLogger(DeviceGraphOp.class).info("[HL]" + intfMap);
        IHardwareInfo encInfo = TypeConverter.buildHardware(encMap);
        IHardwareInfo intfInfo = TypeConverter.buildHardware(intfMap);
        ArrayList<IHardwareInfo> moduleList = new ArrayList<IHardwareInfo>();
        moduleList.add(encInfo);
        moduleList.add(intfInfo);
        deviceGraph.highlightModules(moduleList, DeviceStatusEnum.valueOf(status));
        return true;
    }

    public boolean highlightEnclosureModules(Map<String, String> encMap, List<Map<String, String>> intfs, String status) {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        if (null == deviceGraph) {
            return false;
        }
        LoggerFactory.getLogger(DeviceGraphOp.class).info("[HL]" + intfs);
        ArrayList<IHardwareInfo> intfInfos = new ArrayList<IHardwareInfo>();
        intfInfos.add(TypeConverter.buildHardware(encMap));
        for (Map<String, String> interf : intfs) {
            intfInfos.add(TypeConverter.buildHardware(interf));
        }
        deviceGraph.highlightModules(intfInfos, DeviceStatusEnum.valueOf(status));
        return true;
    }

    public boolean highlightModuleList(List<Map<String, String>> moduleMapList, String status) {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        if (null == deviceGraph) {
            return false;
        }
        for (Map<String, String> moduleMap : moduleMapList) {
            this.highlightModule(moduleMap, status);
        }
        return true;
    }

    public void highLightModule(Rectangle rectangle, int status) {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        DeviceStatusEnum statusEnum = DeviceStatusEnum.defaults;
        switch (status) {
            case 0: {
                statusEnum = DeviceStatusEnum.defaults;
                break;
            }
            case 1: {
                statusEnum = DeviceStatusEnum.normal;
                break;
            }
            case 2: {
                statusEnum = DeviceStatusEnum.abnormal;
                break;
            }
            case 3: {
                statusEnum = DeviceStatusEnum.selected;
                break;
            }
            case 4: {
                statusEnum = DeviceStatusEnum.lighting;
                break;
            }
        }
        if (deviceGraph != null) {
            deviceGraph.highLightModule(rectangle, statusEnum);
        }
    }

    public List<Rectangle> getModulesLocation(List<Map<String, String>> moduleMapList) {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        ArrayList<IHardwareInfo> moduleInfoList = new ArrayList<IHardwareInfo>();
        for (Map<String, String> devMap : moduleMapList) {
            moduleInfoList.add(TypeConverter.buildHardware(devMap));
        }
        if (deviceGraph != null) {
            return deviceGraph.getModulesLocation(moduleInfoList);
        }
        return null;
    }

    public boolean clearGraph() {
        AbstractDeviceGraph deviceGraph = this.getDeviceGraph();
        if (null == deviceGraph) {
            return false;
        }
        deviceGraph.clearDeviceGraph();
        return true;
    }

    private AbstractBizStepLayout getCurStepLayout() {
        String curStepKey = BizPackageContext.getInstance().getCurStepId();
        if (StringUtils.isNULLStr(curStepKey)) {
            return null;
        }
        return BizPackageContext.getInstance().getId2LayoutMap().get(curStepKey);
    }

    private AbstractDeviceGraph getDeviceGraph() {
        AbstractBizStepLayout layout = this.getCurStepLayout();
        if (null == layout) {
            LOGGER.error("cur step layout is null. step id:" + BizPackageContext.getInstance().getCurStepId());
            return null;
        }
        AbstractDeviceGraph deviceGraph = layout.getDevGraph();
        if (null == deviceGraph) {
            LOGGER.error("cur step deviceGraph is null. step id:" + BizPackageContext.getInstance().getCurStepId());
            return null;
        }
        return deviceGraph;
    }

    private IHardwareInfo getParentInfo(IHardwareInfo subInfo) {
        for (IHardwareInfo hardInfo : this.hardwareList) {
            if (!subInfo.getParentID().equals(hardInfo.getID())) continue;
            return hardInfo;
        }
        return null;
    }
}

