/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.parameterization.support;

import com.huawei.fitframework.core.common.parameterization.ParameterizedString;
import com.huawei.fitframework.core.common.parameterization.ResolvedParameter;
import com.huawei.fitframework.core.common.parameterization.StringFormatException;
import com.huawei.fitframework.core.common.parameterization.support.DefaultParameterizedStringResolver;
import com.huawei.fitframework.core.common.parameterization.support.DefaultResolvedParameter;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class DefaultParameterizedString
implements ParameterizedString {
    private final DefaultParameterizedStringResolver resolver;
    private final String originalString;
    private String escapedString;
    private final List<DefaultResolvedParameter> parameters;

    private DefaultParameterizedString(DefaultParameterizedStringResolver resolver, String originalString) {
        this.resolver = resolver;
        this.originalString = originalString;
        this.parameters = new ArrayList<DefaultResolvedParameter>();
    }

    @Override
    public DefaultParameterizedStringResolver getResolver() {
        return this.resolver;
    }

    @Override
    public String getOriginalString() {
        return this.originalString;
    }

    @Override
    public List<ResolvedParameter> getParameters() {
        return this.parameters.stream().map(ObjectUtils::cast).collect(Collectors.toList());
    }

    @Override
    public String format(Map<?, ?> args) {
        Map actualArgs = ObjectUtils.nullIf(args, Collections.EMPTY_MAP);
        long count = this.getParameters().stream().map(ResolvedParameter::getName).distinct().count();
        if ((long)MapUtils.count(actualArgs) != count) {
            throw new StringFormatException("The provided args is not match the required args.");
        }
        if (CollectionUtils.isEmpty(this.getParameters())) {
            return this.escapedString;
        }
        List sortedParameters = this.parameters.stream().sorted(Comparator.comparingInt(ResolvedParameter::getPosition)).collect(Collectors.toList());
        int index = 0;
        int affixLength = this.measureAffix();
        StringBuilder builder = new StringBuilder(this.escapedString.length() << 1);
        for (DefaultResolvedParameter parameter : sortedParameters) {
            builder.append(this.escapedString, index, parameter.getEscapedPosition());
            builder.append(StringUtils.normalize(DefaultParameterizedString.getParameterValue(actualArgs, parameter.getName())));
            index = parameter.getEscapedPosition() + affixLength + DefaultParameterizedString.measure(parameter.getName());
        }
        builder.append(this.escapedString.substring(index));
        return builder.toString();
    }

    private static String getParameterValue(Map<?, ?> args, String name) {
        if (!args.containsKey(name)) {
            throw new StringFormatException(StringUtils.format("Parameter '{0}' required but not supplied.", name));
        }
        return ObjectUtils.toString(args.get(name));
    }

    private int measureAffix() {
        return DefaultParameterizedString.measure(this.getResolver().getParameterPrefix()) + DefaultParameterizedString.measure(this.getResolver().getParameterSuffix());
    }

    private static int measure(String string) {
        return string.length();
    }

    public String toString() {
        return StringUtils.format("[originalString={0}, variables={1}]", this.getOriginalString(), this.getParameters());
    }

    static DefaultParameterizedString resolve(DefaultParameterizedStringResolver resolver, String originalString) {
        DefaultParameterizedString parameterizedString = new DefaultParameterizedString(resolver, originalString);
        parameterizedString.new Resolver().resolve();
        return parameterizedString;
    }

    private static boolean matchString(String str, int start, String placeholder) {
        if (str.length() - placeholder.length() < start) {
            return false;
        }
        int i = start;
        for (int j = 0; j < placeholder.length(); ++j) {
            if (str.charAt(i) != placeholder.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class Resolver {
        private final StringBuilder escaped = new StringBuilder(this.getOriginalString().length());
        private int position;
        private StringBuilder parameter;
        private int parameterEscapedCharacters;

        Resolver() {
        }

        void resolve() {
            while (this.position < this.getOriginalString().length()) {
                if (this.isEscapeCharacter()) {
                    this.resolveEscapeCharacter();
                    continue;
                }
                if (this.isPrefix()) {
                    this.resolvePrefix();
                    continue;
                }
                if (this.isSuffix()) {
                    this.resolveSuffix();
                    continue;
                }
                this.resolveCharacter();
            }
            if (this.parameter != null) {
                throw new StringFormatException(StringUtils.format("Incomplete parameter. [string={0}, position={1}]", this.getOriginalString(), this.position - this.parameter.length() - this.getResolver().getParameterPrefix().length()));
            }
            DefaultParameterizedString.this.escapedString = this.escaped.toString();
        }

        private String getOriginalString() {
            return DefaultParameterizedString.this.getOriginalString();
        }

        private DefaultParameterizedStringResolver getResolver() {
            return DefaultParameterizedString.this.getResolver();
        }

        private boolean isEscapeCharacter() {
            return this.getOriginalString().charAt(this.position) == this.getResolver().getEscapeCharacter();
        }

        private void resolveEscapeCharacter() {
            if (this.position < this.getOriginalString().length() - 1) {
                ++this.position;
                if (this.parameter != null) {
                    ++this.parameterEscapedCharacters;
                }
            } else {
                throw new StringFormatException(StringUtils.format("Invalid escape character position. [string={0}, position={1}]", this.getOriginalString(), this.position));
            }
            this.resolveCharacter();
        }

        private boolean isPrefix() {
            return DefaultParameterizedString.matchString(this.getOriginalString(), this.position, this.getResolver().getParameterPrefix());
        }

        private void resolvePrefix() {
            if (this.parameter != null) {
                throw new StringFormatException(StringUtils.format("Invalid prefix position. [string={0}, position={1}]", this.getOriginalString(), this.position));
            }
            this.parameter = new StringBuilder();
            this.position += this.getResolver().getParameterPrefix().length();
        }

        private boolean isSuffix() {
            return DefaultParameterizedString.matchString(this.getOriginalString(), this.position, this.getResolver().getParameterSuffix());
        }

        private void resolveSuffix() {
            if (this.parameter == null) {
                throw new StringFormatException(StringUtils.format("Invalid suffix position. [string={0}, position={1}]", this.getOriginalString(), this.position));
            }
            String parameterName = this.parameter.toString();
            this.parameter = null;
            DefaultResolvedParameter resolvedParameter = new DefaultResolvedParameter(this.getParameterPosition(parameterName), parameterName, this.escaped.length());
            this.escaped.append(this.getResolver().getParameterPrefix()).append(parameterName).append(this.getResolver().getParameterSuffix());
            DefaultParameterizedString.this.parameters.add(resolvedParameter);
            this.position += this.getResolver().getParameterSuffix().length();
        }

        private void resolveCharacter() {
            ObjectUtils.nullIf(this.parameter, this.escaped).append(this.getOriginalString().charAt(this.position));
            ++this.position;
        }

        private int getParameterPosition(String parameterName) {
            int actualPosition = this.position;
            actualPosition -= parameterName.length();
            actualPosition -= this.getResolver().getParameterPrefix().length();
            this.parameterEscapedCharacters = 0;
            return actualPosition -= this.parameterEscapedCharacters;
        }
    }
}

