/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.Unzip;
import com.huawei.fitframework.core.common.util.support.Zip;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FileUtils {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String JAR_FILE_EXTENSION = ".jar";

    private FileUtils() {
    }

    public static File canonicalize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format("Fail to canonicalize file. [file={0}]", file.getPath()), e);
        }
    }

    public static File canonicalize(String fileName) {
        if (fileName == null) {
            return null;
        }
        return FileUtils.canonicalize(new File(fileName));
    }

    public static File child(File parent, String ... paths) {
        if (paths == null) {
            return parent;
        }
        File child = parent;
        for (String path : paths) {
            if (path == null) continue;
            child = new File(child, path);
        }
        return child;
    }

    public static void delete(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File subFile : files = ObjectUtils.nullIf(file.listFiles(), new File[0])) {
                FileUtils.delete(subFile);
            }
        }
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format("Fail to delete file. [file={0}]", file.getPath()), e);
        }
    }

    public static void delete(String path) {
        FileUtils.delete(new File(path));
    }

    public static int depth(File file) {
        File canonical = FileUtils.canonicalize(file);
        int depth = 0;
        while (canonical != null) {
            canonical = canonical.getParentFile();
            ++depth;
        }
        return depth;
    }

    public static void ensureDirectory(File directory) throws IOException {
        Validation.notNull(directory, "The directory to ensure cannot be null.", new Object[0]);
        Stack<File> stack = new Stack<File>();
        for (File canonical = FileUtils.canonicalize(directory); canonical != null && !canonical.exists(); canonical = canonical.getParentFile()) {
            stack.push(canonical);
        }
        while (!stack.isEmpty()) {
            File directoryNotExists = (File)stack.pop();
            Files.createDirectory(directoryNotExists.toPath(), new FileAttribute[0]);
        }
        if (!directory.isDirectory()) {
            throw new IllegalStateException(StringUtils.format("The directory to ensure is a file. [file={0}]", directory.getPath()));
        }
    }

    public static File file(URL url) {
        URI uri;
        if (url == null) {
            return null;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(StringUtils.format("To uri failed. [url={0}]", url), e);
        }
        return FileUtils.canonicalize(new File(uri));
    }

    public static boolean isAbsolute(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.isAbsolute();
    }

    public static boolean isJar(File file) {
        return file.getName().endsWith(JAR_FILE_EXTENSION);
    }

    public static List<File> list(File file) {
        if (file == null || !file.isDirectory()) {
            return Collections.emptyList();
        }
        File[] subFiles = ObjectUtils.nullIf(file.listFiles(), new File[0]);
        return Stream.of(subFiles).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String path(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.canonicalize(file).getPath();
    }

    public static Stream<File> traverse(File file) {
        if (file == null) {
            return Stream.empty();
        }
        File canonical = FileUtils.canonicalize(file);
        Stream<File> stream = Stream.of(canonical);
        if (canonical.isDirectory()) {
            stream = Stream.concat(stream, FileUtils.traverse(canonical.listFiles()));
        }
        return stream;
    }

    private static Stream<File> traverse(File[] files) {
        if (ArrayUtils.isEmpty(files)) {
            return Stream.empty();
        }
        return Arrays.stream(files).flatMap(FileUtils::traverse);
    }

    public static Unzip unzip(File zipFile) {
        return FileUtils.unzip(zipFile, null);
    }

    public static Unzip unzip(File zipFile, Charset charset) {
        return new Unzip(zipFile, charset);
    }

    public static Zip zip(File zipFile) {
        return FileUtils.zip(zipFile, null);
    }

    public static Zip zip(File zipFile, Charset charset) {
        return new Zip(zipFile, charset);
    }
}

