/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.Validation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    public static <T> void accept(Consumer<T> consumer, T value) {
        if (consumer != null) {
            consumer.accept(value);
        }
    }

    public static <T, R> BiPredicate<T, R> and(BiPredicate<T, R> first, BiPredicate<T, R> second) {
        return FunctionUtils.connect(first, second, BiPredicate::and);
    }

    public static <T, R> BiPredicate<T, R> and(BiPredicate<T, R>[] predicates, boolean defaultValue) {
        if (predicates == null) {
            return (item1, item2) -> defaultValue;
        }
        BiPredicate<Object, Object> composite = null;
        for (BiPredicate<T, R> predicate : predicates) {
            composite = FunctionUtils.and(composite, predicate);
        }
        return composite == null ? (item1, item2) -> defaultValue : composite;
    }

    public static <T> Predicate<T> and(Predicate<T> first, Predicate<T> second) {
        return FunctionUtils.connect(first, second, Predicate::and);
    }

    public static <T> Predicate<T> and(Predicate<T>[] predicates, boolean defaultValue) {
        if (predicates == null) {
            return item -> defaultValue;
        }
        Predicate<Object> composite = null;
        for (Predicate<T> predicate : predicates) {
            composite = FunctionUtils.and(composite, predicate);
        }
        return composite == null ? item -> defaultValue : composite;
    }

    public static <T> Consumer<T> connect(Consumer<T> first, Consumer<T> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.andThen(second);
    }

    @SafeVarargs
    public static <T> Function<T, T> connect(Function<T, T> ... functions) {
        if (functions == null) {
            return null;
        }
        List actualFunctions = Arrays.stream(functions).filter(Objects::nonNull).collect(Collectors.toList());
        if (actualFunctions.isEmpty()) {
            return null;
        }
        Function function = (Function)actualFunctions.get(0);
        for (int i = 1; i < actualFunctions.size(); ++i) {
            function = function.andThen((Function)actualFunctions.get(i));
        }
        return function;
    }

    public static <T, U, V> Function<T, V> connect(Function<T, U> first, Function<U, V> second) {
        return Validation.notNull(first, "The first function to connect cannot be null.", new Object[0]).andThen(Validation.notNull(second, "The second function to connect cannot be null.", new Object[0]));
    }

    public static <T> Predicate<T> or(Predicate<T> first, Predicate<T> second) {
        return FunctionUtils.connect(first, second, Predicate::or);
    }

    private static <T> Predicate<T> connect(Predicate<T> first, Predicate<T> second, BiFunction<Predicate<T>, Predicate<T>, Predicate<T>> connector) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return connector.apply(first, second);
    }

    private static <T, R> BiPredicate<T, R> connect(BiPredicate<T, R> first, BiPredicate<T, R> second, BiFunction<BiPredicate<T, R>, BiPredicate<T, R>, BiPredicate<T, R>> connector) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return connector.apply(first, second);
    }

    public static <T> boolean test(Predicate<T> predicate, T value, boolean defaultValue) {
        if (predicate == null) {
            return defaultValue;
        }
        return predicate.test(value);
    }
}

