/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.exception.ClassAccessException;
import com.huawei.fitframework.core.common.exception.FieldVisitException;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.exception.MethodNotFoundException;
import com.huawei.fitframework.core.common.exception.ObjectInstantiationException;
import com.huawei.fitframework.core.common.util.MapBuilder;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Map;

public final class ReflectionUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS = MapBuilder.get().put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).put(Character.TYPE, Character.class).put(Boolean.TYPE, Boolean.class).build();

    private ReflectionUtils() {
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClassAccessException(e);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Validation.notNull(clazz, "The class to detect constructor cannot be null.", new Object[0]);
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(e);
        }
    }

    public static <T> Constructor<T>[] getDeclaredConstructors(Class<T> clazz) {
        Validation.notNull(clazz, "The class to detect constructors cannot be null.", new Object[0]);
        return clazz.getDeclaredConstructors();
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        Validation.notNull(clazz, "The class to detect fields cannot be null.", new Object[0]);
        return clazz.getDeclaredFields();
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterClasses) {
        Validation.notNull(clazz, "The class to detect method cannot be null.", new Object[0]);
        Validation.notNull(methodName, "The method name cannot be null.", new Object[0]);
        try {
            return clazz.getDeclaredMethod(methodName, parameterClasses);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(e);
        }
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        Validation.notNull(clazz, "The class to detect methods cannot be null.", new Object[0]);
        return clazz.getDeclaredMethods();
    }

    public static Object getField(Object owner, Field field) {
        Validation.notNull(field, "The field to get value cannot be null.", new Object[0]);
        if (owner == null && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(StringUtils.format("The specified owner is null and the field is an instance field. [field={0}]", field.getName()));
        }
        try {
            field.setAccessible(true);
            return field.get(owner);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new FieldVisitException(e);
        }
    }

    public static Object getField(Object owner, String fieldName) {
        Validation.notBlank(fieldName, "The name of field to get value cannot be blank.", new Object[0]);
        try {
            Field field = ReflectionUtils.getClass(owner).getDeclaredField(fieldName);
            return ReflectionUtils.getField(owner, field);
        }
        catch (NoSuchFieldException e) {
            throw new FieldVisitException(e);
        }
    }

    public static <T extends Executable> Parameter[] getParameters(T method) {
        Validation.notNull(method, "The method to get parameters cannot be null.", new Object[0]);
        return method.getParameters();
    }

    public static Object getProperty(Object owner, String name) {
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(name, ReflectionUtils.getClass(owner));
            Method getter = descriptor.getReadMethod();
            return ReflectionUtils.invoke(owner, getter, new Object[0]);
        }
        catch (MethodInvocationException | IntrospectionException e) {
            return ReflectionUtils.getField(owner, name);
        }
    }

    public static Class<?> ignorePrimitiveClass(Class<?> source) {
        Validation.notNull(source, "Source class cannot be null.", new Object[0]);
        return ObjectUtils.nullIf(PRIMITIVE_WRAPPERS.get(source), source);
    }

    public static <T> T instantiate(Class<T> clazz) {
        Validation.notNull(clazz, "The class to instantiate new object cannot be null.", new Object[0]);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return ReflectionUtils.instantiate(constructor, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectInstantiationException(e);
        }
    }

    public static <T> T instantiate(Constructor<T> constructor, Object ... parameters) {
        Validation.notNull(constructor, "The constructor to instantiate new object cannot be null.", new Object[0]);
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new ObjectInstantiationException(e);
        }
    }

    public static Object invoke(Object owner, Method method, Object ... parameters) {
        Validation.notNull(method, "The method to invoke cannot be null.", new Object[0]);
        if (owner == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(StringUtils.format("The specified owner is null and the method is an instance method. [method={0}]", method.getName()));
        }
        try {
            return method.invoke(owner, parameters);
        }
        catch (InvocationTargetException e) {
            throw new MethodInvocationException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MethodInvocationException(e);
        }
    }

    public static <T> T invokeWithReturnType(Object owner, Method method, Class<T> returnType, Object ... parameters) {
        Object result = ReflectionUtils.invoke(owner, method, parameters);
        if (result == null) {
            return null;
        }
        if (!result.getClass().isAssignableFrom(returnType)) {
            throw new MethodInvocationException(StringUtils.format("Return type is mismatch. [returnType={0}, actualType={1}]", returnType.getName(), result.getClass().getName()));
        }
        return returnType.cast(result);
    }

    public static void setField(Object owner, Field field, Object value) {
        Validation.notNull(field, "The field to set value cannot be null.", new Object[0]);
        if (owner == null && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(StringUtils.format("The specified owner is null and the field is an instance field. [field={0}]", field.getName()));
        }
        try {
            field.setAccessible(true);
            field.set(owner, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new FieldVisitException(e);
        }
    }

    public static void setField(Object owner, String fieldName, Object value) {
        Validation.notBlank(fieldName, "The name of field to set value cannot be blank.", new Object[0]);
        try {
            Field field = ReflectionUtils.getClass(owner).getDeclaredField(fieldName);
            ReflectionUtils.setField(owner, field, value);
        }
        catch (NoSuchFieldException e) {
            throw new FieldVisitException(e);
        }
    }

    public static void setProperty(Object owner, String name, Object value) {
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(name, ReflectionUtils.getClass(owner));
            Method setter = descriptor.getWriteMethod();
            ReflectionUtils.invoke(owner, setter, value);
        }
        catch (MethodInvocationException | IntrospectionException e) {
            ReflectionUtils.setField(owner, name, value);
        }
    }

    public static String toString(Method method) {
        if (method == null) {
            return StringUtils.normalize(null);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(method.getDeclaringClass().getSimpleName());
        builder.append('.');
        builder.append(method.getName());
        builder.append('(');
        Class<?>[] parameterClasses = method.getParameterTypes();
        if (parameterClasses.length > 0) {
            builder.append(parameterClasses[0].getSimpleName());
            for (int i = 1; i < parameterClasses.length; ++i) {
                builder.append(',').append(parameterClasses[i].getSimpleName());
            }
        }
        builder.append(')');
        builder.append(':');
        builder.append(method.getReturnType().getSimpleName());
        return builder.toString();
    }

    private static Class<?> getClass(Object owner) {
        return Validation.notNull(owner, "The owner to get class cannot be null.", new Object[0]) instanceof Class ? (Class<?>)owner : owner.getClass();
    }
}

