/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.Equalizer;
import com.huawei.fitframework.core.common.util.FunctionUtils;
import com.huawei.fitframework.core.common.util.ListNodeListAdapter;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final String FEATURE_ALLOW_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_ALLOW_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String FEATURE_ALLOW_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final Predicate<Node> PREDICATE_ELEMENT = node -> node instanceof Element;

    private XmlUtils() {
    }

    public static <T extends Node> T appendChild(Node parentNode, Function<Document, T> factory) {
        Validation.notNull(parentNode, "The parent node to append child node cannot be null.", new Object[0]);
        Validation.notNull(factory, "The factory to create child node cannot be null.", new Object[0]);
        Document document = parentNode instanceof Document ? (Document)parentNode : parentNode.getOwnerDocument();
        Validation.notNull(document, () -> new IllegalStateException("The XML node to create child does not belong to any document."));
        Node child = (Node)factory.apply(document);
        parentNode.appendChild(child);
        return (T)child;
    }

    public static Element appendElement(Node parentNode, String tagName) {
        Validation.notNull(parentNode, "The parent node to create child element cannot be null.", new Object[0]);
        Validation.notBlank(tagName, "The name of child tag to create cannot be blank.", new Object[0]);
        return XmlUtils.appendChild(parentNode, document -> document.createElement(tagName));
    }

    public static void appendText(Node parentNode, String text) {
        Validation.notNull(parentNode, "The parent node to append text cannot be null.", new Object[0]);
        if (StringUtils.isNotBlank(text)) {
            XmlUtils.appendChild(parentNode, document -> document.createTextNode(text));
        }
    }

    public static <T extends Node> T child(Node parentNode, String xpath) {
        if (StringUtils.isBlank(xpath)) {
            return (T)parentNode;
        }
        String[] path = StringUtils.split(xpath, '/');
        Node node = parentNode;
        for (int i = 0; i < path.length && node != null; ++i) {
            node = XmlUtils.firstElement(node.getChildNodes(), XmlUtils.predicateTagName(path[i], false));
        }
        return (T)node;
    }

    public static Document createDocument() {
        return XmlUtils.createDocumentBuilder().newDocument();
    }

    public static NodeList filter(NodeList nodes, Predicate<Node> predicate) {
        if (nodes == null) {
            return null;
        }
        Predicate<Node> actualPredicate = FunctionUtils.and(PREDICATE_ELEMENT, predicate);
        ArrayList<Node> matchedNodes = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!actualPredicate.test(node)) continue;
            matchedNodes.add(node);
        }
        return new ListNodeListAdapter(matchedNodes);
    }

    public static NodeList filterByAttribute(NodeList nodes, String attribute, String value) {
        return XmlUtils.filterByAttribute(nodes, attribute, value, false);
    }

    public static NodeList filterByAttribute(NodeList nodes, String attribute, String value, boolean ignoreCase) {
        Predicate<Node> predicate = XmlUtils.predicateAttribute(attribute, value, ignoreCase);
        return XmlUtils.filter(nodes, predicate);
    }

    public static NodeList filterByName(NodeList nodes, String name) {
        return XmlUtils.filterByName(nodes, name, false);
    }

    public static NodeList filterByName(NodeList nodes, String name, boolean ignoreCase) {
        return XmlUtils.filter(nodes, XmlUtils.predicateTagName(name, ignoreCase));
    }

    public static Node firstElement(NodeList nodes) {
        return XmlUtils.firstElement(nodes, null);
    }

    public static Node firstElement(NodeList nodes, Predicate<Node> predicate) {
        if (nodes != null && nodes.getLength() > 0) {
            Predicate<Node> actualPredicate = FunctionUtils.and(PREDICATE_ELEMENT, predicate);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!actualPredicate.test(node)) continue;
                return node;
            }
        }
        return null;
    }

    public static String getAttributeValue(Node node, String attribute) {
        if (node == null || StringUtils.isBlank(attribute)) {
            return null;
        }
        NamedNodeMap attributeNodes = node.getAttributes();
        if (attributeNodes == null) {
            return null;
        }
        Node attributeNode = attributeNodes.getNamedItem(attribute);
        return attributeNode == null ? null : attributeNode.getTextContent();
    }

    public static Document load(InputStream in) {
        try {
            return XmlUtils.createDocumentBuilder().parse(in);
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException("Fail to parse XML from the input stream.", e);
        }
    }

    private static void configureSecurity(DocumentBuilderFactory factory) {
        factory.setExpandEntityReferences(false);
        XmlUtils.configureSecurity((String feature, boolean value) -> {
            try {
                factory.setFeature(feature, value);
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(StringUtils.format("Fail to {0} feature for document builder factory. [feature={1}]", XmlUtils.operation(value), feature), e);
            }
        });
    }

    private static void configureSecurity(FeatureConfigurator factory) {
        factory.configure(FEATURE_DISALLOW_DOCTYPE_DECL, true);
        factory.configure(FEATURE_ALLOW_EXTERNAL_GENERAL_ENTITIES, false);
        factory.configure(FEATURE_ALLOW_EXTERNAL_PARAMETER_ENTITIES, false);
        factory.configure("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.configure(FEATURE_ALLOW_LOAD_EXTERNAL_DTD, false);
    }

    private static DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        XmlUtils.configureSecurity(factory);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Fail to create document builder.", e);
        }
    }

    private static String operation(boolean value) {
        return value ? "enable" : "disable";
    }

    private static Predicate<Node> predicateAttribute(String attribute, String value, boolean ignoreCase) {
        Equalizer<String> equalizer = StringUtils.equalizer(ignoreCase);
        return node -> equalizer.equals(XmlUtils.getAttributeValue(node, attribute), value);
    }

    private static Predicate<Node> predicateTagName(String name, boolean ignoreCase) {
        Equalizer<String> equalizer = StringUtils.equalizer(ignoreCase);
        return node -> equalizer.equals(node.getNodeName(), name);
    }

    @FunctionalInterface
    private static interface FeatureConfigurator {
        public void configure(String var1, boolean var2);
    }
}

