/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.Disposable;
import com.huawei.fitframework.core.common.util.DisposedCallback;
import com.huawei.fitframework.core.common.util.support.DisposedCallbackGroup;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractDisposable
implements Disposable {
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final AtomicReference<DisposedCallback> disposedCallback = new AtomicReference();

    @Override
    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.onDisposed();
        }
    }

    @Override
    public boolean disposed() {
        return this.disposed.get();
    }

    @Override
    public void subscribe(DisposedCallback callback) {
        this.disposedCallback.getAndUpdate(current -> DisposedCallbackGroup.combine(current, callback));
    }

    @Override
    public void unsubscribe(DisposedCallback callback) {
        this.disposedCallback.getAndUpdate(current -> DisposedCallbackGroup.remove(current, callback));
    }

    protected void onDisposed() {
        DisposedCallback callback = this.disposedCallback.get();
        if (callback != null) {
            callback.onDisposed(this);
        }
    }
}

