/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.Validation;
import java.util.Iterator;
import java.util.function.Function;

public class MappedIterator<F, T>
implements Iterator<T> {
    private final Iterator<F> origin;
    private final Function<F, T> mapper;

    public MappedIterator(Iterator<F> origin, Function<F, T> mapper) {
        this.origin = Validation.notNull(origin, "The origin iterator to map cannot be null.", new Object[0]);
        this.mapper = Validation.notNull(mapper, "The mapper to map iterating values cannot be null.", new Object[0]);
    }

    @Override
    public boolean hasNext() {
        return this.origin.hasNext();
    }

    @Override
    public T next() {
        return this.mapper.apply(this.origin.next());
    }
}

