/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.collect.dstorage.service;

import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.collect.dstorage.entity.SubTaskDetail;
import com.huawei.ism.tool.service.common.server.RestWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServer
extends Observable {
    private static final Logger log = LoggerFactory.getLogger(DownloadServer.class);
    public static final DownloadServer INS = new DownloadServer();
    private static final String DOWNLOAD_FAILED = "collect.subTask.file.down.failed";
    private final ExecutorService pool = Executors.newFixedThreadPool(10);

    public CompletableFuture<TaskResult> supplyAsync(DevNode node, SubTaskDetail task) {
        return CompletableFuture.supplyAsync(() -> this.download(node, task), this.pool).whenCompleteAsync((ret, ex) -> this.handleRet(task, (TaskResult)ret, (Throwable)ex));
    }

    private TaskResult handleRet(SubTaskDetail task, TaskResult ret, Throwable ex) {
        if (ex == null) {
            this.updateDetail(task, ret);
            return ret;
        }
        if (ex instanceof RejectedExecutionException && !this.pool.isShutdown()) {
            log.warn("Executor pool rejected exec download task, task canceled.");
            return new TaskResult(TaskResult.Result.CANCELED);
        }
        log.error("Do download task failed", ex);
        String errMsg = this.downloadFailedMsg(task);
        task.fail(errMsg);
        return TaskResult.fail((String)errMsg);
    }

    private void updateDetail(SubTaskDetail task, TaskResult result) {
        if (!result.isTaskSuccess()) {
            task.fail(result.getErrorLocaleDescription());
            return;
        }
        task.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult download(DevNode node, SubTaskDetail info) {
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName(this.getDownloadThreadName(node, info));
        RestWrapper restWrapper = new RestWrapper(node).errMsg(DOWNLOAD_FAILED, info.getParentId(), info.getId());
        try {
            if (!info.isPacked()) {
                TaskResult taskResult = TaskResult.fail((String)this.downloadFailedMsg(info));
                return taskResult;
            }
            long startTime = System.currentTimeMillis();
            String url = RestUtil.getSubTaskResultFileUri((DevNode)node);
            restWrapper.execGetFile(url, this.buildSubTaskReqParam(info), info.getLocalPath());
            log.info("Download file cost : {} second", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        }
        catch (ToolException e) {
            TaskResult taskResult = TaskResult.fail((String)this.downloadFailedMsg(info));
            return taskResult;
        }
        finally {
            Thread.currentThread().setName(name);
        }
        return TaskResult.success((Object)"");
    }

    private String getDownloadThreadName(DevNode node, SubTaskDetail taskInfo) {
        return String.join((CharSequence)"_", "DownloadTask", node.getIp(), taskInfo.getParentId(), taskInfo.getId());
    }

    private String downloadFailedMsg(SubTaskDetail task) {
        return ResourceUtil.getStringWithParams(DOWNLOAD_FAILED, task.getParentId(), task.getId());
    }

    private Map<String, Object> buildSubTaskReqParam(SubTaskDetail subTask) {
        HashMap<String, Object> reqPara = new HashMap<String, Object>();
        reqPara.put("task_id", subTask.getParentId());
        reqPara.put("sub_task_id", subTask.getId());
        return reqPara;
    }
}

