/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common.util;

import com.alibaba.excel.annotation.ExcelProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class ExcelPropertyResourceUtil {
    public static void setInternationalizedHeader(Class<?> clazz, ResourceBundle resourceBundle) {
        Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(ExcelProperty.class)).map(field -> field.getAnnotation(ExcelProperty.class)).forEach(excelProperty -> ExcelPropertyResourceUtil.alterAnnotationValue((Annotation)excelProperty, ExcelPropertyResourceUtil.mapExcelPropertyValue2InternationValue(resourceBundle, excelProperty)));
    }

    @NonNull
    public static String getString(ResourceBundle resourceBundle, String key) {
        if (!resourceBundle.containsKey(key)) {
            return key;
        }
        return resourceBundle.getString(key);
    }

    @NonNull
    private static String[] mapExcelPropertyValue2InternationValue(ResourceBundle resourceBundle, ExcelProperty excelProperty) {
        return Arrays.stream(excelProperty.value()).map(key -> ExcelPropertyResourceUtil.getString(resourceBundle, key)).collect(Collectors.toList()).toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void alterAnnotationValue(Annotation annotation, Object newValue) {
        Field field;
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        try {
            field = handler.getClass().getDeclaredField("memberValues");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        boolean opened = false;
        try {
            Map memberValues;
            if (!field.isAccessible()) {
                field.setAccessible(true);
                opened = true;
            }
            try {
                memberValues = (Map)field.get(handler);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            memberValues.put("value", newValue);
        }
        finally {
            if (opened) {
                field.setAccessible(false);
            }
        }
    }

    private ExcelPropertyResourceUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

