/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.pattern;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class WildcardUtil {
    private static final String REGEX_CHARS = ".^$+{[]|()";
    private static final String WILDCARD_CHARS = "\\*?[{";

    public static boolean matches(@NotNull String wildcard, @NotNull String content) {
        return Pattern.compile(WildcardUtil.convertToRegex(wildcard)).matcher(content).matches();
    }

    public static String convertToRegex(@NotNull String wildcard) {
        StringBuilder regex = new StringBuilder("^");
        StringBuilder quoteContent = new StringBuilder(0);
        boolean inGroup = false;
        int index = 0;
        block10: while (index < wildcard.length()) {
            char currChar = wildcard.charAt(index++);
            switch (currChar) {
                case '\\': {
                    char nextChar;
                    if (index == wildcard.length()) {
                        throw new PatternSyntaxException("Unused escape char", wildcard, index - 1);
                    }
                    if (REGEX_CHARS.indexOf(nextChar = wildcard.charAt(index++)) != -1 || WILDCARD_CHARS.indexOf(nextChar) != -1) {
                        regex.append('\\');
                    }
                    regex.append(nextChar);
                    continue block10;
                }
                case '\'': {
                    if (index == wildcard.length()) {
                        throw new PatternSyntaxException("Unclosed quote", wildcard, index - 1);
                    }
                    if (WildcardUtil.next(wildcard, index) == '\'') {
                        ++index;
                        continue block10;
                    }
                    while (index < wildcard.length() && (currChar = wildcard.charAt(index++)) != '\'') {
                        quoteContent.append(currChar);
                    }
                    if (currChar != '\'') {
                        throw new PatternSyntaxException("Unclosed quote", wildcard, index - 1);
                    }
                    regex.append(Pattern.quote(quoteContent.toString()));
                    quoteContent.setLength(0);
                    continue block10;
                }
                case '[': {
                    regex.append('[');
                    if (WildcardUtil.next(wildcard, index) == '^') {
                        regex.append("\\^");
                        ++index;
                    } else {
                        if (WildcardUtil.next(wildcard, index) == '!') {
                            regex.append('^');
                            ++index;
                        }
                        if (WildcardUtil.next(wildcard, index) == '-') {
                            regex.append('-');
                            ++index;
                        }
                    }
                    boolean inRange = false;
                    char rangeStartChar = '\u0000';
                    while (index < wildcard.length() && (currChar = wildcard.charAt(index++)) != ']') {
                        if (currChar == '\\' && WildcardUtil.next(wildcard, index) == ']') {
                            regex.append("\\]");
                            ++index;
                            continue;
                        }
                        if (currChar == '\\' || currChar == '[' || currChar == '&' && WildcardUtil.next(wildcard, index) == '&') {
                            regex.append('\\');
                        }
                        regex.append(currChar);
                        if (currChar == '-') {
                            if (!inRange) {
                                throw new PatternSyntaxException("Invalid range", wildcard, index - 1);
                            }
                            if ((currChar = WildcardUtil.next(wildcard, index++)) == '\u0000' || currChar == ']') break;
                            if (currChar < rangeStartChar) {
                                throw new PatternSyntaxException("Invalid range", wildcard, index - 3);
                            }
                            regex.append(currChar);
                            inRange = false;
                            continue;
                        }
                        inRange = true;
                        rangeStartChar = currChar;
                    }
                    if (currChar != ']') {
                        throw new PatternSyntaxException("Unclosed range", wildcard, index - 1);
                    }
                    regex.append(']');
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new PatternSyntaxException("Nested group", wildcard, index - 1);
                    }
                    regex.append("(?:(?:");
                    inGroup = true;
                    continue block10;
                }
                case '}': {
                    if (inGroup) {
                        regex.append("))");
                        inGroup = false;
                        continue block10;
                    }
                    regex.append('}');
                    continue block10;
                }
                case ',': {
                    if (inGroup) {
                        regex.append(")|(?:");
                        continue block10;
                    }
                    regex.append(',');
                    continue block10;
                }
                case '*': {
                    regex.append(".*");
                    continue block10;
                }
                case '?': {
                    regex.append('.');
                    continue block10;
                }
            }
            if (REGEX_CHARS.indexOf(currChar) != -1) {
                regex.append('\\');
            }
            regex.append(currChar);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Unclosed group", wildcard, index - 1);
        }
        return regex.append('$').toString();
    }

    private static char next(String pattern, int index) {
        return index < pattern.length() ? pattern.charAt(index) : (char)'\u0000';
    }

    private WildcardUtil() {
    }
}

