/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.controller;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.model.entity.vo.ProductVO;
import com.huawei.ism.tool.service.rest.model.entity.vo.SystemInfoVO;
import com.huawei.ism.tool.service.rest.service.IToolObs;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system"})
public class SystemController {
    private static final String HAS_RUNNING_TASK_TIP = ResourceUtil.getString("tool.close.waring");
    private final IToolObs toolObs;

    SystemController(IToolObs toolObs) {
        this.toolObs = toolObs;
    }

    @GetMapping(value={"/info"})
    public Response<SystemInfoVO> querySystemInfo() {
        return Response.success(SystemInfoVO.getInstance());
    }

    @GetMapping(value={"/support/products"})
    public Response<List<ProductVO>> querySupportProductsInfo() {
        return Response.success(ProductVO.buildProductsInfo(this.toolObs.getSupportProducts()));
    }

    @DeleteMapping
    public Response<String> shutdown() {
        Response<String> response = this.queryCloseable();
        if (this.queryCloseable().isFailed()) {
            return response;
        }
        this.toolObs.shutdown();
        return Response.success("");
    }

    @GetMapping(value={"/closeable"})
    public Response<String> queryCloseable() {
        if (this.toolObs.hasRunningTask()) {
            return Response.fail(HAS_RUNNING_TASK_TIP);
        }
        return Response.success("");
    }

    @GetMapping(value={"/guidance"})
    public Response<String> guidance() {
        return Response.success(this.toolObs.getHelpPath());
    }

    @DeleteMapping(value={"/force"})
    public Response<Void> forceShutdown() {
        this.toolObs.shutdown();
        return Response.success();
    }

    @GetMapping(value={"/ready"})
    public Response<Boolean> checkApplicationReady() {
        return Response.success(true);
    }

    @GetMapping(value={"/language"})
    public Response<String> queryLanguage() {
        return Response.success(ApplicationContext.getInstance().getCurrentLanguage().toString());
    }
}

